/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.light.LightClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeCorrector
extends PsiTypeMapper {
    private final Map<PsiClassType, PsiClassType> myResultMap = new IdentityHashMap<PsiClassType, PsiClassType>();
    private final GlobalSearchScope myResolveScope;

    TypeCorrector(GlobalSearchScope resolveScope) {
        this.myResolveScope = resolveScope;
    }

    @Override
    public PsiType visitType(@NotNull PsiType type2) {
        if (LambdaUtil.notInferredType((PsiType)type2)) {
            return type2;
        }
        return super.visitType(type2);
    }

    @Nullable
    public <T extends PsiType> T correctType(@NotNull T type2) {
        PsiClass mappedClass;
        PsiClassType.ClassResolveResult classResolveResult;
        PsiClass psiClass;
        PsiClassType classType;
        if (type2 instanceof PsiClassType && (classType = (PsiClassType)type2).getParameterCount() == 0 && (psiClass = (classResolveResult = classType.resolveGenerics()).getElement()) != null && classResolveResult.getSubstitutor() == PsiSubstitutor.EMPTY && ((mappedClass = PsiSuperMethodUtil.correctClassByScope((PsiClass)psiClass, (GlobalSearchScope)this.myResolveScope)) == null || mappedClass == psiClass)) {
            return (T)classType;
        }
        return (T)((PsiType)type2.accept((PsiTypeVisitor)this));
    }

    @Override
    public PsiType visitClassType(@NotNull PsiClassType classType) {
        if (classType instanceof PsiCorrectedClassType) {
            return this.myResolveScope.equals(classType.getResolveScope()) ? classType : this.visitClassType(((PsiCorrectedClassType)classType).myDelegate);
        }
        PsiClassType alreadyComputed = this.myResultMap.get(classType);
        if (alreadyComputed != null) {
            return alreadyComputed;
        }
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiClass psiClass = classResolveResult.getElement();
        PsiSubstitutor substitutor = classResolveResult.getSubstitutor();
        if (psiClass == null) {
            return classType;
        }
        if (psiClass instanceof LightClass) {
            return classType;
        }
        PsiUtilCore.ensureValid((PsiElement)psiClass);
        PsiClass mappedClass = PsiSuperMethodUtil.correctClassByScope((PsiClass)psiClass, (GlobalSearchScope)this.myResolveScope);
        if (mappedClass == null) {
            return classType;
        }
        PsiCorrectedClassType mappedType = new PsiCorrectedClassType(classType.getLanguageLevel(), classType, new CorrectedResolveResult(psiClass, mappedClass, substitutor, classResolveResult));
        this.myResultMap.put(classType, (PsiClassType)mappedType);
        return mappedType;
    }

    @NotNull
    private PsiSubstitutor mapSubstitutor(PsiClass originalClass, PsiClass mappedClass, PsiSubstitutor substitutor) {
        PsiClass originalContaining;
        PsiTypeParameter[] originalTypeParameters;
        PsiTypeParameter[] typeParameters = mappedClass.getTypeParameters();
        if (typeParameters.length != (originalTypeParameters = originalClass.getTypeParameters()).length) {
            if (originalTypeParameters.length == 0) {
                return JavaPsiFacade.getElementFactory((Project)mappedClass.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)mappedClass);
            }
            return substitutor;
        }
        Map substitutionMap = substitutor.getSubstitutionMap();
        PsiSubstitutor mappedSubstitutor = PsiSubstitutor.EMPTY;
        for (int i = 0; i < originalTypeParameters.length; ++i) {
            if (!substitutionMap.containsKey(originalTypeParameters[i])) continue;
            PsiType originalSubstitute = substitutor.substitute(originalTypeParameters[i]);
            if (originalSubstitute != null) {
                PsiType substitute = this.mapType(originalSubstitute);
                if (substitute == null) {
                    return substitutor;
                }
                mappedSubstitutor = mappedSubstitutor.put(typeParameters[i], substitute);
                continue;
            }
            mappedSubstitutor = mappedSubstitutor.put(typeParameters[i], null);
        }
        if (mappedClass.hasModifierProperty("static")) {
            return mappedSubstitutor;
        }
        PsiClass mappedContaining = mappedClass.getContainingClass();
        if (mappedContaining != null != ((originalContaining = originalClass.getContainingClass()) != null)) {
            return substitutor;
        }
        if (mappedContaining != null) {
            return mappedSubstitutor.putAll(this.mapSubstitutor(originalContaining, mappedContaining, substitutor));
        }
        return mappedSubstitutor;
    }

    private class CorrectedResolveResult
    implements PsiClassType.ClassResolveResult {
        private final PsiClass myPsiClass;
        private final PsiClass myMappedClass;
        private final PsiSubstitutor mySubstitutor;
        private final PsiClassType.ClassResolveResult myClassResolveResult;
        private volatile PsiSubstitutor myLazySubstitutor;

        CorrectedResolveResult(PsiClass psiClass, PsiClass mappedClass, PsiSubstitutor substitutor, PsiClassType.ClassResolveResult classResolveResult) {
            this.myPsiClass = psiClass;
            this.myMappedClass = mappedClass;
            this.mySubstitutor = substitutor;
            this.myClassResolveResult = classResolveResult;
        }

        @NotNull
        public PsiSubstitutor getSubstitutor() {
            PsiSubstitutor result = this.myLazySubstitutor;
            if (result == null) {
                this.myLazySubstitutor = result = TypeCorrector.this.mapSubstitutor(this.myPsiClass, this.myMappedClass, this.mySubstitutor);
            }
            return result;
        }

        public PsiClass getElement() {
            return this.myMappedClass;
        }

        public boolean isPackagePrefixPackageReference() {
            return this.myClassResolveResult.isPackagePrefixPackageReference();
        }

        public boolean isAccessible() {
            return this.myClassResolveResult.isAccessible();
        }

        public boolean isStaticsScopeCorrect() {
            return this.myClassResolveResult.isStaticsScopeCorrect();
        }

        public PsiElement getCurrentFileResolveScope() {
            return this.myClassResolveResult.getCurrentFileResolveScope();
        }

        public boolean isValidResult() {
            return this.myClassResolveResult.isValidResult();
        }
    }

    private class PsiCorrectedClassType
    extends PsiClassType.Stub {
        private final PsiClassType myDelegate;
        private final CorrectedResolveResult myResolveResult;

        private PsiCorrectedClassType(LanguageLevel languageLevel, PsiClassType delegate, CorrectedResolveResult resolveResult) {
            super(languageLevel, delegate.getAnnotationProvider());
            if (delegate instanceof PsiCorrectedClassType) {
                throw new IllegalArgumentException();
            }
            this.myDelegate = delegate;
            this.myResolveResult = resolveResult;
        }

        @NotNull
        public PsiClass resolve() {
            return this.myResolveResult.myMappedClass;
        }

        public String getClassName() {
            return this.myDelegate.getClassName();
        }

        @Nullable
        public PsiElement getPsiContext() {
            return this.myDelegate.getPsiContext();
        }

        public PsiType @NotNull [] getParameters() {
            return (PsiType[])ContainerUtil.map2Array((Object[])this.myDelegate.getParameters(), PsiType.class, type2 -> {
                if (type2 == null) {
                    LOG.error(this.myDelegate + " of " + this.myDelegate.getClass() + "; substitutor=" + this.myDelegate.resolveGenerics().getSubstitutor());
                    return null;
                }
                return TypeCorrector.this.mapType(type2);
            });
        }

        public int getParameterCount() {
            return this.myDelegate.getParameters().length;
        }

        @NotNull
        public PsiClassType.ClassResolveResult resolveGenerics() {
            return this.myResolveResult;
        }

        @NotNull
        public PsiClassType rawType() {
            PsiClass psiClass = this.resolve();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
            return factory.createType(psiClass, factory.createRawSubstitutor((PsiTypeParameterListOwner)psiClass));
        }

        @NotNull
        public GlobalSearchScope getResolveScope() {
            return TypeCorrector.this.myResolveScope;
        }

        @NotNull
        public LanguageLevel getLanguageLevel() {
            return this.myLanguageLevel;
        }

        @NotNull
        public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
            return new PsiCorrectedClassType(languageLevel, this.myDelegate, this.myResolveResult);
        }

        @NotNull
        public PsiClassType annotate(@NotNull TypeAnnotationProvider provider) {
            PsiClassType newDelegate = this.myDelegate.annotate(provider);
            return newDelegate == this.myDelegate ? this : new PsiCorrectedClassType(this.myLanguageLevel, newDelegate, this.myResolveResult);
        }

        @NotNull
        public String getPresentableText(boolean annotated) {
            return this.myDelegate.getPresentableText(annotated);
        }

        @NotNull
        public String getCanonicalText(boolean annotated) {
            return this.myDelegate.getCanonicalText(annotated);
        }

        @NotNull
        public String getInternalCanonicalText() {
            return this.myDelegate.getInternalCanonicalText();
        }

        public boolean isValid() {
            return this.myDelegate.isValid() && this.myResolveResult.myMappedClass.isValid() && this.myResolveResult.mySubstitutor.isValid();
        }

        public boolean equalsToText(@NotNull @NonNls String text2) {
            return this.myDelegate.equalsToText(text2);
        }
    }
}

