/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.java.stubs.index.JavaFieldNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaMethodNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaShortClassNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiShortNamesCacheImpl
extends PsiShortNamesCache {
    private final Project myProject;

    public PsiShortNamesCacheImpl(Project project) {
        this.myProject = project;
    }

    public PsiFile @NotNull [] getFilesByName(@NotNull String name2) {
        return FilenameIndex.getFilesByName((Project)this.myProject, (String)name2, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject));
    }

    public String @NotNull [] getAllFileNames() {
        return FilenameIndex.getAllFilenames((Project)this.myProject);
    }

    public PsiClass @NotNull [] getClassesByName(@NotNull String name2, @NotNull GlobalSearchScope scope) {
        Collection<PsiClass> classes2 = JavaShortClassNameIndex.getInstance().get(name2, this.myProject, scope);
        if (classes2.isEmpty()) {
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(classes2.size());
        THashMap uniqueQName2Classes = new THashMap(classes2.size());
        Set hiddenClassesToRemove = null;
        block0: for (PsiClass aClass : classes2) {
            VirtualFile vFile = aClass.getContainingFile().getVirtualFile();
            if (!scope.contains(vFile)) continue;
            String qName = aClass.getQualifiedName();
            if (qName != null) {
                List previousQNamedClasses = (List)uniqueQName2Classes.get(qName);
                SmartList qNamedClasses = new SmartList();
                if (previousQNamedClasses != null) {
                    for (PsiClass previousClass : previousQNamedClasses) {
                        VirtualFile previousClassVFile = previousClass.getContainingFile().getVirtualFile();
                        int res = scope.compare(previousClassVFile, vFile);
                        if (res > 0) continue block0;
                        if (res < 0) {
                            if (hiddenClassesToRemove == null) {
                                hiddenClassesToRemove = new THashSet();
                            }
                            hiddenClassesToRemove.add(previousClass);
                            qNamedClasses.add(aClass);
                            continue;
                        }
                        qNamedClasses.add(aClass);
                    }
                } else {
                    qNamedClasses.add(aClass);
                }
                uniqueQName2Classes.put(qName, qNamedClasses);
            }
            result.add(aClass);
        }
        if (hiddenClassesToRemove != null) {
            result.removeAll(hiddenClassesToRemove);
        }
        return result.toArray(PsiClass.EMPTY_ARRAY);
    }

    public String @NotNull [] getAllClassNames() {
        return ArrayUtilRt.toStringArray((Collection)JavaShortClassNameIndex.getInstance().getAllKeys(this.myProject));
    }

    public boolean processAllClassNames(@NotNull Processor<? super String> processor2) {
        return JavaShortClassNameIndex.getInstance().processAllKeys(this.myProject, processor2);
    }

    public boolean processAllClassNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope, IdFilter filter) {
        return StubIndex.getInstance().processAllKeys(JavaStubIndexKeys.CLASS_SHORT_NAMES, processor2, scope, filter);
    }

    public boolean processAllMethodNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope, IdFilter filter) {
        return StubIndex.getInstance().processAllKeys(JavaStubIndexKeys.METHODS, processor2, scope, filter);
    }

    public boolean processAllFieldNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope, IdFilter filter) {
        return StubIndex.getInstance().processAllKeys(JavaStubIndexKeys.FIELDS, processor2, scope, filter);
    }

    public PsiMethod @NotNull [] getMethodsByName(@NotNull String name2, @NotNull GlobalSearchScope scope) {
        Collection<PsiMethod> methods = JavaMethodNameIndex.getInstance().get(name2, this.myProject, scope);
        return (PsiMethod[])this.filterMembers(methods, scope, (PsiMember[])PsiMethod.EMPTY_ARRAY);
    }

    public PsiMethod @NotNull [] getMethodsByNameIfNotMoreThan(@NotNull String name2, @NotNull GlobalSearchScope scope, int maxCount) {
        SmartList methods = new SmartList();
        CommonProcessors.CollectProcessor<PsiMethod> processor2 = new CommonProcessors.CollectProcessor<PsiMethod>((Collection)methods, (List)methods, maxCount){
            final /* synthetic */ List val$methods;
            final /* synthetic */ int val$maxCount;
            {
                this.val$methods = list;
                this.val$maxCount = n;
                super(x0);
            }

            public boolean process(PsiMethod method) {
                return this.val$methods.size() != this.val$maxCount && super.process((Object)method);
            }
        };
        StubIndex.getInstance().processElements(JavaStubIndexKeys.METHODS, (Object)name2, this.myProject, scope, PsiMethod.class, (Processor)processor2);
        return (PsiMethod[])this.filterMembers((Collection)methods, scope, (PsiMember[])PsiMethod.EMPTY_ARRAY);
    }

    public boolean processMethodsWithName(@NotNull String name2, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiMethod> processor2) {
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.METHODS, (Object)name2, this.myProject, scope, PsiMethod.class, processor2);
    }

    public String @NotNull [] getAllMethodNames() {
        return ArrayUtilRt.toStringArray((Collection)JavaMethodNameIndex.getInstance().getAllKeys(this.myProject));
    }

    public PsiField @NotNull [] getFieldsByNameIfNotMoreThan(@NotNull String name2, @NotNull GlobalSearchScope scope, int maxCount) {
        SmartList fields = new SmartList();
        CommonProcessors.CollectProcessor<PsiField> processor2 = new CommonProcessors.CollectProcessor<PsiField>((Collection)fields, (List)fields, maxCount){
            final /* synthetic */ List val$fields;
            final /* synthetic */ int val$maxCount;
            {
                this.val$fields = list;
                this.val$maxCount = n;
                super(x0);
            }

            public boolean process(PsiField method) {
                return this.val$fields.size() != this.val$maxCount && super.process((Object)method);
            }
        };
        StubIndex.getInstance().processElements(JavaStubIndexKeys.FIELDS, (Object)name2, this.myProject, scope, PsiField.class, (Processor)processor2);
        return (PsiField[])this.filterMembers((Collection)fields, scope, (PsiMember[])PsiField.EMPTY_ARRAY);
    }

    public PsiField @NotNull [] getFieldsByName(@NotNull String name2, @NotNull GlobalSearchScope scope) {
        Collection<PsiField> fields = JavaFieldNameIndex.getInstance().get(name2, this.myProject, scope);
        return (PsiField[])this.filterMembers(fields, scope, (PsiMember[])PsiField.EMPTY_ARRAY);
    }

    public String @NotNull [] getAllFieldNames() {
        return ArrayUtilRt.toStringArray((Collection)JavaFieldNameIndex.getInstance().getAllKeys(this.myProject));
    }

    public boolean processFieldsWithName(@NotNull String name2, @NotNull Processor<? super PsiField> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.FIELDS, (Object)name2, this.myProject, (GlobalSearchScope)new JavaSourceFilterScope(scope), filter, PsiField.class, processor2);
    }

    public boolean processMethodsWithName(@NotNull String name2, @NotNull Processor<? super PsiMethod> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.METHODS, (Object)name2, this.myProject, (GlobalSearchScope)new JavaSourceFilterScope(scope), filter, PsiMethod.class, processor2);
    }

    public boolean processClassesWithName(@NotNull String name2, @NotNull Processor<? super PsiClass> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.CLASS_SHORT_NAMES, (Object)name2, this.myProject, (GlobalSearchScope)new JavaSourceFilterScope(scope), filter, PsiClass.class, processor2);
    }

    private <T extends PsiMember> T @NotNull [] filterMembers(@NotNull Collection<T> members, @NotNull GlobalSearchScope scope, T @NotNull [] emptyArray) {
        if (members.isEmpty()) {
            return emptyArray;
        }
        final PsiManager myManager = PsiManager.getInstance((Project)this.myProject);
        THashSet set = new THashSet(members.size(), (TObjectHashingStrategy)new TObjectHashingStrategy<PsiMember>(){

            public int computeHashCode(PsiMember member) {
                int code = 0;
                PsiClass clazz = member.getContainingClass();
                if (clazz != null) {
                    String name2 = clazz.getName();
                    code = name2 != null ? (code += name2.hashCode()) : (code += clazz.hashCode());
                }
                if (member instanceof PsiMethod) {
                    code += 37 * ((PsiMethod)member).getParameterList().getParametersCount();
                }
                return code;
            }

            public boolean equals(PsiMember object, PsiMember object1) {
                return myManager.areElementsEquivalent((PsiElement)object, (PsiElement)object1);
            }
        });
        ArrayList<PsiMember> result = new ArrayList<PsiMember>(members.size());
        for (PsiMember member : members) {
            ProgressIndicatorProvider.checkCanceled();
            if (!scope.contains(member.getContainingFile().getVirtualFile()) || !set.add(member)) continue;
            result.add(member);
        }
        return (PsiMember[])result.toArray(emptyArray);
    }
}

