/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.light.LightClassReferenceExpression;
import com.intellij.psi.impl.light.LightClassTypeReference;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightKeyword;
import com.intellij.psi.impl.light.LightPackageReference;
import com.intellij.psi.impl.light.LightPackageReferenceExpression;
import com.intellij.psi.impl.light.LightTypeElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiElementFactoryImpl
extends PsiJavaParserFacadeImpl
implements PsiElementFactory {
    private final ConcurrentMap<LanguageLevel, PsiClass> myArrayClasses = new ConcurrentHashMap<LanguageLevel, PsiClass>();
    private final ConcurrentMap<GlobalSearchScope, PsiClassType> myCachedObjectType = ContainerUtil.createConcurrentSoftMap();
    private static final JavaParserUtil.ParserWrapper CATCH_SECTION = builder -> JavaParser.INSTANCE.getStatementParser().parseCatchBlock(builder);

    public PsiElementFactoryImpl(@NotNull Project project) {
        super(project);
        ((PsiManagerEx)this.myManager).registerRunnableToRunOnChange(this.myCachedObjectType::clear);
    }

    @NotNull
    public PsiClass getArrayClass(@NotNull LanguageLevel languageLevel) {
        return this.myArrayClasses.computeIfAbsent(languageLevel, this::createArrayClass);
    }

    private PsiClass createArrayClass(LanguageLevel level) {
        String text2 = level.isAtLeast(LanguageLevel.JDK_1_5) ? "public class __Array__<T> {\n public final int length;\n public T[] clone() {}\n}" : "public class __Array__{\n public final int length;\n public Object clone() {}\n}";
        PsiClass psiClass = ((PsiExtensibleClass)this.createClassFromText(text2, null)).getOwnInnerClasses().get(0);
        PsiElementFactoryImpl.ensureNonWritable(psiClass);
        PsiFile file = psiClass.getContainingFile();
        file.clearCaches();
        PsiUtil.FILE_LANGUAGE_LEVEL_KEY.set((UserDataHolder)file, (Object)level);
        return psiClass;
    }

    private static void ensureNonWritable(PsiClass arrayClass) {
        try {
            arrayClass.getContainingFile().getViewProvider().getVirtualFile().setWritable(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    public PsiClassType getArrayClassType(@NotNull PsiType componentType, @NotNull LanguageLevel languageLevel) {
        PsiClass arrayClass = this.getArrayClass(languageLevel);
        PsiTypeParameter[] typeParameters = arrayClass.getTypeParameters();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (typeParameters.length == 1) {
            substitutor = substitutor.put(typeParameters[0], componentType);
        }
        return this.createType(arrayClass, substitutor);
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor substitutor) {
        return new PsiImmediateClassType(resolve2, substitutor);
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor substitutor, @Nullable LanguageLevel languageLevel) {
        return new PsiImmediateClassType(resolve2, substitutor, languageLevel);
    }

    @NotNull
    public PsiClass createClass(@NotNull String name2) throws IncorrectOperationException {
        return this.createClassInner("class", name2);
    }

    @NotNull
    public PsiClass createInterface(@NotNull String name2) throws IncorrectOperationException {
        return this.createClassInner("interface", name2);
    }

    @NotNull
    public PsiClass createEnum(@NotNull String name2) throws IncorrectOperationException {
        return this.createClassInner("enum", name2);
    }

    @NotNull
    public PsiClass createAnnotationType(@NotNull String name2) throws IncorrectOperationException {
        return this.createClassInner("@interface", name2);
    }

    private PsiClass createClassInner(String type2, String name2) {
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name2);
        PsiJavaFile aFile = this.createDummyJavaFile("public " + type2 + " " + name2 + " { }");
        PsiClass[] classes2 = aFile.getClasses();
        if (classes2.length != 1) {
            throw new IncorrectOperationException("Incorrect " + type2 + " name \"" + name2 + "\".");
        }
        return classes2[0];
    }

    @NotNull
    public PsiTypeElement createTypeElement(@NotNull PsiType psiType) {
        LightTypeElement element = new LightTypeElement(this.myManager, psiType);
        CodeEditUtil.setNodeGenerated((ASTNode)element.getNode(), (boolean)true);
        return element;
    }

    @NotNull
    public PsiJavaCodeReferenceElement createReferenceElementByType(@NotNull PsiClassType type2) {
        return type2 instanceof PsiClassReferenceType ? ((PsiClassReferenceType)type2).getReference() : new LightClassTypeReference(this.myManager, type2);
    }

    @NotNull
    public PsiTypeParameterList createTypeParameterList() {
        PsiTypeParameterList parameterList = this.createMethodFromText("void foo()", null).getTypeParameterList();
        assert (parameterList != null);
        return parameterList;
    }

    @NotNull
    public PsiTypeParameter createTypeParameter(@NotNull String name2, PsiClassType @NotNull [] superTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append("public <").append(name2);
        if (superTypes.length > 1 || superTypes.length == 1 && !superTypes[0].equalsToText("java.lang.Object")) {
            builder.append(" extends ");
            for (PsiClassType type2 : superTypes) {
                if (type2.equalsToText("java.lang.Object")) continue;
                builder.append(type2.getCanonicalText(true)).append('&');
            }
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append("> void foo(){}");
        try {
            return this.createMethodFromText(builder.toString(), null).getTypeParameters()[0];
        }
        catch (RuntimeException e) {
            throw new IncorrectOperationException("type parameter text: " + builder, (Throwable)e);
        }
    }

    @NotNull
    public PsiField createField(@NotNull String name2, @NotNull PsiType type2) throws IncorrectOperationException {
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name2);
        if (PsiType.NULL.equals((Object)type2)) {
            throw new IncorrectOperationException("Cannot create field with type \"null\".");
        }
        String text2 = "class _Dummy_ { private " + GenericsUtil.getVariableTypeByExpressionType((PsiType)type2).getCanonicalText(true) + " " + name2 + "; }";
        PsiJavaFile aFile = this.createDummyJavaFile(text2);
        PsiClass[] classes2 = aFile.getClasses();
        if (classes2.length < 1) {
            throw new IncorrectOperationException("Class was not created " + text2);
        }
        PsiClass psiClass = classes2[0];
        PsiField[] fields = psiClass.getFields();
        if (fields.length < 1) {
            throw new IncorrectOperationException("Field was not created " + text2);
        }
        PsiField field = fields[0];
        field = (PsiField)JavaCodeStyleManager.getInstance((Project)this.myManager.getProject()).shortenClassReferences((PsiElement)field);
        return (PsiField)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)field);
    }

    @NotNull
    public PsiMethod createMethod(@NotNull String name2, PsiType returnType) throws IncorrectOperationException {
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name2);
        if (PsiType.NULL.equals((Object)returnType)) {
            throw new IncorrectOperationException("Cannot create method with type \"null\".");
        }
        String canonicalText = GenericsUtil.getVariableTypeByExpressionType((PsiType)returnType).getCanonicalText(true);
        PsiJavaFile aFile = this.createDummyJavaFile("class _Dummy_ { public " + canonicalText + " " + name2 + "() {\n} }");
        PsiClass[] classes2 = aFile.getClasses();
        if (classes2.length < 1) {
            throw new IncorrectOperationException("Class was not created. Method name: " + name2 + "; return type: " + canonicalText);
        }
        PsiMethod[] methods = classes2[0].getMethods();
        if (methods.length < 1) {
            throw new IncorrectOperationException("Method was not created. Method name: " + name2 + "; return type: " + canonicalText);
        }
        PsiMethod method = methods[0];
        method = (PsiMethod)JavaCodeStyleManager.getInstance((Project)this.myManager.getProject()).shortenClassReferences((PsiElement)method);
        return (PsiMethod)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)method);
    }

    @NotNull
    public PsiMethod createMethod(@NotNull String name2, PsiType returnType, PsiElement context) throws IncorrectOperationException {
        return this.createMethodFromText("public " + GenericsUtil.getVariableTypeByExpressionType((PsiType)returnType).getCanonicalText(true) + " " + name2 + "() {}", context);
    }

    @NotNull
    public PsiMethod createConstructor() {
        return this.createConstructor("_Dummy_");
    }

    @NotNull
    public PsiMethod createConstructor(@NotNull String name2) {
        PsiJavaFile aFile = this.createDummyJavaFile("class " + name2 + " { public " + name2 + "() {} }");
        PsiMethod method = aFile.getClasses()[0].getMethods()[0];
        return (PsiMethod)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)method);
    }

    @NotNull
    public PsiMethod createConstructor(@NotNull String name2, PsiElement context) {
        return this.createMethodFromText(name2 + "() {}", context);
    }

    @NotNull
    public PsiClassInitializer createClassInitializer() throws IncorrectOperationException {
        PsiJavaFile aFile = this.createDummyJavaFile("class _Dummy_ { {} }");
        PsiClassInitializer classInitializer = aFile.getClasses()[0].getInitializers()[0];
        return (PsiClassInitializer)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)classInitializer);
    }

    @NotNull
    public PsiParameter createParameter(@NotNull String name2, @NotNull PsiType type2) throws IncorrectOperationException {
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name2);
        if (PsiType.NULL.equals((Object)type2)) {
            throw new IncorrectOperationException("Cannot create parameter with type \"null\".");
        }
        String text2 = type2.getCanonicalText(true) + " " + name2;
        PsiParameter parameter2 = this.createParameterFromText(text2, null);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myManager.getProject());
        PsiUtil.setModifierProperty((PsiModifierListOwner)parameter2, (String)"final", (boolean)JavaCodeStyleSettingsFacade.getInstance((Project)this.myManager.getProject()).isGenerateFinalParameters());
        GeneratedMarkerVisitor.markGenerated((PsiElement)parameter2);
        parameter2 = (PsiParameter)JavaCodeStyleManager.getInstance((Project)this.myManager.getProject()).shortenClassReferences((PsiElement)parameter2);
        return (PsiParameter)codeStyleManager.reformat((PsiElement)parameter2);
    }

    public PsiParameter createParameter(@NotNull String name2, PsiType type2, PsiElement context) throws IncorrectOperationException {
        PsiMethod psiMethod = this.createMethodFromText("void f(" + type2.getCanonicalText(true) + " " + name2 + ") {}", context);
        PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
        return parameters2[0];
    }

    @NotNull
    public PsiCodeBlock createCodeBlock() {
        PsiCodeBlock block = this.createCodeBlockFromText("{}", null);
        return (PsiCodeBlock)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)block);
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass) {
        return new PsiImmediateClassType(aClass, aClass instanceof PsiTypeParameter ? PsiSubstitutor.EMPTY : this.createRawSubstitutor((PsiTypeParameterListOwner)aClass));
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiJavaCodeReferenceElement classReference2) {
        return new PsiClassReferenceType(classReference2, null);
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType parameter2) {
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        assert (typeParameters.length == 1) : aClass;
        return this.createType(aClass, PsiSubstitutor.EMPTY.put(typeParameters[0], parameter2));
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType ... parameters2) {
        return this.createType(aClass, PsiSubstitutor.EMPTY.putAll(aClass, parameters2));
    }

    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiTypeParameterListOwner owner2) {
        HashMap<PsiTypeParameter, Object> substitutorMap = null;
        for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)owner2)) {
            if (substitutorMap == null) {
                substitutorMap = new HashMap<PsiTypeParameter, Object>();
            }
            substitutorMap.put(parameter2, null);
        }
        return PsiSubstitutor.createSubstitutor(substitutorMap);
    }

    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiSubstitutor baseSubstitutor, PsiTypeParameter @NotNull [] typeParameters) {
        HashMap<PsiTypeParameter, Object> substitutorMap = null;
        for (PsiTypeParameter parameter2 : typeParameters) {
            if (substitutorMap == null) {
                substitutorMap = new HashMap<PsiTypeParameter, Object>();
            }
            substitutorMap.put(parameter2, null);
        }
        return PsiSubstitutor.createSubstitutor(substitutorMap).putAll(baseSubstitutor);
    }

    @NotNull
    public PsiElement createDummyHolder(@NotNull String text2, @NotNull IElementType type2, @Nullable PsiElement context) {
        DummyHolder result = DummyHolderFactory.createHolder((PsiManager)this.myManager, (PsiElement)context);
        FileElement holder = result.getTreeElement();
        Language language = type2.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        assert (parserDefinition != null) : "No parser definition for language " + language;
        Project project = this.myManager.getProject();
        Lexer lexer = parserDefinition.createLexer(project);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, (ASTNode)holder, lexer, language, (CharSequence)text2);
        ASTNode node = parserDefinition.createParser(project).parse(type2, builder);
        holder.rawAddChildren((TreeElement)node);
        PsiElement psi = node.getPsi();
        assert (psi != null) : text2;
        return psi;
    }

    @NotNull
    public PsiSubstitutor createSubstitutor(@NotNull Map<PsiTypeParameter, PsiType> map2) {
        return PsiSubstitutor.createSubstitutor(map2);
    }

    @Nullable
    public PsiPrimitiveType createPrimitiveType(@NotNull String text2) {
        return PsiJavaParserFacadeImpl.getPrimitiveType(text2);
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String qName) {
        return this.createTypeByFQClassName(qName, GlobalSearchScope.allScope((Project)this.myManager.getProject()));
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if ("java.lang.Object".equals(qName)) {
            Object cachedObjectType = (PsiClassType)this.myCachedObjectType.get(resolveScope);
            if (cachedObjectType != null) {
                return cachedObjectType;
            }
            PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass("java.lang.Object", resolveScope);
            if (aClass != null) {
                cachedObjectType = new PsiImmediateClassType(aClass, PsiSubstitutor.EMPTY);
                cachedObjectType = (PsiClassType)ConcurrencyUtil.cacheOrGet(this.myCachedObjectType, (Object)resolveScope, (Object)cachedObjectType);
                return cachedObjectType;
            }
        }
        return new PsiClassReferenceType(this.createReferenceElementByFQClassName(qName, resolveScope), null);
    }

    @NotNull
    public PsiJavaCodeReferenceElement createClassReferenceElement(@NotNull PsiClass aClass) {
        String text2 = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName();
        if (text2 == null) {
            throw new IncorrectOperationException("Invalid class: " + aClass);
        }
        return new LightClassReference(this.myManager, text2, aClass);
    }

    @NotNull
    public PsiJavaCodeReferenceElement createReferenceElementByFQClassName(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        String shortName = PsiNameHelper.getShortClassName((String)qName);
        return new LightClassReference(this.myManager, shortName, qName, resolveScope);
    }

    @NotNull
    public PsiJavaCodeReferenceElement createFQClassNameReferenceElement(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        return new LightClassReference(this.myManager, qName, qName, resolveScope);
    }

    @NotNull
    public PsiJavaCodeReferenceElement createPackageReferenceElement(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage.getQualifiedName().isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        return new LightPackageReference(this.myManager, aPackage);
    }

    @NotNull
    public PsiPackageStatement createPackageStatement(@NotNull String name2) throws IncorrectOperationException {
        PsiJavaFile aFile = this.createDummyJavaFile("package " + name2 + ";");
        PsiPackageStatement stmt = aFile.getPackageStatement();
        if (stmt == null) {
            throw new IncorrectOperationException("Incorrect package name: " + name2);
        }
        return stmt;
    }

    @NotNull
    public PsiImportStaticStatement createImportStaticStatement(@NotNull PsiClass aClass, @NotNull String memberName) throws IncorrectOperationException {
        if (aClass instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("Cannot create import statement for anonymous class.");
        }
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            throw new IncorrectOperationException("Cannot create import statement for local class.");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import static " + aClass.getQualifiedName() + "." + memberName + ";");
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, true);
        return (PsiImportStaticStatement)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)statement);
    }

    @NotNull
    public PsiParameterList createParameterList(String @NotNull [] names2, PsiType @NotNull [] types) throws IncorrectOperationException {
        StringBuilder builder = new StringBuilder();
        builder.append("void method(");
        for (int i = 0; i < names2.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(types[i].getCanonicalText(true)).append(' ').append(names2[i]);
        }
        builder.append(");");
        return this.createMethodFromText(builder.toString(), null).getParameterList();
    }

    @NotNull
    public PsiReferenceList createReferenceList(PsiJavaCodeReferenceElement @NotNull [] references) throws IncorrectOperationException {
        StringBuilder builder = new StringBuilder();
        builder.append("void method()");
        if (references.length > 0) {
            builder.append(" throws ");
            for (int i = 0; i < references.length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(references[i].getCanonicalText());
            }
        }
        builder.append(';');
        return this.createMethodFromText(builder.toString(), null).getThrowsList();
    }

    @NotNull
    public PsiJavaCodeReferenceElement createPackageReferenceElement(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName.isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        return new LightPackageReference(this.myManager, packageName);
    }

    @NotNull
    public PsiReferenceExpression createReferenceExpression(@NotNull PsiClass aClass) throws IncorrectOperationException {
        String text2 = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName();
        return new LightClassReferenceExpression(this.myManager, text2, aClass);
    }

    @NotNull
    public PsiReferenceExpression createReferenceExpression(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage.getQualifiedName().isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        return new LightPackageReferenceExpression(this.myManager, aPackage);
    }

    @NotNull
    public PsiIdentifier createIdentifier(@NotNull String text2) throws IncorrectOperationException {
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)text2);
        return new LightIdentifier(this.myManager, text2);
    }

    @NotNull
    public PsiKeyword createKeyword(@NotNull String text2) throws IncorrectOperationException {
        if (!PsiNameHelper.getInstance((Project)this.myManager.getProject()).isKeyword(text2)) {
            throw new IncorrectOperationException("\"" + text2 + "\" is not a keyword.");
        }
        return new LightKeyword(this.myManager, text2);
    }

    @NotNull
    public PsiKeyword createKeyword(@NotNull String keyword, PsiElement context) throws IncorrectOperationException {
        LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)context);
        if (!JavaLexer.isKeyword(keyword, level) && !JavaLexer.isSoftKeyword(keyword, level)) {
            throw new IncorrectOperationException("\"" + keyword + "\" is not a keyword.");
        }
        return new LightKeyword(this.myManager, keyword);
    }

    @NotNull
    public PsiImportStatement createImportStatement(@NotNull PsiClass aClass) throws IncorrectOperationException {
        if (aClass instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("Cannot create import statement for anonymous class.");
        }
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            throw new IncorrectOperationException("Cannot create import statement for local class.");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import " + aClass.getQualifiedName() + ";");
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, false);
        return (PsiImportStatement)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)statement);
    }

    @NotNull
    public PsiImportStatement createImportStatementOnDemand(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName.isEmpty()) {
            throw new IncorrectOperationException("Cannot create import statement for default package.");
        }
        if (!PsiNameHelper.getInstance((Project)this.myManager.getProject()).isQualifiedName(packageName)) {
            throw new IncorrectOperationException("Incorrect package name: \"" + packageName + "\".");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import " + packageName + ".*;");
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, false);
        return (PsiImportStatement)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)statement);
    }

    @NotNull
    public PsiDeclarationStatement createVariableDeclarationStatement(@NotNull String name2, @NotNull PsiType type2, @Nullable PsiExpression initializer) throws IncorrectOperationException {
        return this.createVariableDeclarationStatement(name2, type2, initializer, null);
    }

    @NotNull
    public PsiDeclarationStatement createVariableDeclarationStatement(@NotNull String name2, @NotNull PsiType type2, @Nullable PsiExpression initializer, @Nullable PsiElement context) throws IncorrectOperationException {
        if (!this.isIdentifier(name2)) {
            throw new IncorrectOperationException("\"" + name2 + "\" is not an identifier.");
        }
        if (PsiType.NULL.equals((Object)type2)) {
            throw new IncorrectOperationException("Cannot create variable with type \"null\".");
        }
        String text2 = "X " + name2 + (initializer != null ? " = x" : "") + ";";
        PsiDeclarationStatement statement = (PsiDeclarationStatement)this.createStatementFromText(text2, context);
        PsiVariable variable = (PsiVariable)statement.getDeclaredElements()[0];
        PsiElementFactoryImpl.replace((PsiElement)variable.getTypeElement(), (PsiElement)this.createTypeElement(GenericsUtil.getVariableTypeByExpressionType((PsiType)type2)), text2);
        boolean generateFinalLocals = JavaCodeStyleSettingsFacade.getInstance((Project)this.myManager.getProject()).isGenerateFinalLocals();
        PsiUtil.setModifierProperty((PsiModifierListOwner)variable, (String)"final", (boolean)generateFinalLocals);
        if (initializer != null) {
            PsiElementFactoryImpl.replace((PsiElement)variable.getInitializer(), (PsiElement)initializer, text2);
        }
        GeneratedMarkerVisitor.markGenerated((PsiElement)statement);
        return statement;
    }

    public PsiResourceVariable createResourceVariable(@NotNull String name2, @NotNull PsiType type2, @Nullable PsiExpression initializer, @Nullable PsiElement context) {
        PsiTryStatement tryStatement = (PsiTryStatement)this.createStatementFromText("try (X x = null){}", context);
        PsiResourceList resourceList = tryStatement.getResourceList();
        assert (resourceList != null);
        PsiResourceVariable resourceVariable = (PsiResourceVariable)resourceList.iterator().next();
        resourceVariable.getTypeElement().replace((PsiElement)this.createTypeElement(type2));
        PsiIdentifier nameIdentifier = resourceVariable.getNameIdentifier();
        assert (nameIdentifier != null);
        nameIdentifier.replace((PsiElement)this.createIdentifier(name2));
        if (initializer != null) {
            resourceVariable.setInitializer(initializer);
        }
        return resourceVariable;
    }

    private static void replace(@Nullable PsiElement original, @NotNull PsiElement replacement, @NotNull String message2) {
        assert (original != null) : message2;
        original.replace(replacement);
    }

    @NotNull
    public PsiDocTag createParamTag(@NotNull String parameterName, String description) throws IncorrectOperationException {
        StringBuilder builder = new StringBuilder();
        builder.append(" * @param ");
        builder.append(parameterName);
        builder.append(" ");
        String[] strings = description.split("\\n");
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                builder.append("\n * ");
            }
            builder.append(strings[i]);
        }
        return this.createDocTagFromText(builder.toString());
    }

    @Override
    @NotNull
    public PsiAnnotation createAnnotationFromText(@NotNull String annotationText, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiAnnotation psiAnnotation = super.createAnnotationFromText(annotationText, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)psiAnnotation);
        return psiAnnotation;
    }

    public PsiAnnotation createAnnotationFromText(@NotNull String annotationText, @Nullable PsiElement context, boolean markGenerated) throws IncorrectOperationException {
        PsiAnnotation psiAnnotation = super.createAnnotationFromText(annotationText, context);
        if (markGenerated) {
            GeneratedMarkerVisitor.markGenerated((PsiElement)psiAnnotation);
        }
        return psiAnnotation;
    }

    @Override
    @NotNull
    public PsiCodeBlock createCodeBlockFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiCodeBlock psiCodeBlock = super.createCodeBlockFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)psiCodeBlock);
        return psiCodeBlock;
    }

    @Override
    @NotNull
    public PsiEnumConstant createEnumConstantFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiEnumConstant enumConstant = super.createEnumConstantFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)enumConstant);
        return enumConstant;
    }

    @Override
    @NotNull
    public PsiExpression createExpressionFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiExpression expression2 = super.createExpressionFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)expression2);
        return expression2;
    }

    @Override
    @NotNull
    public PsiField createFieldFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiField psiField = super.createFieldFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)psiField);
        return psiField;
    }

    @Override
    @NotNull
    public PsiParameter createParameterFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiParameter parameter2 = super.createParameterFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)parameter2);
        return parameter2;
    }

    @Override
    @NotNull
    public PsiStatement createStatementFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiStatement statement = super.createStatementFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)statement);
        return statement;
    }

    @Override
    @NotNull
    public PsiType createTypeFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        return this.createTypeInner(text2, context, true);
    }

    @Override
    @NotNull
    public PsiTypeParameter createTypeParameterFromText(@NotNull String text2, PsiElement context) throws IncorrectOperationException {
        PsiTypeParameter typeParameter = super.createTypeParameterFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)typeParameter);
        return typeParameter;
    }

    @Override
    @NotNull
    public PsiMethod createMethodFromText(@NotNull String text2, PsiElement context, LanguageLevel level) throws IncorrectOperationException {
        PsiMethod method = super.createMethodFromText(text2, context, level);
        GeneratedMarkerVisitor.markGenerated((PsiElement)method);
        return method;
    }

    private static PsiImportStatementBase extractImport(PsiJavaFile aFile, boolean isStatic) {
        PsiImportStaticStatement[] statements;
        PsiImportList importList = aFile.getImportList();
        assert (importList != null) : aFile;
        Object[] objectArray = statements = isStatic ? importList.getImportStaticStatements() : importList.getImportStatements();
        assert (statements.length == 1) : aFile.getText();
        return statements[0];
    }

    @NotNull
    public PsiCatchSection createCatchSection(@NotNull PsiType exceptionType, @NotNull String exceptionName, @Nullable PsiElement context) throws IncorrectOperationException {
        if (!(exceptionType instanceof PsiClassType) && !(exceptionType instanceof PsiDisjunctionType)) {
            throw new IncorrectOperationException("Unexpected type:" + exceptionType);
        }
        String text2 = "catch (" + exceptionType.getCanonicalText(true) + " " + exceptionName + ") {}";
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)new JavaDummyElement(text2, CATCH_SECTION, PsiElementFactoryImpl.level(context)), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiCatchSection)) {
            throw new IncorrectOperationException("Incorrect catch section '" + text2 + "'. Parsed element: " + element);
        }
        Project project = this.myManager.getProject();
        JavaPsiImplementationHelper helper = JavaPsiImplementationHelper.getInstance(project);
        helper.setupCatchBlock(exceptionName, exceptionType, context, (PsiCatchSection)element);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        PsiCatchSection catchSection = (PsiCatchSection)styleManager.reformat(element);
        GeneratedMarkerVisitor.markGenerated((PsiElement)catchSection);
        return catchSection;
    }

    public boolean isValidClassName(@NotNull String name2) {
        return this.isIdentifier(name2);
    }

    public boolean isValidMethodName(@NotNull String name2) {
        return this.isIdentifier(name2);
    }

    public boolean isValidParameterName(@NotNull String name2) {
        return this.isIdentifier(name2);
    }

    public boolean isValidFieldName(@NotNull String name2) {
        return this.isIdentifier(name2);
    }

    public boolean isValidLocalVariableName(@NotNull String name2) {
        return this.isIdentifier(name2);
    }

    private boolean isIdentifier(@NotNull String name2) {
        return PsiNameHelper.getInstance((Project)this.myManager.getProject()).isIdentifier(name2);
    }
}

