/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.JavaSimplePropertyGistKt;
import com.intellij.psi.impl.JavaSimplePropertyGistKt$WhenMappings;
import com.intellij.psi.impl.PropertyIndexValue;
import com.intellij.psi.impl.SimplePropertiesExternalizer;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.source.JavaLightStubBuilder;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.stub.JavaStubImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.NullableFunction;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.io.DataExternalizer;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\" \u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\";\u0010\u0007\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \u000b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u00028\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"allowedExpressions", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getAllowedExpressions", "()Lcom/intellij/psi/tree/TokenSet;", "allowedExpressions$delegate", "Lkotlin/Lazy;", "javaSimplePropertyGist", "Lcom/intellij/util/gist/PsiFileGist;", "Lgnu/trove/TIntObjectHashMap;", "Lcom/intellij/psi/impl/PropertyIndexValue;", "kotlin.jvm.PlatformType", "getJavaSimplePropertyGist$annotations", "()V", "getJavaSimplePropertyGist", "()Lcom/intellij/util/gist/PsiFileGist;", "findSimplePropertyCandidates", "tree", "Lcom/intellij/lang/LighterAST;", "getFieldOfGetter", "Lcom/intellij/psi/PsiField;", "method", "Lcom/intellij/psi/impl/source/PsiMethodImpl;", "getFieldOfSetter", "resolveFieldFromIndexValue", "isGetter", "", "intellij.java.indexing.impl"})
public final class JavaSimplePropertyGistKt {
    @NotNull
    private static final PsiFileGist<TIntObjectHashMap<PropertyIndexValue>> javaSimplePropertyGist = GistManager.getInstance().newPsiFileGist("java.simple.property", 1, (DataExternalizer)new SimplePropertiesExternalizer(), (NullableFunction)javaSimplePropertyGist.1.INSTANCE);
    private static final Lazy allowedExpressions$delegate = LazyKt.lazy((Function0)allowedExpressions.2.INSTANCE);

    @Nullable
    public static final PsiField getFieldOfGetter(@NotNull PsiMethodImpl method) {
        return JavaSimplePropertyGistKt.resolveFieldFromIndexValue(method, true);
    }

    @Nullable
    public static final PsiField getFieldOfSetter(@NotNull PsiMethodImpl method) {
        return JavaSimplePropertyGistKt.resolveFieldFromIndexValue(method, false);
    }

    private static final PsiField resolveFieldFromIndexValue(PsiMethodImpl method, boolean isGetter) {
        PsiFile file = method.getContainingFile();
        if (Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)JavaFileType.INSTANCE)) ^ true) {
            return null;
        }
        int id = JavaStubImplUtil.getMethodStubIndex(method);
        if (id != -1) {
            PropertyIndexValue propertyIndexValue = (PropertyIndexValue)((TIntObjectHashMap)javaSimplePropertyGist.getFileData(file)).get(id);
            if (propertyIndexValue != null) {
                PsiClass psiClass;
                PropertyIndexValue propertyIndexValue2 = propertyIndexValue;
                boolean bl = false;
                boolean bl2 = false;
                PropertyIndexValue indexValue = propertyIndexValue2;
                boolean bl3 = false;
                if (isGetter != indexValue.getGetter()) {
                    return null;
                }
                PsiClass psiClass2 = psiClass = method.getContainingClass();
                if (psiClass2 == null) {
                    Intrinsics.throwNpe();
                }
                Project project = psiClass2.getProject();
                PsiExpression expr2 = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(indexValue.getPropertyRefText(), (PsiElement)psiClass);
                return PropertyUtil.getSimplyReturnedField(expr2);
            }
            return null;
        }
        return null;
    }

    @VisibleForTesting
    public static /* synthetic */ void getJavaSimplePropertyGist$annotations() {
    }

    @NotNull
    public static final PsiFileGist<TIntObjectHashMap<PropertyIndexValue>> getJavaSimplePropertyGist() {
        return javaSimplePropertyGist;
    }

    private static final TokenSet getAllowedExpressions() {
        Lazy lazy = allowedExpressions$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (TokenSet)lazy.getValue();
    }

    private static final TIntObjectHashMap<PropertyIndexValue> findSimplePropertyCandidates(LighterAST tree) {
        TIntObjectHashMap result = new TIntObjectHashMap();
        new RecursiveLighterASTNodeWalkingVisitor(result, tree, tree){
            private int methodIndex;
            final /* synthetic */ TIntObjectHashMap $result;
            final /* synthetic */ LighterAST $tree;

            public final int getMethodIndex() {
                return this.methodIndex;
            }

            public final void setMethodIndex(int n) {
                this.methodIndex = n;
            }

            public void visitNode(@NotNull LighterASTNode element) {
                if (JavaLightStubBuilder.isCodeBlockWithoutStubs(element)) {
                    return;
                }
                if (element.getTokenType() == JavaElementType.METHOD) {
                    PropertyIndexValue propertyIndexValue = this.extractProperty(element);
                    if (propertyIndexValue != null) {
                        PropertyIndexValue propertyIndexValue2 = propertyIndexValue;
                        boolean bl = false;
                        boolean bl2 = false;
                        PropertyIndexValue it = propertyIndexValue2;
                        boolean bl3 = false;
                        PropertyIndexValue cfr_ignored_0 = (PropertyIndexValue)this.$result.put(this.methodIndex, (Object)it);
                    }
                    int n = this.methodIndex;
                    this.methodIndex = n + 1;
                }
                super.visitNode(element);
            }

            private final PropertyIndexValue extractProperty(LighterASTNode method) {
                PropertyIndexValue propertyIndexValue;
                boolean isConstructor = true;
                boolean isGetter = true;
                boolean isBooleanReturnType = false;
                boolean isVoidReturnType = false;
                String setterParameterName = null;
                String refText = null;
                for (LighterASTNode child : this.$tree.getChildren(method)) {
                    IElementType iElementType = child.getTokenType();
                    if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.TYPE)) {
                        List children = this.$tree.getChildren(child);
                        if (children.size() != 1) {
                            return null;
                        }
                        LighterASTNode typeElement = (LighterASTNode)children.get(0);
                        if (Intrinsics.areEqual((Object)typeElement.getTokenType(), (Object)JavaTokenType.VOID_KEYWORD)) {
                            isVoidReturnType = true;
                        }
                        if (Intrinsics.areEqual((Object)typeElement.getTokenType(), (Object)JavaTokenType.BOOLEAN_KEYWORD)) {
                            isBooleanReturnType = true;
                        }
                        isConstructor = false;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.PARAMETER_LIST)) {
                        if (isGetter) {
                            if (LightTreeUtil.firstChildOfType((LighterAST)this.$tree, (LighterASTNode)child, (IElementType)JavaElementType.PARAMETER) == null) continue;
                            return null;
                        }
                        List parameters2 = LightTreeUtil.getChildrenOfType((LighterAST)this.$tree, (LighterASTNode)child, (IElementType)JavaElementType.PARAMETER);
                        if (parameters2.size() != 1) {
                            return null;
                        }
                        setterParameterName = JavaLightTreeUtil.getNameIdentifierText(this.$tree, (LighterASTNode)parameters2.get(0));
                        if (setterParameterName != null) continue;
                        return null;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.CODE_BLOCK)) {
                        String string;
                        if (isGetter) {
                            string = this.getGetterPropertyRefText(child);
                        } else {
                            String string2 = setterParameterName;
                            if (string2 == null) {
                                Intrinsics.throwNpe();
                            }
                            string = this.getSetterPropertyRefText(child, string2);
                        }
                        if ((refText = string) != null) continue;
                        return null;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.IDENTIFIER)) continue;
                    if (isConstructor) {
                        return null;
                    }
                    String name2 = RecordUtil.intern(this.$tree.getCharTable(), child);
                    PropertyUtilBase.GetterFlavour flavour = PropertyUtil.getMethodNameGetterFlavour((String)name2);
                    switch (JavaSimplePropertyGistKt$WhenMappings.$EnumSwitchMapping$0[flavour.ordinal()]) {
                        case 1: {
                            if (PropertyUtil.isSetterName((String)name2)) {
                                isGetter = false;
                                break;
                            }
                            return null;
                        }
                        case 2: {
                            if (isBooleanReturnType) break;
                            return null;
                        }
                    }
                    if (!isVoidReturnType || !isGetter) continue;
                    return null;
                }
                String string = refText;
                if (string != null) {
                    String string3 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string3;
                    boolean bl3 = false;
                    propertyIndexValue = new PropertyIndexValue(it, isGetter);
                } else {
                    propertyIndexValue = null;
                }
                return propertyIndexValue;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final String getSetterPropertyRefText(LighterASTNode codeBlock, String setterParameterName) {
                Object v0;
                boolean $i$f$singleOrNull;
                Iterable $this$singleOrNull$iv;
                block4: {
                    $this$singleOrNull$iv = this.$tree.getChildren(codeBlock);
                    $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        LighterASTNode it = (LighterASTNode)element$iv;
                        boolean bl = false;
                        if (!ElementType.JAVA_STATEMENT_BIT_SET.contains(it.getTokenType())) continue;
                        if (found$iv) {
                            v0 = null;
                            break block4;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v0 = !found$iv ? null : single$iv;
                }
                LighterASTNode lighterASTNode = v0;
                Object object = lighterASTNode;
                if (lighterASTNode == null) return null;
                $this$singleOrNull$iv = object;
                $i$f$singleOrNull = false;
                boolean bl = false;
                Iterable it = $this$singleOrNull$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)JavaElementType.EXPRESSION_STATEMENT)) return null;
                Iterable iterable = $this$singleOrNull$iv;
                object = iterable;
                if (iterable == null) return null;
                $this$singleOrNull$iv = object;
                $i$f$singleOrNull = false;
                bl = false;
                it = $this$singleOrNull$iv;
                boolean bl3 = false;
                LighterASTNode lighterASTNode2 = LightTreeUtil.firstChildOfType((LighterAST)this.$tree, (LighterASTNode)it, (IElementType)JavaElementType.ASSIGNMENT_EXPRESSION);
                LighterASTNode assignment = lighterASTNode2;
                if (assignment == null) return null;
                if (LightTreeUtil.firstChildOfType((LighterAST)this.$tree, assignment, (IElementType)JavaTokenType.EQ) == null) {
                    return null;
                }
                List operands2 = LightTreeUtil.getChildrenOfType((LighterAST)this.$tree, assignment, (TokenSet)ElementType.EXPRESSION_BIT_SET);
                if (operands2.size() != 2) return null;
                if (Intrinsics.areEqual((Object)LightTreeUtil.toFilteredString((LighterAST)this.$tree, (LighterASTNode)((LighterASTNode)operands2.get(1)), null), (Object)setterParameterName) ^ true) {
                    return null;
                }
                String lhsText = LightTreeUtil.toFilteredString((LighterAST)this.$tree, (LighterASTNode)((LighterASTNode)operands2.get(0)), null);
                if (!Intrinsics.areEqual((Object)lhsText, (Object)setterParameterName)) return lhsText;
                return null;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final String getGetterPropertyRefText(LighterASTNode codeBlock) {
                Object v0;
                block2: {
                    Iterable $this$singleOrNull$iv = this.$tree.getChildren(codeBlock);
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        LighterASTNode it = (LighterASTNode)element$iv;
                        boolean bl = false;
                        if (!ElementType.JAVA_STATEMENT_BIT_SET.contains(it.getTokenType())) continue;
                        if (found$iv) {
                            v0 = null;
                            break block2;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v0 = !found$iv ? null : single$iv;
                }
                LighterASTNode lighterASTNode2 = v0;
                lighterASTNode2 = lighterASTNode2;
                if (lighterASTNode == null) return null;
                LighterASTNode lighterASTNode3 = lighterASTNode2;
                boolean bl = false;
                boolean bl2 = false;
                LighterASTNode it = lighterASTNode3;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)JavaElementType.RETURN_STATEMENT)) return null;
                LighterASTNode lighterASTNode2 = lighterASTNode3;
                lighterASTNode2 = lighterASTNode2;
                if (lighterASTNode4 == null) return null;
                lighterASTNode3 = lighterASTNode2;
                bl = false;
                bl2 = false;
                it = lighterASTNode3;
                boolean bl4 = false;
                LighterASTNode lighterASTNode2 = LightTreeUtil.firstChildOfType((LighterAST)this.$tree, (LighterASTNode)it, (TokenSet)JavaSimplePropertyGistKt.access$getAllowedExpressions$p());
                lighterASTNode2 = lighterASTNode2;
                if (lighterASTNode5 == null) return null;
                lighterASTNode3 = lighterASTNode2;
                findSimplePropertyCandidates.1 var3_4 = this;
                bl2 = false;
                boolean it2 = false;
                LighterASTNode p1 = lighterASTNode3;
                boolean bl5 = false;
                if (!var3_4.checkQualifiers(p1)) return null;
                LighterASTNode lighterASTNode2 = lighterASTNode3;
                lighterASTNode2 = lighterASTNode2;
                if (lighterASTNode6 == null) return null;
                lighterASTNode3 = lighterASTNode2;
                boolean bl6 = false;
                bl2 = false;
                it = lighterASTNode3;
                boolean bl7 = false;
                String string = LightTreeUtil.toFilteredString((LighterAST)this.$tree, (LighterASTNode)it, null);
                return string;
            }

            private final boolean checkQualifiers(LighterASTNode expression2) {
                if (!JavaSimplePropertyGistKt.access$getAllowedExpressions$p().contains(expression2.getTokenType())) {
                    return false;
                }
                LighterASTNode qualifier = JavaLightTreeUtil.findExpressionChild(this.$tree, expression2);
                return qualifier == null || this.checkQualifiers(qualifier);
            }
            {
                this.$result = $captured_local_variable$0;
                this.$tree = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }.visitNode(tree.getRoot());
        return result;
    }

    public static final /* synthetic */ TokenSet access$getAllowedExpressions$p() {
        return JavaSimplePropertyGistKt.getAllowedExpressions();
    }

    public static final /* synthetic */ TIntObjectHashMap access$findSimplePropertyCandidates(LighterAST tree) {
        return JavaSimplePropertyGistKt.findSimplePropertyCandidates(tree);
    }
}

