/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindSuperElementsHelper {
    public static PsiElement @NotNull [] findSuperElements(@NotNull PsiElement element) {
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            ArrayList<PsiClass> allSupers = new ArrayList<PsiClass>(Arrays.asList(aClass.getSupers()));
            allSupers.removeIf(superClass -> "java.lang.Object".equals(superClass.getQualifiedName()));
            return (PsiElement[])allSupers.toArray(PsiClass.EMPTY_ARRAY);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (method.isConstructor()) {
                PsiMethod constructorInSuper = JavaPsiConstructorUtil.findConstructorInSuper((PsiMethod)method);
                if (constructorInSuper != null) {
                    return new PsiMethod[]{constructorInSuper};
                }
            } else {
                PsiMethod superMethod;
                PsiMethod[] superMethods = MethodSignatureUtil.convertMethodSignaturesToMethods(new ArrayList(SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findAll()));
                if (superMethods.length == 0 && (superMethod = FindSuperElementsHelper.getSiblingInheritedViaSubClass(method)) != null) {
                    superMethods = new PsiMethod[]{superMethod};
                }
                return superMethods;
            }
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public static PsiMethod getSiblingInheritedViaSubClass(@NotNull PsiMethod method) {
        SiblingInfo info = FindSuperElementsHelper.getSiblingInfoInheritedViaSubClass(method);
        return info == null ? null : info.superMethod;
    }

    @Nullable
    public static SiblingInfo getSiblingInfoInheritedViaSubClass(@NotNull PsiMethod method) {
        return FindSuperElementsHelper.getSiblingInheritanceInfos(Collections.singletonList(method)).get(method);
    }

    @NotNull
    public static Map<PsiMethod, SiblingInfo> getSiblingInheritanceInfos(@NotNull Collection<? extends PsiMethod> methods) {
        MultiMap byClass = MultiMap.create();
        for (PsiMethod psiMethod : methods) {
            PsiClass containingClass;
            if (!FindSuperElementsHelper.canHaveSiblingSuper(psiMethod, containingClass = psiMethod.getContainingClass())) continue;
            byClass.putValue((Object)containingClass, (Object)psiMethod);
        }
        HashMap<PsiMethod, SiblingInfo> result = null;
        for (PsiClass psiClass : byClass.keySet()) {
            SiblingInheritorSearcher searcher = new SiblingInheritorSearcher(byClass.get((Object)psiClass), psiClass);
            ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)psiClass.getUseScope(), (boolean)true, (boolean)true, (boolean)false).allowParallelProcessing().forEach((Processor)searcher);
            Map<PsiMethod, SiblingInfo> searcherResult = searcher.getResult();
            if (searcherResult.isEmpty()) continue;
            if (result == null) {
                result = new HashMap<PsiMethod, SiblingInfo>();
            }
            result.putAll(searcherResult);
        }
        return result == null ? Collections.emptyMap() : result;
    }

    public static boolean canHaveSiblingSuper(@NotNull PsiMethod method, PsiClass containingClass) {
        return containingClass != null && !method.isConstructor() && !method.hasModifierProperty("static") && !method.hasModifierProperty("private") && !method.hasModifierProperty("abstract") && !method.hasModifierProperty("native") && method.hasModifierProperty("public") && !containingClass.isInterface() && !(containingClass instanceof PsiAnonymousClass) && !containingClass.hasModifierProperty("final") && !"java.lang.Object".equals(containingClass.getQualifiedName());
    }

    private static class SiblingInheritorSearcher
    implements Processor<PsiClass> {
        private final PsiClass myContainingClass;
        private final Set<PsiMethod> myRemainingMethods;
        private Map<PsiMethod, SiblingInfo> myResult;
        private final Collection<PsiAnchor> myCheckedInterfaces = new THashSet();

        SiblingInheritorSearcher(@NotNull Collection<PsiMethod> methods, @NotNull PsiClass containingClass) {
            this.myContainingClass = containingClass;
            this.myRemainingMethods = new HashSet<PsiMethod>(methods);
            this.myCheckedInterfaces.add(PsiAnchor.create((PsiElement)containingClass));
        }

        public boolean process(PsiClass inheritor) {
            ProgressManager.checkCanceled();
            for (PsiClassType interfaceType : inheritor.getImplementsListTypes()) {
                ProgressManager.checkCanceled();
                PsiClass anInterface = interfaceType.resolveGenerics().getElement();
                if (anInterface == null || !this.myCheckedInterfaces.add(PsiAnchor.create((PsiElement)anInterface))) continue;
                this.processInterface(inheritor, anInterface);
            }
            return !this.myRemainingMethods.isEmpty();
        }

        private void processInterface(@NotNull PsiClass inheritor, @NotNull PsiClass anInterface) {
            Iterator<PsiMethod> methodIterator = this.myRemainingMethods.iterator();
            while (methodIterator.hasNext()) {
                ProgressManager.checkCanceled();
                PsiMethod method = methodIterator.next();
                SiblingInfo info = this.findSibling(inheritor, anInterface, method);
                if (info == null) continue;
                Map<PsiMethod, SiblingInfo> result = this.myResult;
                if (result == null) {
                    this.myResult = result = new HashMap<PsiMethod, SiblingInfo>();
                }
                result.put(method, info);
                methodIterator.remove();
            }
        }

        @Nullable
        private SiblingInfo findSibling(@NotNull PsiClass inheritor, @NotNull PsiClass anInterface, @NotNull PsiMethod method) {
            for (PsiMethod superMethod : anInterface.findMethodsByName(method.getName(), true)) {
                PsiElement navigationElement;
                PsiClass superInterface = superMethod.getContainingClass();
                if (superInterface == null || this.myContainingClass.isInheritor(superInterface, true) || !this.isOverridden(inheritor, method, superMethod, superInterface) || !((navigationElement = superMethod.getNavigationElement()) instanceof PsiMethod)) continue;
                return new SiblingInfo((PsiMethod)navigationElement, inheritor);
            }
            return null;
        }

        private boolean isOverridden(@NotNull PsiClass inheritor, @NotNull PsiMethod method, @NotNull PsiMethod superMethod, @NotNull PsiClass superInterface) {
            PsiSubstitutor substitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor((PsiClass)this.myContainingClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            if (substitutor == null) {
                return false;
            }
            PsiSubstitutor superInterfaceSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superInterface, (PsiClass)inheritor, (PsiSubstitutor)substitutor);
            return MethodSignatureUtil.isSubsignature((MethodSignature)superMethod.getSignature(superInterfaceSubstitutor), (MethodSignature)method.getSignature(substitutor));
        }

        @NotNull
        Map<PsiMethod, SiblingInfo> getResult() {
            return (Map)ObjectUtils.notNull(this.myResult, Collections.emptyMap());
        }
    }

    public static class SiblingInfo {
        @NotNull
        public final PsiMethod superMethod;
        @NotNull
        public final PsiClass subClass;

        private SiblingInfo(@NotNull PsiMethod superMethod, @NotNull PsiClass subClass) {
            this.superMethod = superMethod;
            this.subClass = subClass;
        }
    }
}

