/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.alignment.AlignmentInColumnsConfig;
import com.intellij.formatting.alignment.AlignmentInColumnsHelper;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.java.ChildAlignmentStrategyProvider;
import com.intellij.psi.formatter.java.MultipleFieldDeclarationHelper;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaJspElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SubsequentFieldAligner
extends ChildAlignmentStrategyProvider {
    private static final Set<IElementType> TYPES_TO_ALIGN = ContainerUtil.newHashSet((Object[])new IElementType[]{JavaElementType.MODIFIER_LIST, JavaElementType.TYPE, JavaTokenType.IDENTIFIER, JavaTokenType.EQ});
    private static final AlignmentInColumnsConfig ALIGNMENT_IN_COLUMNS_CONFIG = new AlignmentInColumnsConfig(TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.IDENTIFIER}), JavaJspElementType.WHITE_SPACE_BIT_SET, ElementType.JAVA_COMMENT_BIT_SET, TokenSet.EMPTY, TokenSet.create((IElementType[])new IElementType[]{JavaElementType.FIELD}));
    private final CommonCodeStyleSettings mySettings;
    private final AlignmentInColumnsHelper myAlignmentInColumnsHelper = AlignmentInColumnsHelper.INSTANCE;
    private AlignmentStrategy myAlignmentStrategy = SubsequentFieldAligner.newAlignmentStrategy();

    public SubsequentFieldAligner(@NotNull CommonCodeStyleSettings settings) {
        this.mySettings = settings;
    }

    private static AlignmentStrategy newAlignmentStrategy() {
        return AlignmentStrategy.createAlignmentPerTypeStrategy(TYPES_TO_ALIGN, (IElementType)JavaElementType.FIELD, (boolean)true);
    }

    @Override
    public AlignmentStrategy getNextChildStrategy(@NotNull ASTNode child) {
        if (!ElementType.JAVA_COMMENT_BIT_SET.contains(child.getElementType()) && !this.shouldUseVarDeclarationAlignment(child)) {
            this.myAlignmentStrategy = SubsequentFieldAligner.newAlignmentStrategy();
        }
        return JavaElementType.FIELD == child.getElementType() ? this.myAlignmentStrategy : AlignmentStrategy.getNullStrategy();
    }

    protected boolean shouldUseVarDeclarationAlignment(@NotNull ASTNode node) {
        return JavaElementType.FIELD == node.getElementType() && (!this.myAlignmentInColumnsHelper.useDifferentVarDeclarationAlignment(node, ALIGNMENT_IN_COLUMNS_CONFIG, this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS) || MultipleFieldDeclarationHelper.compoundFieldPart(node));
    }
}

