/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.InstructionKey;
import com.intellij.psi.controlFlow.InstructionKeySet;
import com.intellij.psi.controlFlow.ReadVariableInstruction;
import com.intellij.psi.controlFlow.ReturnInstruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.Queue;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefUseUtil {
    private static final Logger LOG = Logger.getInstance(DefUseUtil.class);
    private static final ControlFlowPolicy ourPolicy = new ControlFlowPolicy(){

        @Override
        public PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
            if (refExpr.isQualified()) {
                return null;
            }
            PsiElement refElement = refExpr.resolve();
            if (refElement instanceof PsiLocalVariable || refElement instanceof PsiParameter) {
                return (PsiVariable)refElement;
            }
            return null;
        }

        @Override
        public boolean isParameterAccepted(@NotNull PsiParameter psiParameter) {
            return true;
        }

        @Override
        public boolean isLocalVariableAccepted(@NotNull PsiLocalVariable psiVariable) {
            return true;
        }
    };

    private DefUseUtil() {
    }

    @Nullable
    public static List<Info> getUnusedDefs(PsiCodeBlock body2, Set<? super PsiVariable> outUsedVariables) {
        Map<InstructionKey, InstructionState> stateMap;
        ControlFlow flow;
        if (body2 == null) {
            return null;
        }
        try {
            flow = ControlFlowFactory.getInstance(body2.getProject()).getControlFlow((PsiElement)body2, ourPolicy, false);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
        List<Instruction> instructions = flow.getInstructions();
        if (LOG.isDebugEnabled()) {
            LOG.debug(flow.toString());
        }
        THashSet assignedVariables = new THashSet();
        THashSet readVariables = new THashSet();
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            ProgressManager.checkCanceled();
            if (instruction instanceof WriteVariableInstruction) {
                WriteVariableInstruction writeInstruction = (WriteVariableInstruction)instruction;
                PsiElement context = flow.getElement(i);
                context = PsiTreeUtil.getParentOfType((PsiElement)context, PsiStatement.class, (boolean)false);
                PsiVariable psiVariable = writeInstruction.variable;
                if (context == null || context instanceof PsiDeclarationStatement && psiVariable.getInitializer() == null) continue;
                assignedVariables.add(psiVariable);
                continue;
            }
            if (!(instruction instanceof ReadVariableInstruction)) continue;
            ReadVariableInstruction readInstruction = (ReadVariableInstruction)instruction;
            readVariables.add(readInstruction.variable);
        }
        try {
            stateMap = InstructionStateWalker.getStates(instructions);
        }
        catch (InstructionKey.OverflowException e) {
            LOG.error("Failed to compute paths in the control flow graph", (Throwable)e, new String[]{flow.toString()});
            return null;
        }
        Object[] states = stateMap.values().toArray(new InstructionState[0]);
        Arrays.sort(states);
        BitSet usefulWrites = new BitSet(instructions.size());
        Queue queue = new Queue(8);
        for (int i = states.length - 1; i >= 0; --i) {
            Object outerState = states[i];
            if (((InstructionState)outerState).isVisited()) continue;
            ((InstructionState)outerState).touch();
            for (PsiVariable psiVariable : assignedVariables) {
                if (!(psiVariable instanceof PsiField)) continue;
                ((InstructionState)outerState).addUsed(psiVariable);
            }
            queue.addLast(outerState);
            while (!queue.isEmpty()) {
                ProgressManager.checkCanceled();
                InstructionState state = (InstructionState)queue.pullFirst();
                state.markVisited();
                InstructionKey key2 = state.getInstructionKey();
                if (key2.getOffset() < instructions.size()) {
                    Instruction instruction = instructions.get(key2.getOffset());
                    if (instruction instanceof WriteVariableInstruction) {
                        WriteVariableInstruction writeInstruction = (WriteVariableInstruction)instruction;
                        PsiVariable psiVariable = writeInstruction.variable;
                        outUsedVariables.add((PsiVariable)psiVariable);
                        if (state.removeUsed(psiVariable)) {
                            usefulWrites.set(key2.getOffset());
                        }
                    } else if (instruction instanceof ReadVariableInstruction) {
                        ReadVariableInstruction readInstruction = (ReadVariableInstruction)instruction;
                        state.addUsed(readInstruction.variable);
                        outUsedVariables.add((PsiVariable)readInstruction.variable);
                    } else {
                        state.touch();
                    }
                }
                List<InstructionKey> backwardTraces = state.getBackwardTraces();
                for (InstructionKey prevKeys : backwardTraces) {
                    InstructionState prevState = stateMap.get(prevKeys);
                    if (prevState == null || prevState.contains(state)) continue;
                    prevState.addUsedFrom(state);
                    queue.addLast((Object)prevState);
                }
            }
        }
        ArrayList<Info> unusedDefs = new ArrayList<Info>();
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            if (!(instruction instanceof WriteVariableInstruction)) continue;
            WriteVariableInstruction writeInstruction = (WriteVariableInstruction)instruction;
            if (usefulWrites.get(i)) continue;
            PsiElement context = PsiTreeUtil.getNonStrictParentOfType((PsiElement)flow.getElement(i), (Class[])new Class[]{PsiStatement.class, PsiAssignmentExpression.class, PsiUnaryExpression.class});
            PsiVariable psiVariable = writeInstruction.variable;
            if (context == null || context instanceof PsiTryStatement) continue;
            if (context instanceof PsiDeclarationStatement && psiVariable.getInitializer() == null) {
                if (assignedVariables.contains(psiVariable)) continue;
                unusedDefs.add(new Info(psiVariable, context, false));
                continue;
            }
            unusedDefs.add(new Info(psiVariable, context, readVariables.contains(psiVariable)));
        }
        return unusedDefs;
    }

    public static PsiElement @NotNull [] getDefs(@NotNull PsiCodeBlock body2, @NotNull PsiVariable def, @NotNull PsiElement ref) {
        return DefUseUtil.getDefs(body2, def, ref, false);
    }

    public static PsiElement @NotNull [] getDefs(@NotNull PsiCodeBlock body2, final @NotNull PsiVariable def, @NotNull PsiElement ref, boolean rethrow) {
        try {
            RefsDefs refsDefs = new RefsDefs(body2){
                final PsiManager psiManager;
                private final IntArrayList[] myBackwardTraces;
                {
                    super(body2);
                    this.psiManager = def.getManager();
                    this.myBackwardTraces = DefUseUtil.getBackwardTraces(this.instructions);
                }

                @Override
                protected int nNext(int index) {
                    return this.myBackwardTraces[index].size();
                }

                @Override
                protected int getNext(int index, int no) {
                    return this.myBackwardTraces[index].getInt(no);
                }

                @Override
                protected boolean defs() {
                    return true;
                }

                @Override
                protected void processInstruction(final @NotNull Set<? super PsiElement> res, @NotNull Instruction instruction, int index) {
                    if (instruction instanceof WriteVariableInstruction) {
                        WriteVariableInstruction instructionW = (WriteVariableInstruction)instruction;
                        if (this.psiManager.areElementsEquivalent((PsiElement)instructionW.variable, (PsiElement)def)) {
                            PsiElement element = this.flow.getElement(index);
                            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                                public void visitReferenceExpression(PsiReferenceExpression ref) {
                                    if (PsiUtil.isAccessedForWriting((PsiExpression)ref) && ref.resolve() == def) {
                                        res.add(ref);
                                    }
                                }

                                public void visitVariable(PsiVariable var) {
                                    if (psiManager.areElementsEquivalent((PsiElement)var, (PsiElement)def) && (var instanceof PsiParameter || var.hasInitializer())) {
                                        res.add(var);
                                    }
                                }
                            });
                        }
                    }
                }
            };
            return refsDefs.get(def, ref);
        }
        catch (AnalysisCanceledException e) {
            if (rethrow) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
            }
            return PsiElement.EMPTY_ARRAY;
        }
    }

    public static PsiElement @NotNull [] getRefs(@NotNull PsiCodeBlock body2, @NotNull PsiVariable def, @NotNull PsiElement ref) {
        return DefUseUtil.getRefs(body2, def, ref, false);
    }

    public static PsiElement[] getRefs(@NotNull PsiCodeBlock body2, final @NotNull PsiVariable def, @NotNull PsiElement ref, boolean rethrow) {
        try {
            RefsDefs refsDefs = new RefsDefs(body2){
                final PsiManager psiManager;
                {
                    super(body2);
                    this.psiManager = def.getManager();
                }

                @Override
                protected int nNext(int index) {
                    return ((Instruction)this.instructions.get(index)).nNext();
                }

                @Override
                protected int getNext(int index, int no) {
                    return ((Instruction)this.instructions.get(index)).getNext(index, no);
                }

                @Override
                protected boolean defs() {
                    return false;
                }

                @Override
                protected void processInstruction(final @NotNull Set<? super PsiElement> res, @NotNull Instruction instruction, int index) {
                    if (instruction instanceof ReadVariableInstruction) {
                        ReadVariableInstruction instructionR = (ReadVariableInstruction)instruction;
                        if (this.psiManager.areElementsEquivalent((PsiElement)instructionR.variable, (PsiElement)def)) {
                            PsiElement element = this.flow.getElement(index);
                            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                                public void visitReferenceExpression(PsiReferenceExpression ref) {
                                    if (ref.isReferenceTo((PsiElement)def)) {
                                        res.add(ref);
                                    }
                                }
                            });
                        }
                    }
                }
            };
            return refsDefs.get(def, ref);
        }
        catch (AnalysisCanceledException e) {
            if (rethrow) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
            }
            return PsiElement.EMPTY_ARRAY;
        }
    }

    private static IntArrayList @NotNull [] getBackwardTraces(@NotNull List<? extends Instruction> instructions) {
        int i;
        IntArrayList[] states = new IntArrayList[instructions.size()];
        for (i = 0; i < states.length; ++i) {
            states[i] = new IntArrayList();
        }
        for (i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            for (int j = 0; j != instruction.nNext(); ++j) {
                int next = instruction.getNext(i, j);
                if (next >= states.length) continue;
                states[next].add(i);
            }
        }
        return states;
    }

    private static final class InstructionStateWalker {
        private final Map<InstructionKey, InstructionState> myStates;
        private final WalkThroughStack myWalkThroughStack;
        private final List<? extends Instruction> myInstructions;

        private InstructionStateWalker(@NotNull List<? extends Instruction> instructions) {
            this.myStates = new THashMap(instructions.size());
            this.myWalkThroughStack = new WalkThroughStack(instructions.size() / 2);
            this.myInstructions = instructions;
        }

        @NotNull
        private Map<InstructionKey, InstructionState> walk() {
            InstructionKey startKey = InstructionKey.create(0);
            this.myStates.put(startKey, new InstructionState(startKey));
            this.myWalkThroughStack.push(InstructionKey.create(-1), startKey);
            InstructionKeySet visited = new InstructionKeySet(this.myInstructions.size() + 1);
            while (!this.myWalkThroughStack.isEmpty()) {
                ProgressManager.checkCanceled();
                InstructionKey fromKey = this.myWalkThroughStack.peekFrom();
                InstructionKey nextKey = this.myWalkThroughStack.popNext();
                this.addBackwardTrace(fromKey, nextKey);
                if (visited.contains(nextKey)) continue;
                this.visit(nextKey);
                visited.add(nextKey);
            }
            return this.myStates;
        }

        private void visit(@NotNull InstructionKey fromKey) {
            if (fromKey.getOffset() >= this.myInstructions.size()) {
                return;
            }
            Instruction instruction = this.myInstructions.get(fromKey.getOffset());
            if (instruction instanceof CallInstruction) {
                int nextOffset = ((CallInstruction)instruction).offset;
                LOG.assertTrue(nextOffset != 0);
                int returnOffset = fromKey.getOffset() + 1;
                InstructionKey nextKey = fromKey.push(nextOffset, returnOffset);
                this.myWalkThroughStack.push(fromKey, nextKey);
            } else if (instruction instanceof ReturnInstruction) {
                int overriddenOffset = ((ReturnInstruction)instruction).offset;
                InstructionKey nextKey = fromKey.pop(overriddenOffset);
                this.myWalkThroughStack.push(fromKey, nextKey);
            } else {
                for (int no = 0; no != instruction.nNext(); ++no) {
                    int nextOffset = instruction.getNext(fromKey.getOffset(), no);
                    InstructionKey nextKey = fromKey.next(nextOffset);
                    this.myWalkThroughStack.push(fromKey, nextKey);
                }
            }
        }

        private void addBackwardTrace(@NotNull InstructionKey fromKey, @NotNull InstructionKey nextKey) {
            if (fromKey.getOffset() >= 0 && nextKey.getOffset() < this.myInstructions.size()) {
                InstructionState state = this.myStates.get(nextKey);
                if (state == null) {
                    state = new InstructionState(nextKey);
                    this.myStates.put(nextKey, state);
                }
                state.addBackwardTrace(fromKey);
            }
        }

        @NotNull
        static Map<InstructionKey, InstructionState> getStates(@NotNull List<? extends Instruction> instructions) {
            return new InstructionStateWalker(instructions).walk();
        }
    }

    private static class WalkThroughStack {
        private final Stack<InstructionKey> myFrom;
        private final Stack<InstructionKey> myNext;

        WalkThroughStack(int size) {
            if (size < 2) {
                size = 2;
            }
            this.myFrom = new Stack(size);
            this.myNext = new Stack(size);
        }

        void push(@NotNull InstructionKey fromKey, @NotNull InstructionKey nextKey) {
            this.myFrom.push((Object)fromKey);
            this.myNext.push((Object)nextKey);
        }

        @NotNull
        InstructionKey peekFrom() {
            return (InstructionKey)this.myFrom.peek();
        }

        @NotNull
        InstructionKey popNext() {
            this.myFrom.pop();
            return (InstructionKey)this.myNext.pop();
        }

        boolean isEmpty() {
            return this.myFrom.isEmpty();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int limit = Math.min(this.myFrom.size(), this.myNext.size());
            for (int i = 0; i < limit; ++i) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(this.myFrom.get(i)).append("->").append(this.myNext.get(i));
            }
            return sb.toString();
        }
    }

    private static abstract class RefsDefs {
        @NotNull
        final List<Instruction> instructions;
        final ControlFlow flow;
        final PsiCodeBlock body;

        protected abstract int nNext(int var1);

        protected abstract int getNext(int var1, int var2);

        RefsDefs(@NotNull PsiCodeBlock body2) throws AnalysisCanceledException {
            this.body = body2;
            this.flow = ControlFlowFactory.getInstance(body2.getProject()).getControlFlow((PsiElement)body2, ourPolicy, false, false);
            this.instructions = this.flow.getInstructions();
        }

        protected abstract void processInstruction(@NotNull Set<? super PsiElement> var1, @NotNull Instruction var2, int var3);

        protected abstract boolean defs();

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private PsiElement @NotNull [] get(@NotNull PsiVariable def, @NotNull PsiElement refOrDef) {
            int elem;
            if (this.body == null) {
                return PsiElement.EMPTY_ARRAY;
            }
            boolean[] visited = new boolean[this.instructions.size() + 1];
            visited[visited.length - 1] = true;
            boolean defs = this.defs();
            int n = elem = defs ? this.flow.getStartOffset(refOrDef) : this.flow.getEndOffset(refOrDef);
            if (elem == -1 && def instanceof PsiParameter) {
                elem = 0;
            }
            if (elem != -1) {
                if (!defs && this.instructions.get(elem) instanceof ReadVariableInstruction) {
                    LOG.assertTrue(this.nNext(elem) == 1);
                    LOG.assertTrue(this.getNext(elem, 0) == elem + 1);
                    ++elem;
                }
                @NotNull THashSet res = new THashSet();
                int startIndex = elem;
                IntArrayList workQueue = new IntArrayList();
                workQueue.add(startIndex);
                PsiManager psiManager = this.body.getManager();
                while (!workQueue.isEmpty()) {
                    int index = workQueue.removeInt(workQueue.size() - 1);
                    if (visited[index]) continue;
                    visited[index] = true;
                    if (defs) {
                        PsiIdentifier identifier;
                        Instruction instruction = this.instructions.get(index);
                        this.processInstruction((Set<? super PsiElement>)res, instruction, index);
                        if (instruction instanceof WriteVariableInstruction) {
                            WriteVariableInstruction instructionW = (WriteVariableInstruction)instruction;
                            if (psiManager.areElementsEquivalent((PsiElement)instructionW.variable, (PsiElement)def)) continue;
                        }
                        if (index == 0 && def instanceof PsiParameter && (identifier = def.getNameIdentifier()) != null) {
                            res.add(identifier);
                        }
                    }
                    int nNext = this.nNext(index);
                    for (int i = 0; i < nNext; ++i) {
                        int prev = this.getNext(index, i);
                        if (visited[prev]) continue;
                        if (!defs) {
                            Instruction instruction = this.instructions.get(prev);
                            if (instruction instanceof WriteVariableInstruction) {
                                WriteVariableInstruction instructionW = (WriteVariableInstruction)instruction;
                                if (psiManager.areElementsEquivalent((PsiElement)instructionW.variable, (PsiElement)def)) {
                                    continue;
                                }
                            } else {
                                this.processInstruction((Set<? super PsiElement>)res, instruction, prev);
                            }
                        }
                        workQueue.add(prev);
                    }
                }
                return PsiUtilCore.toPsiElementArray((Collection)res);
            }
            return PsiElement.EMPTY_ARRAY;
        }
    }

    private static class InstructionState
    implements Comparable<InstructionState> {
        private Set<PsiVariable> myUsed;
        @NotNull
        private final InstructionKey myInstructionKey;
        private final List<InstructionKey> myBackwardTraces;
        private boolean myIsVisited;

        InstructionState(@NotNull InstructionKey instructionKey) {
            this.myInstructionKey = instructionKey;
            this.myBackwardTraces = new ArrayList<InstructionKey>(2);
            this.myUsed = null;
        }

        void addBackwardTrace(@NotNull InstructionKey key2) {
            this.myBackwardTraces.add(key2);
        }

        @NotNull
        List<InstructionKey> getBackwardTraces() {
            return this.myBackwardTraces;
        }

        @NotNull
        InstructionKey getInstructionKey() {
            return this.myInstructionKey;
        }

        void addUsed(@NotNull PsiVariable psiVariable) {
            this.touch();
            this.myUsed.add(psiVariable);
        }

        boolean removeUsed(PsiVariable psiVariable) {
            this.touch();
            return this.myUsed.remove(psiVariable);
        }

        private void touch() {
            if (this.myUsed == null) {
                this.myUsed = new THashSet();
            }
        }

        void addUsedFrom(InstructionState state) {
            this.touch();
            this.myUsed.addAll(state.myUsed);
        }

        public boolean contains(InstructionState state) {
            return this.myUsed != null && state.myUsed != null && this.myUsed.containsAll(state.myUsed);
        }

        void markVisited() {
            this.myIsVisited = true;
        }

        public boolean isVisited() {
            return this.myIsVisited;
        }

        @Override
        public int compareTo(@NotNull InstructionState other) {
            return this.myInstructionKey.compareTo(other.myInstructionKey);
        }

        public String toString() {
            return this.myInstructionKey + " " + this.myBackwardTraces + (this.myIsVisited ? "(v)" : "(n)") + " " + (this.myUsed != null ? this.myUsed : "-");
        }
    }

    public static class Info {
        @NotNull
        private final PsiVariable myVariable;
        @NotNull
        private final PsiElement myContext;
        private final boolean myIsRead;

        public Info(@NotNull PsiVariable variable, @NotNull PsiElement context, boolean read2) {
            this.myVariable = variable;
            this.myContext = context;
            this.myIsRead = read2;
        }

        @NotNull
        public PsiVariable getVariable() {
            return this.myVariable;
        }

        @NotNull
        public PsiElement getContext() {
            return this.myContext;
        }

        public boolean isRead() {
            return this.myIsRead;
        }
    }
}

