/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ModifierAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.NameAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.TypeAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaElementArrangementEntry
extends DefaultArrangementEntry
implements TypeAwareArrangementEntry,
NameAwareArrangementEntry,
ModifierAwareArrangementEntry {
    @NotNull
    private final Set<ArrangementSettingsToken> myModifiers = new HashSet<ArrangementSettingsToken>();
    @NotNull
    private final Set<ArrangementSettingsToken> myTypes = new HashSet<ArrangementSettingsToken>();
    @NotNull
    private final ArrangementSettingsToken myType;
    @Nullable
    private final String myName;

    public JavaElementArrangementEntry(@Nullable ArrangementEntry parent, @NotNull TextRange range, @NotNull ArrangementSettingsToken type2, @Nullable String name2, boolean canBeMatched) {
        this(parent, range.getStartOffset(), range.getEndOffset(), type2, name2, canBeMatched);
    }

    public JavaElementArrangementEntry(@Nullable ArrangementEntry parent, int startOffset, int endOffset, @NotNull ArrangementSettingsToken type2, @Nullable String name2, boolean canBeArranged) {
        super(parent, startOffset, endOffset, canBeArranged);
        this.myType = type2;
        this.myTypes.add(type2);
        this.myName = name2;
    }

    @NotNull
    public Set<ArrangementSettingsToken> getModifiers() {
        return this.myModifiers;
    }

    public void addModifier(@NotNull ArrangementSettingsToken modifier) {
        this.myModifiers.add(modifier);
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @NotNull
    public Set<ArrangementSettingsToken> getTypes() {
        return this.myTypes;
    }

    @NotNull
    public ArrangementSettingsToken getType() {
        return this.myType;
    }

    public String toString() {
        return String.format("[%d; %d): %s %s %s", this.getStartOffset(), this.getEndOffset(), StringUtil.toLowerCase((String)StringUtil.join(this.myModifiers, (String)" ")), StringUtil.toLowerCase((String)this.myTypes.iterator().next().toString()), this.myName == null ? "<no name>" : this.myName);
    }
}

