/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.java;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.java.JavaBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.components.LegalNoticeDialog;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="AcceptedLanguageLevels", storages={@Storage(value="acceptedLanguageLevels.xml")})
public class AcceptedLanguageLevelsSettings
implements PersistentStateComponent<AcceptedLanguageLevelsSettings>,
StartupActivity {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Accepted language levels", NotificationDisplayType.STICKY_BALLOON, true);
    private static final NotificationGroup PREVIEW_NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Java Preview Features");
    private static final String IGNORE_USED_PREVIEW_FEATURES = "ignore.preview.features.used";
    @XCollection(propertyElementName="explicitly-accepted", elementName="name", valueAttributeName="")
    public List<String> acceptedNames = new ArrayList<String>();

    public void runActivity(final @NotNull Project project) {
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            if (!project.isDisposed()) {
                TreeSet<Object> previewLevels = new TreeSet<Object>();
                MultiMap unacceptedLevels = new MultiMap();
                LanguageLevelProjectExtension projectExtension = LanguageLevelProjectExtension.getInstance((Project)project);
                if (projectExtension != null) {
                    Module[] level = projectExtension.getLanguageLevel();
                    if (!AcceptedLanguageLevelsSettings.isLanguageLevelAccepted((LanguageLevel)level)) {
                        unacceptedLevels.putValue((Object)level, null);
                    }
                    if (level.isPreview()) {
                        previewLevels.add(level);
                    }
                }
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    LanguageLevel level;
                    LanguageLevelModuleExtensionImpl moduleExtension = LanguageLevelModuleExtensionImpl.getInstance((Module)module);
                    if (moduleExtension == null || (level = moduleExtension.getLanguageLevel()) == null) continue;
                    if (!AcceptedLanguageLevelsSettings.isLanguageLevelAccepted(level)) {
                        unacceptedLevels.putValue((Object)level, (Object)module);
                    }
                    if (!level.isPreview()) continue;
                    previewLevels.add(level);
                }
                if (!unacceptedLevels.isEmpty()) {
                    AcceptedLanguageLevelsSettings.decreaseLanguageLevel(project);
                    for (LanguageLevel level : unacceptedLevels.keySet()) {
                        NOTIFICATION_GROUP.createNotification(JavaBundle.message((String)"java.preview.features.alert.title", (Object[])new Object[0]), JavaBundle.message((String)"java.preview.features.legal.notice", (Object[])new Object[]{level.getPresentableText(), "<br/><br/><a href=''accept''>" + JavaBundle.message((String)"java.preview.features.accept.notification.link", (Object[])new Object[0]) + "</a>"}), NotificationType.WARNING, (notification, event) -> {
                            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                if (event.getDescription().equals("accept")) {
                                    AcceptedLanguageLevelsSettings.acceptAndRestore(project, unacceptedLevels.get((Object)level), level);
                                }
                                notification.expire();
                            }
                        }).notify(project);
                    }
                }
                if (!previewLevels.isEmpty() && !PropertiesComponent.getInstance((Project)project).getBoolean(IGNORE_USED_PREVIEW_FEATURES, false)) {
                    Optional languageLevel = previewLevels.stream().min(Comparator.naturalOrder());
                    assert (languageLevel.isPresent());
                    int previewFeature = ((LanguageLevel)languageLevel.get()).toJavaVersion().feature;
                    Notification notification2 = PREVIEW_NOTIFICATION_GROUP.createNotification(JavaBundle.message((String)"java.preview.features.notification.title", (Object[])new Object[0]), JavaBundle.message((String)"java.preview.features.notification.message", (Object[])new Object[0]), JavaBundle.message((String)"java.preview.features.warning", (Object[])new Object[]{previewFeature + 1, previewFeature}), NotificationType.WARNING);
                    notification2.addAction((AnAction)new NotificationAction(IdeBundle.message((String)"action.Anonymous.text.do.not.show.again", (Object[])new Object[0])){

                        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                            PropertiesComponent.getInstance((Project)project).setValue(AcceptedLanguageLevelsSettings.IGNORE_USED_PREVIEW_FEATURES, true);
                            notification.expire();
                        }
                    });
                    notification2.notify(project);
                }
            }
        });
    }

    public static boolean isLanguageLevelAccepted(LanguageLevel languageLevel) {
        if (ApplicationManager.getApplication().isEAP()) {
            return true;
        }
        return LanguageLevel.HIGHEST.compareTo((Enum)languageLevel) >= 0 || AcceptedLanguageLevelsSettings.getSettings().acceptedNames.contains(languageLevel.name());
    }

    private static void acceptAndRestore(Project project, Collection<? extends Module> modules, LanguageLevel languageLevel) {
        if (!AcceptedLanguageLevelsSettings.getSettings().acceptedNames.contains(languageLevel.name())) {
            AcceptedLanguageLevelsSettings.getSettings().acceptedNames.add(languageLevel.name());
        }
        if (modules != null) {
            JavaProjectModelModificationService service = JavaProjectModelModificationService.getInstance(project);
            WriteAction.run(() -> {
                for (Module module : modules) {
                    if (module != null) {
                        service.changeLanguageLevel(module, languageLevel);
                        continue;
                    }
                    LanguageLevelProjectExtension projectExtension = LanguageLevelProjectExtension.getInstance((Project)project);
                    projectExtension.setLanguageLevel(languageLevel);
                    projectExtension.setDefault(Boolean.valueOf(false));
                }
            });
        }
    }

    public static LanguageLevel getHighestAcceptedLevel() {
        LanguageLevel highest = LanguageLevel.HIGHEST;
        for (LanguageLevel level : LanguageLevel.values()) {
            if (!AcceptedLanguageLevelsSettings.isLanguageLevelAccepted(level)) break;
            highest = level;
        }
        return highest;
    }

    private static AcceptedLanguageLevelsSettings getSettings() {
        return (AcceptedLanguageLevelsSettings)ServiceManager.getService(AcceptedLanguageLevelsSettings.class);
    }

    @Nullable
    public AcceptedLanguageLevelsSettings getState() {
        return this;
    }

    public void loadState(@NotNull AcceptedLanguageLevelsSettings state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public static LanguageLevel checkAccepted(Component parent, LanguageLevel level) {
        return level == null || AcceptedLanguageLevelsSettings.isLanguageLevelAccepted(level) || AcceptedLanguageLevelsSettings.showDialog(parent, level) ? level : null;
    }

    private static boolean showDialog(Component parent, LanguageLevel level) {
        int result = LegalNoticeDialog.build((String)JavaBundle.message((String)"java.preview.features.alert.title", (Object[])new Object[0]), (String)JavaBundle.message((String)"java.preview.features.legal.notice", (Object[])new Object[]{level.getPresentableText(), ""})).withParent(parent).show();
        if (result == 0) {
            AcceptedLanguageLevelsSettings.acceptAndRestore(null, null, level);
            return true;
        }
        return false;
    }

    private static void decreaseLanguageLevel(Project project) {
        WriteAction.run(() -> {
            LanguageLevel highestAcceptedLevel = AcceptedLanguageLevelsSettings.getHighestAcceptedLevel();
            JavaProjectModelModificationService service = JavaProjectModelModificationService.getInstance(project);
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                LanguageLevel languageLevel = LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
                if (languageLevel == null || AcceptedLanguageLevelsSettings.isLanguageLevelAccepted(languageLevel)) continue;
                LanguageLevel newLanguageLevel = highestAcceptedLevel.isAtLeast(languageLevel) ? LanguageLevel.HIGHEST : highestAcceptedLevel;
                service.changeLanguageLevel(module, newLanguageLevel);
            }
            LanguageLevelProjectExtension projectExtension = LanguageLevelProjectExtension.getInstance((Project)project);
            if (!AcceptedLanguageLevelsSettings.isLanguageLevelAccepted(projectExtension.getLanguageLevel())) {
                projectExtension.setLanguageLevel(highestAcceptedLevel);
                projectExtension.setDefault(Boolean.valueOf(false));
            }
        });
    }

    public static void allowLevel(@NotNull Disposable parentDisposable, @NotNull LanguageLevel level) {
        List<String> acceptedNames = AcceptedLanguageLevelsSettings.getSettings().acceptedNames;
        String name2 = level.name();
        if (!acceptedNames.contains(name2)) {
            acceptedNames.add(name2);
            Disposer.register((Disposable)parentDisposable, () -> AcceptedLanguageLevelsSettings.getSettings().acceptedNames.remove(name2));
        }
    }
}

