/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.packaging.impl.ui.actions.PackageFileWorker;
import com.intellij.util.text.SyncDateFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PackageFileAction
extends AnAction {
    public PackageFileAction() {
        super(JavaCompilerBundle.messagePointer((String)"action.name.package.file", (Object[])new Object[0]), JavaCompilerBundle.messagePointer((String)"action.description.package.file", (Object[])new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent e) {
        List<VirtualFile> files;
        boolean visible = false;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project != null && !(files = PackageFileAction.getFilesToPackage(e, project)).isEmpty()) {
            visible = true;
            e.getPresentation().setText(files.size() == 1 ? JavaCompilerBundle.message((String)"action.name.package.file", (Object[])new Object[0]) : JavaCompilerBundle.message((String)"action.name.package.files", (Object[])new Object[0]));
        }
        e.getPresentation().setVisible(visible);
    }

    @NotNull
    private static List<VirtualFile> getFilesToPackage(@NotNull AnActionEvent e, @NotNull Project project) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        block0: for (VirtualFile file : files) {
            if (file == null || file.isDirectory() || fileIndex.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.SOURCES) && compilerManager.isCompilableFileType(file.getFileType())) {
                return Collections.emptyList();
            }
            Collection<? extends Artifact> artifacts = ArtifactBySourceFileFinder.getInstance(project).findArtifacts(file);
            for (Artifact artifact : artifacts) {
                if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
                result.add(file);
                continue block0;
            }
        }
        return result;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        List<VirtualFile> files = PackageFileAction.getFilesToPackage(event, project);
        Artifact[] allArtifacts = ArtifactManager.getInstance((Project)project).getArtifacts();
        PackageFileWorker.startPackagingFiles(project, files, allArtifacts, () -> PackageFileAction.setStatusText(project, files));
    }

    private static void setStatusText(Project project, List<VirtualFile> files) {
        if (!files.isEmpty()) {
            StringBuilder fileNames = new StringBuilder();
            for (VirtualFile file : files) {
                if (fileNames.length() != 0) {
                    fileNames.append(", ");
                }
                fileNames.append("'").append(file.getName()).append("'");
            }
            String time = Holder.TIME_FORMAT.format(Clock.getTime());
            String statusText = JavaCompilerBundle.message((String)"status.text.file.has.been.packaged", (Object[])new Object[]{files.size(), fileNames, time});
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            if (statusBar != null) {
                statusBar.setInfo(statusText);
            }
        }
    }

    private static class Holder {
        private static final SyncDateFormat TIME_FORMAT = new SyncDateFormat((DateFormat)new SimpleDateFormat("h:mm:ss a"));

        private Holder() {
        }
    }
}

