/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.ModulePackagingElementBase;
import com.intellij.packaging.impl.elements.ProductionModuleSourceElementType;
import com.intellij.packaging.impl.ui.DelegatedPackagingElementPresentation;
import com.intellij.packaging.impl.ui.ModuleElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0015\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u0006\u0010\n\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\n\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0017\u00a8\u0006\u0015"}, d2={"Lcom/intellij/packaging/impl/elements/ProductionModuleSourcePackagingElement;", "Lcom/intellij/packaging/impl/elements/ModulePackagingElementBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "modulePointer", "Lcom/intellij/openapi/module/ModulePointer;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/ModulePointer;)V", "createPresentation", "Lcom/intellij/packaging/ui/PackagingElementPresentation;", "context", "Lcom/intellij/packaging/ui/ArtifactEditorContext;", "getFilesKind", "Lcom/intellij/packaging/elements/PackagingElementOutputKind;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/packaging/elements/PackagingElementResolvingContext;", "getSourceRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "toString", "", "intellij.java.compiler.impl"})
public final class ProductionModuleSourcePackagingElement
extends ModulePackagingElementBase {
    @Override
    @NotNull
    public Collection<VirtualFile> getSourceRoots(@NotNull PackagingElementResolvingContext context) {
        Module module = this.findModule(context);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        ModuleRootModel rootModel = context.getModulesProvider().getRootModel(module2);
        return rootModel.getSourceRoots(JavaModuleSourceRootTypes.PRODUCTION);
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        return new DelegatedPackagingElementPresentation(new ModuleElementPresentation(this.myModulePointer, context, ProductionModuleSourceElementType.ELEMENT_TYPE));
    }

    @NotNull
    public PackagingElementOutputKind getFilesKind(@NotNull PackagingElementResolvingContext context) {
        return PackagingElementOutputKind.OTHER;
    }

    @NonNls
    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("module sources:");
        String string = this.getModuleName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return stringBuilder.append(string).toString();
    }

    public ProductionModuleSourcePackagingElement(@NotNull Project project) {
        super(ProductionModuleSourceElementType.ELEMENT_TYPE, project);
    }

    public ProductionModuleSourcePackagingElement(@NotNull Project project, @NotNull ModulePointer modulePointer) {
        super(ProductionModuleSourceElementType.ELEMENT_TYPE, project, modulePointer);
    }
}

