/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.elements.CompositeElementWithManifest;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.DirectoryElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DirectoryPackagingElement
extends CompositeElementWithManifest<DirectoryPackagingElement> {
    @NonNls
    public static final String NAME_ATTRIBUTE = "name";
    private String myDirectoryName;

    public DirectoryPackagingElement() {
        super(PackagingElementFactoryImpl.DIRECTORY_ELEMENT_TYPE);
    }

    public DirectoryPackagingElement(String directoryName) {
        super(PackagingElementFactoryImpl.DIRECTORY_ELEMENT_TYPE);
        this.myDirectoryName = directoryName;
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        return new DirectoryElementPresentation(this);
    }

    public DirectoryPackagingElement getState() {
        return this;
    }

    @NonNls
    public String toString() {
        return "dir:" + this.myDirectoryName;
    }

    @Attribute(value="name")
    public String getDirectoryName() {
        return this.myDirectoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.myDirectoryName = directoryName;
    }

    public void rename(@NotNull String newName) {
        this.myDirectoryName = newName;
    }

    public String getName() {
        return this.myDirectoryName;
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        return element instanceof DirectoryPackagingElement && ((DirectoryPackagingElement)element).getDirectoryName().equals(this.myDirectoryName);
    }

    public void loadState(@NotNull DirectoryPackagingElement state) {
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }
}

