/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactCompileScope {
    private static final Key<Boolean> FORCE_ARTIFACT_BUILD = Key.create((String)"force_artifact_build");
    private static final Key<Artifact[]> ARTIFACTS_KEY = Key.create((String)"artifacts");
    private static final Key<Set<Artifact>> CACHED_ARTIFACTS_KEY = Key.create((String)"cached_artifacts");

    private ArtifactCompileScope() {
    }

    public static ModuleCompileScope createScopeForModulesInArtifacts(@NotNull Project project, @NotNull Collection<? extends Artifact> artifacts) {
        Set<Module> modules = ArtifactUtil.getModulesIncludedInArtifacts(artifacts, project);
        return new ModuleCompileScope(project, modules.toArray(Module.EMPTY_ARRAY), true);
    }

    public static CompileScope createArtifactsScope(@NotNull Project project, @NotNull Collection<? extends Artifact> artifacts) {
        return ArtifactCompileScope.createArtifactsScope(project, artifacts, false);
    }

    public static CompileScope createArtifactsScope(@NotNull Project project, @NotNull Collection<? extends Artifact> artifacts, boolean forceArtifactBuild) {
        return ArtifactCompileScope.createScopeWithArtifacts(ArtifactCompileScope.createScopeForModulesInArtifacts(project, artifacts), artifacts, forceArtifactBuild);
    }

    public static CompileScope createScopeWithArtifacts(CompileScope baseScope, @NotNull Collection<? extends Artifact> artifacts) {
        return ArtifactCompileScope.createScopeWithArtifacts(baseScope, artifacts, false);
    }

    public static CompileScope createScopeWithArtifacts(CompileScope baseScope, @NotNull Collection<? extends Artifact> artifacts, boolean forceArtifactBuild) {
        baseScope.putUserData(ARTIFACTS_KEY, (Object)artifacts.toArray(new Artifact[0]));
        if (forceArtifactBuild) {
            baseScope.putUserData(FORCE_ARTIFACT_BUILD, (Object)Boolean.TRUE);
        }
        return baseScope;
    }

    public static Set<Artifact> getArtifactsToBuild(Project project, CompileScope compileScope, boolean addIncludedArtifactsWithOutputPathsOnly) {
        Artifact[] artifactsFromScope = ArtifactCompileScope.getArtifacts(compileScope);
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
        PackagingElementResolvingContext context = artifactManager.getResolvingContext();
        if (artifactsFromScope != null) {
            return ArtifactCompileScope.addIncludedArtifacts(Arrays.asList(artifactsFromScope), context, addIncludedArtifactsWithOutputPathsOnly);
        }
        Set cached = (Set)compileScope.getUserData(CACHED_ARTIFACTS_KEY);
        if (cached != null) {
            return cached;
        }
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        Set modules = ContainerUtil.set((Object[])compileScope.getAffectedModules());
        List<Module> allModules = Arrays.asList(ModuleManager.getInstance((Project)project).getModules());
        for (Artifact artifact : artifactManager.getArtifacts()) {
            if (!artifact.isBuildOnMake() || !modules.containsAll(allModules) && !ArtifactCompileScope.containsModuleOutput(artifact, modules, context)) continue;
            artifacts.add(artifact);
        }
        Set<Artifact> result = ArtifactCompileScope.addIncludedArtifacts(artifacts, context, addIncludedArtifactsWithOutputPathsOnly);
        compileScope.putUserData(CACHED_ARTIFACTS_KEY, result);
        return result;
    }

    public static Artifact @Nullable [] getArtifacts(CompileScope compileScope) {
        return (Artifact[])compileScope.getUserData(ARTIFACTS_KEY);
    }

    public static boolean isArtifactRebuildForced(@NotNull CompileScope scope) {
        return Boolean.TRUE.equals(scope.getUserData(FORCE_ARTIFACT_BUILD));
    }

    private static boolean containsModuleOutput(Artifact artifact, Set<? extends Module> modules, PackagingElementResolvingContext context) {
        return !ArtifactUtil.processPackagingElements(artifact, ProductionModuleOutputElementType.ELEMENT_TYPE, moduleOutputPackagingElement -> {
            Module module = moduleOutputPackagingElement.findModule(context);
            return module == null || !modules.contains(module);
        }, context, true);
    }

    @NotNull
    private static Set<Artifact> addIncludedArtifacts(@NotNull Collection<? extends Artifact> artifacts, @NotNull PackagingElementResolvingContext context, boolean withOutputPathOnly) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            ArtifactCompileScope.collectIncludedArtifacts(artifact, context, new HashSet(), result, withOutputPathOnly);
        }
        return result;
    }

    private static void collectIncludedArtifacts(Artifact artifact, PackagingElementResolvingContext context, Set<? super Artifact> processed, Set<? super Artifact> result, boolean withOutputPathOnly) {
        if (!processed.add((Artifact)artifact)) {
            return;
        }
        if (!withOutputPathOnly || !StringUtil.isEmpty((String)artifact.getOutputPath())) {
            result.add((Artifact)artifact);
        }
        ArtifactUtil.processPackagingElements(artifact, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, element -> {
            Artifact included = element.findArtifact(context);
            if (included != null) {
                ArtifactCompileScope.collectIncludedArtifacts(included, context, processed, result, withOutputPathOnly);
            }
            return true;
        }, context, false);
    }
}

