/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyVisitorFactory;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class JavaDependencyVisitorFactory
extends DependencyVisitorFactory {
    @NotNull
    public PsiElementVisitor getVisitor(@NotNull DependenciesBuilder.DependencyProcessor processor2, @NotNull DependencyVisitorFactory.VisitorOptions options) {
        return new MyVisitor(processor2, options);
    }

    private static class MyVisitor
    extends JavaRecursiveElementVisitor {
        private final DependenciesBuilder.DependencyProcessor myProcessor;
        private final DependencyVisitorFactory.VisitorOptions myOptions;

        MyVisitor(DependenciesBuilder.DependencyProcessor processor2, DependencyVisitorFactory.VisitorOptions options) {
            this.myProcessor = processor2;
            this.myOptions = options;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression2);
        }

        public void visitElement(@NotNull PsiElement element) {
            super.visitElement(element);
            for (PsiReference ref : element.getReferences()) {
                PsiElement resolved = ref.resolve();
                if (resolved == null) continue;
                this.myProcessor.process(ref.getElement(), resolved);
            }
        }

        public void visitLiteralExpression(PsiLiteralExpression expression2) {
        }

        public void visitDocComment(PsiDocComment comment) {
        }

        public void visitImportStatement(PsiImportStatement statement) {
            if (!this.myOptions.skipImports()) {
                this.visitElement((PsiElement)statement);
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            PsiClass psiClass;
            PsiType returnType;
            super.visitMethodCallExpression(expression2);
            PsiMethod psiMethod = expression2.resolveMethod();
            if (psiMethod != null && (returnType = psiMethod.getReturnType()) != null && (psiClass = PsiUtil.resolveClassInType((PsiType)returnType)) != null && !(psiClass instanceof PsiTypeParameter)) {
                this.myProcessor.process((PsiElement)expression2, (PsiElement)psiClass);
            }
        }
    }
}

