/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.roots.ui.configuration.GeneralProjectSettingsElement;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructureBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.ui.navigation.Place;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class UsagesInUnloadedModules
extends ProjectStructureElementUsage {
    private final StructureConfigurableContext myContext;
    private final GeneralProjectSettingsElement myContainingElement;
    private final ProjectStructureElement mySourceElement;
    private final String myPresentableName;

    public UsagesInUnloadedModules(@NotNull StructureConfigurableContext context, @NotNull GeneralProjectSettingsElement element, @NotNull ProjectStructureElement sourceElement, @NotNull Collection<UnloadedModuleDescription> unloadedModules) {
        this.myContext = context;
        this.myContainingElement = element;
        this.mySourceElement = sourceElement;
        this.myPresentableName = unloadedModules.size() > 1 ? unloadedModules.size() + " Unloaded Modules" : "Unloaded Module '" + ((UnloadedModuleDescription)Objects.requireNonNull(ContainerUtil.getFirstItem(unloadedModules))).getName() + "'";
    }

    @Override
    public ProjectStructureElement getSourceElement() {
        return this.mySourceElement;
    }

    @Override
    public ProjectStructureElement getContainingElement() {
        return this.myContainingElement;
    }

    @Override
    public String getPresentableName() {
        return this.myPresentableName;
    }

    @Override
    public PlaceInProjectStructure getPlace() {
        Place configurablePlace = ProjectStructureConfigurable.getInstance(this.myContext.getProject()).createProjectConfigurablePlace();
        return new PlaceInProjectStructureBase(this.myContext.getProject(), configurablePlace, this.myContainingElement, false);
    }

    @Override
    public void removeSourceElement() {
    }

    @Override
    public void replaceElement(ProjectStructureElement newElement) {
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Modules.UnloadedModule;
    }

    @Override
    public int hashCode() {
        return this.mySourceElement.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof UsagesInUnloadedModules && this.mySourceElement.equals(((UsagesInUnloadedModules)obj).mySourceElement);
    }
}

