/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.util.ActionCallback;
import org.jetbrains.annotations.NotNull;

public class PlaceInModuleClasspath
extends PlaceInProjectStructure {
    private final StructureConfigurableContext myContext;
    private final Module myModule;
    private final ProjectStructureElement myElement;
    private final OrderEntry myOrderEntry;

    public PlaceInModuleClasspath(StructureConfigurableContext context, Module module, ProjectStructureElement element, OrderEntry orderEntry) {
        this.myContext = context;
        this.myModule = module;
        this.myElement = element;
        this.myOrderEntry = orderEntry;
    }

    public PlaceInModuleClasspath(@NotNull StructureConfigurableContext context, @NotNull Module module, ProjectStructureElement element, @NotNull ProjectStructureElement elementInClasspath) {
        this.myContext = context;
        this.myModule = module;
        this.myElement = element;
        ModuleRootModel rootModel = this.myContext.getModulesConfigurator().getRootModel(this.myModule);
        this.myOrderEntry = elementInClasspath instanceof LibraryProjectStructureElement ? OrderEntryUtil.findLibraryOrderEntry((ModuleRootModel)rootModel, (Library)((LibraryProjectStructureElement)elementInClasspath).getLibrary()) : (elementInClasspath instanceof ModuleProjectStructureElement ? OrderEntryUtil.findModuleOrderEntry((ModuleRootModel)rootModel, (Module)((ModuleProjectStructureElement)elementInClasspath).getModule()) : (elementInClasspath instanceof SdkProjectStructureElement ? OrderEntryUtil.findJdkOrderEntry((ModuleRootModel)rootModel, (Sdk)((SdkProjectStructureElement)elementInClasspath).getSdk()) : null));
    }

    @Override
    @NotNull
    public ProjectStructureElement getContainingElement() {
        return this.myElement;
    }

    @Override
    public String getPlacePath() {
        return this.myOrderEntry != null ? this.myOrderEntry.getPresentableName() : null;
    }

    @Override
    @NotNull
    public ActionCallback navigate() {
        return ProjectStructureConfigurable.getInstance(this.myContext.getProject()).selectOrderEntry(this.myModule, this.myOrderEntry);
    }
}

