/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibrariesContainerFactory {
    private static final Logger LOG = Logger.getInstance(LibrariesContainerFactory.class);
    private static final Library[] EMPTY_LIBRARIES_ARRAY = Library.EMPTY_ARRAY;

    private LibrariesContainerFactory() {
    }

    @NotNull
    public static LibrariesContainer createContainer(@Nullable Project project) {
        return new LibrariesContainerImpl(project, null, null);
    }

    @NotNull
    public static LibrariesContainer createContainer(@NotNull Module module) {
        return new LibrariesContainerImpl(module.getProject(), module, null);
    }

    @NotNull
    public static LibrariesContainer createContainer(@NotNull ModifiableRootModel rootModel) {
        Module module = rootModel.getModule();
        return new LibrariesContainerImpl(module.getProject(), module, rootModel);
    }

    public static LibrariesContainer createContainer(StructureConfigurableContext context) {
        return new StructureConfigurableLibrariesContainer(context);
    }

    public static Library createLibrary(@Nullable LibrariesContainer container1, @NotNull LibrariesContainer container2, @NotNull @NonNls NewLibraryEditor editor, @NotNull LibrariesContainer.LibraryLevel level) {
        if (container1 != null && container1.canCreateLibrary(level)) {
            return container1.createLibrary(editor, level);
        }
        return container2.createLibrary(editor, level);
    }

    @NotNull
    private static Library createLibraryInTable(@NotNull NewLibraryEditor editor, LibraryTable table) {
        LibraryTable.ModifiableModel modifiableModel = table.getModifiableModel();
        String name2 = StringUtil.isEmpty((String)editor.getName()) ? null : LibrariesContainerFactory.getUniqueLibraryName(editor.getName(), modifiableModel);
        LibraryType<?> type2 = editor.getType();
        Library library = modifiableModel.createLibrary(name2, type2 == null ? null : type2.getKind());
        LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        editor.applyTo(model);
        model.commit();
        modifiableModel.commit();
        return library;
    }

    private static String getUniqueLibraryName(String baseName, LibraryTable.ModifiableModel model) {
        return UniqueNameGenerator.generateUniqueName((String)baseName, (String)"", (String)"", (String)" (", (String)")", s -> model.getLibraryByName(s) == null);
    }

    @NotNull
    public static LibrariesContainer createContainer(@NotNull WizardContext context, @NotNull ModulesProvider modulesProvider) {
        LibrariesContainer container;
        if (modulesProvider instanceof ModulesConfigurator) {
            ModulesConfigurator configurator = (ModulesConfigurator)modulesProvider;
            container = LibrariesContainerFactory.createContainer(configurator.getContext());
        } else {
            container = LibrariesContainerFactory.createContainer(context.getProject());
        }
        return container;
    }

    private static class StructureConfigurableLibrariesContainer
    extends LibrariesContainerBase {
        private final StructureConfigurableContext myContext;

        StructureConfigurableLibrariesContainer(StructureConfigurableContext context) {
            this.myContext = context;
        }

        @Override
        public Library createLibrary(@NotNull NewLibraryEditor libraryEditor, @NotNull LibrariesContainer.LibraryLevel level) {
            LibraryTableModifiableModelProvider provider = this.getProvider(level);
            if (provider == null) {
                LOG.error("cannot create module library in this context");
            }
            LibraryTable.ModifiableModel model = provider.getModifiableModel();
            LibraryType<?> type2 = libraryEditor.getType();
            Library library = model.createLibrary(LibrariesContainerFactory.getUniqueLibraryName(libraryEditor.getName(), model), type2 == null ? null : type2.getKind());
            ExistingLibraryEditor createdLibraryEditor = ((LibrariesModifiableModel)model).getLibraryEditor(library);
            createdLibraryEditor.setProperties(libraryEditor.getProperties());
            libraryEditor.applyTo(createdLibraryEditor);
            return library;
        }

        @Override
        public ExistingLibraryEditor getLibraryEditor(@NotNull Library library) {
            LibraryTable table = library.getTable();
            if (table == null) {
                return null;
            }
            LibraryTable.ModifiableModel model = this.myContext.getModifiableLibraryTable(table);
            if (model instanceof LibrariesModifiableModel) {
                return ((LibrariesModifiableModel)model).getLibraryEditor(library);
            }
            return null;
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.myContext.getProject();
        }

        @Override
        public Library @NotNull [] getLibraries(@NotNull LibrariesContainer.LibraryLevel libraryLevel) {
            LibraryTableModifiableModelProvider provider = this.getProvider(libraryLevel);
            return provider != null ? provider.getModifiableModel().getLibraries() : EMPTY_LIBRARIES_ARRAY;
        }

        @Nullable
        private LibraryTableModifiableModelProvider getProvider(LibrariesContainer.LibraryLevel libraryLevel) {
            if (libraryLevel == LibrariesContainer.LibraryLevel.PROJECT) {
                return this.myContext.getProjectLibrariesProvider();
            }
            if (libraryLevel == LibrariesContainer.LibraryLevel.GLOBAL) {
                return this.myContext.getGlobalLibrariesProvider();
            }
            return null;
        }

        @Override
        public boolean canCreateLibrary(@NotNull LibrariesContainer.LibraryLevel level) {
            return level == LibrariesContainer.LibraryLevel.GLOBAL || level == LibrariesContainer.LibraryLevel.PROJECT;
        }

        @Override
        public VirtualFile @NotNull [] getLibraryFiles(@NotNull Library library, @NotNull OrderRootType rootType) {
            LibrariesModifiableModel projectLibrariesModel = this.myContext.getProjectLibrariesProvider().getModifiableModel();
            if (projectLibrariesModel.hasLibraryEditor(library)) {
                ExistingLibraryEditor libraryEditor = projectLibrariesModel.getLibraryEditor(library);
                return libraryEditor.getFiles(rootType);
            }
            LibrariesModifiableModel globalLibraries = this.myContext.getGlobalLibrariesProvider().getModifiableModel();
            if (globalLibraries.hasLibraryEditor(library)) {
                ExistingLibraryEditor libraryEditor = globalLibraries.getLibraryEditor(library);
                return libraryEditor.getFiles(rootType);
            }
            return library.getFiles(rootType);
        }
    }

    private static class LibrariesContainerImpl
    extends LibrariesContainerBase {
        @Nullable
        private final Project myProject;
        @Nullable
        private final Module myModule;
        @Nullable
        private final ModifiableRootModel myRootModel;

        private LibrariesContainerImpl(@Nullable Project project, @Nullable Module module, @Nullable ModifiableRootModel rootModel) {
            this.myProject = project;
            this.myModule = module;
            this.myRootModel = rootModel;
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @Override
        public Library @NotNull [] getLibraries(@NotNull LibrariesContainer.LibraryLevel libraryLevel) {
            if (libraryLevel == LibrariesContainer.LibraryLevel.MODULE && this.myModule != null) {
                return this.getModuleLibraries();
            }
            LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
            if (libraryLevel == LibrariesContainer.LibraryLevel.GLOBAL) {
                return registrar.getLibraryTable().getLibraries();
            }
            if (libraryLevel == LibrariesContainer.LibraryLevel.PROJECT && this.myProject != null) {
                return registrar.getLibraryTable(this.myProject).getLibraries();
            }
            return EMPTY_LIBRARIES_ARRAY;
        }

        private Library[] getModuleLibraries() {
            if (this.myRootModel != null) {
                return this.myRootModel.getModuleLibraryTable().getLibraries();
            }
            List libraries2 = OrderEntryUtil.getModuleLibraries((ModuleRootModel)ModuleRootManager.getInstance((Module)this.myModule));
            return libraries2.toArray(Library.EMPTY_ARRAY);
        }

        @Override
        public VirtualFile @NotNull [] getLibraryFiles(@NotNull Library library, @NotNull OrderRootType rootType) {
            return library.getFiles(rootType);
        }

        @Override
        public boolean canCreateLibrary(@NotNull LibrariesContainer.LibraryLevel level) {
            if (level == LibrariesContainer.LibraryLevel.MODULE) {
                return this.myRootModel != null;
            }
            return level == LibrariesContainer.LibraryLevel.GLOBAL || this.myProject != null;
        }

        @Override
        public Library createLibrary(@NotNull NewLibraryEditor libraryEditor, @NotNull LibrariesContainer.LibraryLevel level) {
            LibraryTable table;
            if (level == LibrariesContainer.LibraryLevel.MODULE && this.myRootModel != null) {
                return LibrariesContainerFactory.createLibraryInTable(libraryEditor, this.myRootModel.getModuleLibraryTable());
            }
            LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
            if (level == LibrariesContainer.LibraryLevel.GLOBAL) {
                table = registrar.getLibraryTable();
            } else if (level == LibrariesContainer.LibraryLevel.PROJECT && this.myProject != null) {
                table = registrar.getLibraryTable(this.myProject);
            } else {
                return null;
            }
            return LibrariesContainerFactory.createLibraryInTable(libraryEditor, table);
        }

        @Override
        public ExistingLibraryEditor getLibraryEditor(@NotNull Library library) {
            return null;
        }
    }

    private static abstract class LibrariesContainerBase
    implements LibrariesContainer {
        private UniqueNameGenerator myNameGenerator;

        private LibrariesContainerBase() {
        }

        @Override
        public Library createLibrary(@NotNull @NonNls String name2, @NotNull LibrariesContainer.LibraryLevel level, VirtualFile @NotNull [] classRoots, VirtualFile @NotNull [] sourceRoots) {
            NewLibraryEditor editor = new NewLibraryEditor();
            editor.setName(name2);
            for (VirtualFile classRoot : classRoots) {
                editor.addRoot(classRoot, OrderRootType.CLASSES);
            }
            for (VirtualFile sourceRoot : sourceRoots) {
                editor.addRoot(sourceRoot, OrderRootType.SOURCES);
            }
            return this.createLibrary(editor, level);
        }

        @Override
        public Library createLibrary(@NotNull @NonNls String name2, @NotNull LibrariesContainer.LibraryLevel level, @NotNull Collection<? extends OrderRoot> roots) {
            NewLibraryEditor editor = new NewLibraryEditor();
            editor.setName(name2);
            editor.addRoots(roots);
            return this.createLibrary(editor, level);
        }

        @Override
        public Library @NotNull [] getAllLibraries() {
            Object[] moduleLibraries;
            Object[] libraries2 = this.getLibraries(LibrariesContainer.LibraryLevel.GLOBAL);
            Object[] projectLibraries = this.getLibraries(LibrariesContainer.LibraryLevel.PROJECT);
            if (projectLibraries.length > 0) {
                libraries2 = (Library[])ArrayUtil.mergeArrays((Object[])libraries2, (Object[])projectLibraries);
            }
            if ((moduleLibraries = this.getLibraries(LibrariesContainer.LibraryLevel.MODULE)).length > 0) {
                libraries2 = (Library[])ArrayUtil.mergeArrays((Object[])libraries2, (Object[])moduleLibraries);
            }
            return libraries2;
        }

        @Override
        @NotNull
        public List<LibrariesContainer.LibraryLevel> getAvailableLevels() {
            ArrayList<LibrariesContainer.LibraryLevel> levels = new ArrayList<LibrariesContainer.LibraryLevel>();
            for (LibrariesContainer.LibraryLevel level : LibrariesContainer.LibraryLevel.values()) {
                if (!this.canCreateLibrary(level)) continue;
                levels.add(level);
            }
            return levels;
        }

        @Override
        @NotNull
        public String suggestUniqueLibraryName(@NotNull String baseName) {
            if (this.myNameGenerator == null) {
                this.myNameGenerator = new UniqueNameGenerator(Arrays.asList(this.getAllLibraries()), o -> o.getName());
            }
            return this.myNameGenerator.generateUniqueName(baseName, "", "", " (", ")");
        }
    }
}

