/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.util.IconUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkListConfigurable
extends BaseStructureConfigurable {
    @NotNull
    private final ProjectSdksModel myJdksTreeModel;
    private final SdkModel.Listener myListener = new SdkModel.Listener(){

        public void sdkAdded(@NotNull Sdk sdk) {
            JdkListConfigurable.this.addJdkNode(sdk, true);
        }

        public void sdkChanged(@NotNull Sdk sdk, String previousName) {
            this.updateName();
        }

        public void sdkHomeSelected(@NotNull Sdk sdk, @NotNull String newSdkHome) {
            this.updateName();
        }

        private void updateName() {
            NamedConfigurable configurable;
            TreePath path = JdkListConfigurable.this.myTree.getSelectionPath();
            if (path != null && (configurable = ((MasterDetailsComponent.MyNode)path.getLastPathComponent()).getConfigurable()) instanceof JdkConfigurable) {
                configurable.updateName();
            }
        }
    };

    public JdkListConfigurable(@NotNull Project project) {
        super(project);
        this.myJdksTreeModel = ProjectStructureConfigurable.getInstance(project).getProjectJdksModel();
    }

    protected String getComponentStateKey() {
        return "JdkListConfigurable.UI";
    }

    @Nls
    public String getDisplayName() {
        return JavaUiBundle.message("configurable.JdkListConfigurable.display.name", new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return this.myCurrentConfigurable != null ? this.myCurrentConfigurable.getHelpTopic() : "reference.settingsdialog.project.structure.jdk";
    }

    @NotNull
    @NonNls
    public String getId() {
        return "jdk.list";
    }

    @Override
    protected void loadTree() {
        HashMap sdks = this.myJdksTreeModel.getProjectSdks();
        for (Sdk sdk : sdks.keySet()) {
            JdkConfigurable configurable = new JdkConfigurable((ProjectJdkImpl)sdks.get(sdk), this.myJdksTreeModel, this.TREE_UPDATER, this.myHistory, this.myProject);
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)configurable), this.myRoot);
        }
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<SdkProjectStructureElement> result = new ArrayList<SdkProjectStructureElement>();
        for (Sdk sdk : this.myJdksTreeModel.getProjectSdks().values()) {
            result.add(new SdkProjectStructureElement(this.myContext, sdk));
        }
        return result;
    }

    public boolean addJdkNode(Sdk jdk, boolean selectInTree) {
        if (!this.myUiDisposed) {
            this.myContext.getDaemonAnalyzer().queueUpdate(new SdkProjectStructureElement(this.myContext, jdk));
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)new JdkConfigurable((ProjectJdkImpl)jdk, this.myJdksTreeModel, this.TREE_UPDATER, this.myHistory, this.myProject)), this.myRoot);
            if (selectInTree) {
                this.selectNodeInTree((DefaultMutableTreeNode)MasterDetailsComponent.findNodeByObject((TreeNode)this.myRoot, (Object)jdk));
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        this.myJdksTreeModel.removeListener(this.myListener);
        this.myJdksTreeModel.disposeUIResources();
    }

    @NotNull
    public ProjectSdksModel getJdksTreeModel() {
        return this.myJdksTreeModel;
    }

    @Override
    public void reset() {
        super.reset();
        this.myJdksTreeModel.addListener(this.myListener);
        this.myTree.setRootVisible(false);
    }

    public void apply() throws ConfigurationException {
        boolean modifiedJdks = false;
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            NamedConfigurable configurable = ((MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i)).getConfigurable();
            if (!configurable.isModified()) continue;
            configurable.apply();
            modifiedJdks = true;
        }
        if (this.myJdksTreeModel.isModified() || modifiedJdks) {
            this.myJdksTreeModel.apply((MasterDetailsComponent)this);
        }
        this.myJdksTreeModel.setProjectSdk(ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk());
    }

    public boolean isModified() {
        return super.isModified() || this.myJdksTreeModel.isModified();
    }

    public static JdkListConfigurable getInstance(Project project) {
        return (JdkListConfigurable)((Object)ServiceManager.getService((Project)project, JdkListConfigurable.class));
    }

    @Override
    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        List defaultActions = super.createActions(fromPopup);
        AddSdkAction addNewAction = new AddSdkAction();
        ((ArrayList)defaultActions).add(0, addNewAction);
        return defaultActions;
    }

    @Override
    public BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return null;
    }

    @Override
    protected List<? extends RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.singletonList(new SdkRemoveHandler());
    }

    @Nullable
    protected String getEmptySelectionString() {
        return "Select an SDK to view or edit its details here";
    }

    private class AddSdkAction
    extends AnAction
    implements DumbAware {
        AddSdkAction() {
            super(JavaUiBundle.message("add.new.jdk.text", new Object[0]), null, IconUtil.getAddIcon());
            BaseStructureConfigurable.AbstractAddGroup replacedAction = new BaseStructureConfigurable.AbstractAddGroup(JavaUiBundle.message("action.name.text", new Object[0])){

                public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                    return AnAction.EMPTY_ARRAY;
                }
            };
            this.setShortcutSet(replacedAction.getShortcutSet());
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            SdkPopupFactory.newBuilder().withProject(JdkListConfigurable.this.myProject).withProjectSdksModel(JdkListConfigurable.this.getJdksTreeModel()).withSdkTypeFilter(SimpleJavaSdkType.notSimpleJavaSdkType()).withSdkFilter(sdk -> false).buildPopup().showPopup(e);
        }
    }

    private class SdkRemoveHandler
    extends RemoveConfigurableHandler<Sdk> {
        SdkRemoveHandler() {
            super(JdkConfigurable.class);
        }

        @Override
        public boolean remove(@NotNull Collection<? extends Sdk> sdks) {
            for (Sdk sdk : sdks) {
                JdkListConfigurable.this.myJdksTreeModel.removeSdk(sdk);
                JdkListConfigurable.this.myContext.getDaemonAnalyzer().removeElement(new SdkProjectStructureElement(JdkListConfigurable.this.myContext, sdk));
            }
            return true;
        }
    }
}

