/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.JavaUiBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.sun.jna.platform.mac.XAttrUtil;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class JavadocQuarantineStatusCleaner {
    private static final Logger LOG = Logger.getInstance(JavadocQuarantineStatusCleaner.class);
    private static final String QUARANTINE_ATTRIBUTE = "com.apple.quarantine";

    public static void cleanIfNeeded(VirtualFile ... docFolders) {
        if (docFolders.length > 0 && SystemInfo.isMac) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                List quarantined = Stream.of(docFolders).filter(f -> f.isInLocalFileSystem() && f.isDirectory() && XAttrUtil.getXAttr((String)f.getPath(), (String)QUARANTINE_ATTRIBUTE) != null).map(VirtualFile::getPath).collect(Collectors.toList());
                if (!quarantined.isEmpty()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        String title = JavaUiBundle.message("quarantine.cleaner", new Object[0]);
                        String message2 = JavaUiBundle.message("quarantine.dialog.message", StringUtil.join((Collection)quarantined, (String)"\n"));
                        if (Messages.showYesNoDialog((String)message2, (String)title, null) == 0) {
                            JavadocQuarantineStatusCleaner.cleanQuarantineStatusInBackground(quarantined);
                        }
                    }, ModalityState.any());
                }
            });
        }
    }

    private static void cleanQuarantineStatusInBackground(final List<String> paths) {
        new Task.Backgroundable(null, JavaUiBundle.message("quarantine.clean.progress", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                for (String path : paths) {
                    indicator.checkCanceled();
                    indicator.setText2(path);
                    try {
                        Stream<Path> s = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);
                        Throwable throwable = null;
                        try {
                            s.forEach(p -> {
                                indicator.checkCanceled();
                                XAttrUtil.removeXAttr((String)p.toFile().getAbsolutePath(), (String)JavadocQuarantineStatusCleaner.QUARANTINE_ATTRIBUTE);
                            });
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (s == null) continue;
                            if (throwable != null) {
                                try {
                                    s.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            s.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public void onThrowable(@NotNull Throwable error) {
                LOG.warn(error);
                String title = JavaUiBundle.message("quarantine.cleaner", new Object[0]);
                String message2 = JavaUiBundle.message("quarantine.error.message", error.getMessage());
                new Notification(NotificationGroup.createIdWithTitle((String)"Quarantine Cleaner", (String)title), title, message2, NotificationType.WARNING).notify(null);
            }
        }.queue();
    }
}

