/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.actions;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeComponent;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class InlineArtifactAction
extends DumbAwareAction {
    private final ArtifactEditorEx myEditor;

    public InlineArtifactAction(ArtifactEditorEx editor) {
        super(JavaUiBundle.message("action.name.inline.artifact", new Object[0]));
        this.myEditor = editor;
    }

    public void update(@NotNull AnActionEvent e) {
        LayoutTreeSelection selection = this.myEditor.getLayoutTreeComponent().getSelection();
        PackagingElementNode<?> node = selection.getNodeIfSingle();
        PackagingElement<?> element = selection.getElementIfSingle();
        e.getPresentation().setEnabled(element instanceof ArtifactPackagingElement && node != null && node.getParentElement(element) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        LayoutTreeComponent treeComponent = this.myEditor.getLayoutTreeComponent();
        LayoutTreeSelection selection = treeComponent.getSelection();
        PackagingElement<?> element = selection.getElementIfSingle();
        PackagingElementNode<?> node = selection.getNodeIfSingle();
        if (node == null || !(element instanceof ArtifactPackagingElement)) {
            return;
        }
        CompositePackagingElement<?> parent = node.getParentElement(element);
        CompositePackagingElementNode parentNode = node.getParentNode();
        if (parent == null || parentNode == null) {
            return;
        }
        if (!treeComponent.checkCanModifyChildren((PackagingElement<?>)parent, parentNode, (Collection<? extends PackagingElementNode<?>>)Collections.singletonList(node))) {
            return;
        }
        treeComponent.editLayout(() -> {
            parent.removeChild(element);
            ArtifactEditorContext context = this.myEditor.getContext();
            Artifact artifact = ((ArtifactPackagingElement)element).findArtifact((PackagingElementResolvingContext)context);
            if (artifact != null) {
                CompositePackagingElement rootElement = artifact.getRootElement();
                if (rootElement instanceof ArtifactRootElement) {
                    for (PackagingElement child : rootElement.getChildren()) {
                        parent.addOrFindChild(ArtifactUtil.copyWithChildren(child, context.getProject()));
                    }
                } else {
                    parent.addOrFindChild(ArtifactUtil.copyWithChildren(rootElement, context.getProject()));
                }
            }
        });
        treeComponent.rebuildTree();
    }
}

