/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArtifactEditorSettings
implements PersistentStateComponent<ArtifactEditorSettingsState> {
    private boolean mySortElements = true;
    private final List<ComplexPackagingElementType<?>> myTypesToShowContent = new ArrayList();

    public ArtifactEditorSettings() {
    }

    public ArtifactEditorSettings(boolean sortElements, Collection<? extends ComplexPackagingElementType<?>> typesToShowContent) {
        this.mySortElements = sortElements;
        this.myTypesToShowContent.addAll(typesToShowContent);
    }

    public ArtifactEditorSettingsState getState() {
        ArtifactEditorSettingsState state = new ArtifactEditorSettingsState();
        state.mySortElements = this.mySortElements;
        for (ComplexPackagingElementType<?> type2 : this.myTypesToShowContent) {
            state.myTypesToShowContentIds.add(type2.getId());
        }
        return state;
    }

    public void loadState(@NotNull ArtifactEditorSettingsState state) {
        this.mySortElements = state.mySortElements;
        this.myTypesToShowContent.clear();
        for (String id : state.myTypesToShowContentIds) {
            PackagingElementType type2 = PackagingElementFactory.getInstance().findElementType(id);
            if (!(type2 instanceof ComplexPackagingElementType)) continue;
            this.myTypesToShowContent.add((ComplexPackagingElementType)type2);
        }
    }

    public boolean isSortElements() {
        return this.mySortElements;
    }

    public List<ComplexPackagingElementType<?>> getTypesToShowContent() {
        return this.myTypesToShowContent;
    }

    public void setSortElements(boolean sortElements) {
        this.mySortElements = sortElements;
    }

    public void setTypesToShowContent(Collection<? extends ComplexPackagingElementType<?>> typesToShowContent) {
        this.myTypesToShowContent.clear();
        this.myTypesToShowContent.addAll(typesToShowContent);
    }

    @Tag(value="artifact-editor")
    public static class ArtifactEditorSettingsState {
        @Tag(value="show-sorted")
        public boolean mySortElements = true;
        @XCollection(elementName="type", valueAttributeName="id", propertyElementName="show-content")
        public List<String> myTypesToShowContentIds = new ArrayList<String>();
    }
}

