/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.facet.Facet;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.ManifestFileProvider;
import com.intellij.packaging.impl.ui.ChooseArtifactsDialog;
import com.intellij.packaging.ui.ArtifactEditor;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import com.intellij.util.ui.classpath.ChooseLibrariesFromTablesDialog;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArtifactEditorContextImpl
implements ArtifactEditorContext {
    private final ArtifactsStructureConfigurableContext myParent;
    private final ArtifactEditorEx myEditor;

    public ArtifactEditorContextImpl(ArtifactsStructureConfigurableContext parent, ArtifactEditorEx editor) {
        this.myParent = parent;
        this.myEditor = editor;
    }

    @NotNull
    public ModifiableArtifactModel getOrCreateModifiableArtifactModel() {
        return this.myParent.getOrCreateModifiableArtifactModel();
    }

    public ModifiableModuleModel getModifiableModuleModel() {
        return this.myParent.getModifiableModuleModel();
    }

    @NotNull
    public ModifiableRootModel getOrCreateModifiableRootModel(@NotNull Module module) {
        return this.myParent.getOrCreateModifiableRootModel(module);
    }

    public ManifestFileConfiguration getManifestFile(CompositePackagingElement<?> element, ArtifactType artifactType) {
        return this.myParent.getManifestFile(element, artifactType);
    }

    @NotNull
    public Project getProject() {
        return this.myParent.getProject();
    }

    public CompositePackagingElement<?> getRootElement(@NotNull Artifact artifact) {
        return this.myParent.getRootElement(artifact);
    }

    public void editLayout(@NotNull Artifact artifact, Runnable runnable) {
        this.myParent.editLayout(artifact, runnable);
    }

    public ArtifactEditor getOrCreateEditor(Artifact artifact) {
        return this.myParent.getOrCreateEditor(artifact);
    }

    public ArtifactEditor getThisArtifactEditor() {
        return this.myEditor;
    }

    public void selectArtifact(@NotNull Artifact artifact) {
        ProjectStructureConfigurable.getInstance(this.getProject()).select(artifact, true);
    }

    public void selectFacet(@NotNull Facet<?> facet) {
        ProjectStructureConfigurable.getInstance(this.getProject()).select(facet, true);
    }

    public void selectModule(@NotNull Module module) {
        ProjectStructureConfigurable.getInstance(this.getProject()).select(module.getName(), null, true);
    }

    public void selectLibrary(@NotNull Library library) {
        LibraryTable table = library.getTable();
        if (table != null) {
            ProjectStructureConfigurable.getInstance(this.getProject()).selectProjectOrGlobalLibrary(library, true);
        } else {
            Module module = ((LibraryEx)library).getModule();
            if (module != null) {
                ModuleRootModel rootModel = this.myParent.getModulesProvider().getRootModel(module);
                String libraryName = library.getName();
                for (OrderEntry entry : rootModel.getOrderEntries()) {
                    if (!(entry instanceof LibraryOrderEntry) || !OrderEntryUtil.isModuleLibraryOrderEntry((OrderEntry)entry)) continue;
                    LibraryOrderEntry libraryEntry = (LibraryOrderEntry)entry;
                    if ((libraryName == null || !libraryName.equals(libraryEntry.getLibraryName())) && (libraryName != null || !library.equals(libraryEntry.getLibrary()))) continue;
                    ProjectStructureConfigurable.getInstance(this.getProject()).selectOrderEntry(module, (OrderEntry)libraryEntry);
                    return;
                }
            }
        }
    }

    public List<Artifact> chooseArtifacts(List<? extends Artifact> artifacts, String title) {
        ChooseArtifactsDialog dialog = new ChooseArtifactsDialog(this.getProject(), artifacts, title, null);
        return dialog.showAndGet() ? dialog.getChosenElements() : Collections.emptyList();
    }

    @NotNull
    public ArtifactModel getArtifactModel() {
        return this.myParent.getArtifactModel();
    }

    @NotNull
    public ModulesProvider getModulesProvider() {
        return this.myParent.getModulesProvider();
    }

    @NotNull
    public FacetsProvider getFacetsProvider() {
        return this.myParent.getFacetsProvider();
    }

    public Library findLibrary(@NotNull String level, @NotNull String libraryName) {
        return this.myParent.findLibrary(level, libraryName);
    }

    @NotNull
    public ManifestFileProvider getManifestFileProvider() {
        return this.myParent.getManifestFileProvider();
    }

    public void queueValidation() {
        this.myParent.queueValidation(this.getArtifact());
    }

    @NotNull
    public ArtifactType getArtifactType() {
        return this.myEditor.getArtifact().getArtifactType();
    }

    public List<Module> chooseModules(List<? extends Module> modules, String title) {
        return new ChooseModulesDialog(this.getProject(), modules, title, null).showAndGetResult();
    }

    public List<Library> chooseLibraries(String title) {
        ChooseLibrariesFromTablesDialog dialog = ChooseLibrariesFromTablesDialog.createDialog(title, this.getProject(), false);
        return dialog.showAndGet() ? dialog.getSelectedLibraries() : Collections.emptyList();
    }

    public Artifact getArtifact() {
        return this.myEditor.getArtifact();
    }

    public ArtifactsStructureConfigurableContext getParent() {
        return this.myParent;
    }
}

