/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkConfigurable
implements UnnamedConfigurable {
    private static final Logger LOG = Logger.getInstance(ProjectJdkConfigurable.class);
    private JdkComboBox myCbProjectJdk;
    private JPanel myJdkPanel;
    private final Project myProject;
    private final ProjectSdksModel myJdksModel;
    private final SdkModel.Listener myListener = new SdkModel.Listener(){

        public void sdkAdded(@NotNull Sdk sdk) {
            ProjectJdkConfigurable.this.reloadModel();
        }

        public void beforeSdkRemove(@NotNull Sdk sdk) {
            ProjectJdkConfigurable.this.reloadModel();
        }

        public void sdkChanged(@NotNull Sdk sdk, String previousName) {
            ProjectJdkConfigurable.this.reloadModel();
        }

        public void sdkHomeSelected(@NotNull Sdk sdk, @NotNull String newSdkHome) {
            ProjectJdkConfigurable.this.reloadModel();
        }
    };
    private boolean myFreeze = false;

    public ProjectJdkConfigurable(Project project, ProjectSdksModel jdksModel) {
        this.myProject = project;
        this.myJdksModel = jdksModel;
        this.myJdksModel.addListener(this.myListener);
    }

    @Nullable
    public Sdk getSelectedProjectJdk() {
        return this.myCbProjectJdk != null ? this.myJdksModel.findSdk(this.myCbProjectJdk.getSelectedJdk()) : null;
    }

    @NotNull
    public JComponent createComponent() {
        if (this.myJdkPanel == null) {
            this.myJdkPanel = new JPanel(new GridBagLayout());
            this.myCbProjectJdk = new JdkComboBox(this.myProject, this.myJdksModel, (Condition<? super SdkTypeId>)SimpleJavaSdkType.notSimpleJavaSdkType(), null, null, null);
            this.myCbProjectJdk.showNoneSdkItem();
            this.myCbProjectJdk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ProjectJdkConfigurable.this.myFreeze) {
                        return;
                    }
                    ProjectJdkConfigurable.this.myJdksModel.setProjectSdk(ProjectJdkConfigurable.this.myCbProjectJdk.getSelectedJdk());
                    ProjectJdkConfigurable.this.clearCaches();
                }
            });
            String accessibleName = StringUtil.removeHtmlTags((String)JavaUiBundle.message("module.libraries.target.jdk.project.radio.name", new Object[0]));
            String accessibleDescription = StringUtil.removeHtmlTags((String)JavaUiBundle.message("module.libraries.target.jdk.project.radio.description", new Object[0]));
            this.myCbProjectJdk.getAccessibleContext().setAccessibleName(accessibleName);
            this.myCbProjectJdk.getAccessibleContext().setAccessibleDescription(accessibleDescription);
            String labelString = String.format("<html>%s<br>%s</html>", JavaUiBundle.message("module.libraries.target.jdk.project.radio.name", new Object[0]), JavaUiBundle.message("module.libraries.target.jdk.project.radio.description", new Object[0]));
            this.myJdkPanel.add((Component)new JLabel(labelString), new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insetsBottom((int)4), 0, 0));
            this.myJdkPanel.add((Component)((Object)this.myCbProjectJdk), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, (Insets)JBUI.insetsLeft((int)4), 0, 0));
            JButton editButton = new JButton(ApplicationBundle.message((String)"button.edit", (Object[])new Object[0]));
            this.myCbProjectJdk.setEditButton(editButton, this.myProject, () -> this.myJdksModel.getProjectSdk());
            this.myJdkPanel.add((Component)editButton, new GridBagConstraints(-1, 1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsLeft((int)4), 0, 0));
        }
        return this.myJdkPanel;
    }

    private void reloadModel() {
        this.myFreeze = true;
        Sdk projectJdk = this.myJdksModel.getProjectSdk();
        if (this.myCbProjectJdk != null) {
            String sdkName;
            this.myCbProjectJdk.reloadModel();
            String string = sdkName = projectJdk == null ? ProjectRootManager.getInstance((Project)this.myProject).getProjectSdkName() : projectJdk.getName();
            if (sdkName != null) {
                Sdk jdk = this.myJdksModel.findSdk(sdkName);
                if (jdk != null) {
                    this.myCbProjectJdk.setSelectedJdk(jdk);
                } else {
                    this.myCbProjectJdk.setInvalidJdk(sdkName);
                    this.clearCaches();
                }
            } else {
                this.myCbProjectJdk.setSelectedJdk(null);
            }
        } else {
            LOG.error("'createComponent' wasn't called before 'reset' for " + this.toString());
        }
        this.myFreeze = false;
    }

    private void clearCaches() {
        Module[] modules;
        ModuleStructureConfigurable rootConfigurable = ModuleStructureConfigurable.getInstance(this.myProject);
        for (Module module : modules = rootConfigurable.getModules()) {
            StructureConfigurableContext context = rootConfigurable.getContext();
            context.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(context, module));
        }
    }

    public boolean isModified() {
        Sdk projectJdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        return !Comparing.equal((Object)projectJdk, (Object)this.getSelectedProjectJdk());
    }

    public void apply() {
        ProjectRootManager.getInstance((Project)this.myProject).setProjectSdk(this.getSelectedProjectJdk());
    }

    public void reset() {
        this.reloadModel();
        if (this.myCbProjectJdk != null) {
            String sdkName = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdkName();
            if (sdkName != null) {
                Sdk jdk = this.myJdksModel.findSdk(sdkName);
                if (jdk != null) {
                    this.myCbProjectJdk.setSelectedJdk(jdk);
                } else {
                    this.myCbProjectJdk.setInvalidJdk(sdkName);
                }
            } else {
                this.myCbProjectJdk.setSelectedJdk(null);
            }
        }
    }

    public void disposeUIResources() {
        this.myJdksModel.removeListener(this.myListener);
        this.myJdkPanel = null;
        this.myCbProjectJdk = null;
    }

    void addChangeListener(ActionListener listener) {
        this.myCbProjectJdk.addActionListener(listener);
    }
}

