/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.facet.impl.ui.FacetEditorImpl;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.projectWizard.NewProjectWizard;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.ui.configuration.HeaderHidingTabbedModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesConfigurator
implements ModulesProvider,
ModuleEditor.ChangeListener {
    private static final Logger LOG = Logger.getInstance(ModulesConfigurator.class);
    private final Project myProject;
    private final Map<Module, ModuleEditor> myModuleEditors = new TreeMap<Module, ModuleEditor>((o1, o2) -> {
        String n2;
        String n1 = o1.getName();
        int result = n1.compareToIgnoreCase(n2 = o2.getName());
        if (result != 0) {
            return result;
        }
        return n1.compareTo(n2);
    });
    private boolean myModified = false;
    private ModifiableModuleModel myModuleModel;
    private boolean myModuleModelCommitted = false;
    private ProjectFacetsConfigurator myFacetsConfigurator;
    private StructureConfigurableContext myContext;
    private final List<ModuleEditor.ChangeListener> myAllModulesChangeListeners = new ArrayList<ModuleEditor.ChangeListener>();

    public ModulesConfigurator(Project project) {
        this.myProject = project;
        this.myModuleModel = ModuleManager.getInstance((Project)this.myProject).getModifiableModel();
    }

    public void setContext(StructureConfigurableContext context) {
        this.myContext = context;
        this.myFacetsConfigurator = this.createFacetsConfigurator();
    }

    public ProjectFacetsConfigurator getFacetsConfigurator() {
        return this.myFacetsConfigurator;
    }

    public void disposeUIResources() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
                Disposer.dispose((Disposable)moduleEditor);
            }
            this.myModuleEditors.clear();
            this.myModuleModel.dispose();
            if (this.myFacetsConfigurator != null) {
                this.myFacetsConfigurator.disposeEditors();
            }
        });
    }

    public Module @NotNull [] getModules() {
        return this.myModuleModel.getModules();
    }

    @Nullable
    public Module getModule(@NotNull String name2) {
        Module moduleByName = this.myModuleModel.findModuleByName(name2);
        if (moduleByName != null) {
            return moduleByName;
        }
        return this.myModuleModel.getModuleToBeRenamed(name2);
    }

    @Nullable
    public ModuleEditor getModuleEditor(Module module) {
        return this.myModuleEditors.get(module);
    }

    public ModuleRootModel getRootModel(@NotNull Module module) {
        return this.getOrCreateModuleEditor(module).getRootModel();
    }

    @NotNull
    public ModuleEditor getOrCreateModuleEditor(@NotNull Module module) {
        LOG.assertTrue(this.getModule(module.getName()) != null, (Object)"Module has been deleted");
        ModuleEditor editor = this.getModuleEditor(module);
        if (editor == null) {
            editor = this.doCreateModuleEditor(module);
        }
        return editor;
    }

    @NotNull
    private ModuleEditor doCreateModuleEditor(@NotNull Module module) {
        final HeaderHidingTabbedModuleEditor moduleEditor = new HeaderHidingTabbedModuleEditor(this.myProject, this, module){

            @Override
            public ProjectFacetsConfigurator getFacetsConfigurator() {
                return ModulesConfigurator.this.myFacetsConfigurator;
            }
        };
        this.myModuleEditors.put(moduleEditor.getModule(), moduleEditor);
        moduleEditor.addChangeListener(this);
        Disposer.register((Disposable)moduleEditor, (Disposable)new Disposable(){

            public void dispose() {
                moduleEditor.removeChangeListener(ModulesConfigurator.this);
            }
        });
        return moduleEditor;
    }

    @NotNull
    public FacetModel getFacetModel(@NotNull Module module) {
        return this.myFacetsConfigurator.getOrCreateModifiableModel(module);
    }

    public void resetModuleEditors() {
        this.myModuleModel = ModuleManager.getInstance((Project)this.myProject).getModifiableModel();
        ApplicationManager.getApplication().runWriteAction(() -> {
            Module[] modules;
            if (!this.myModuleEditors.isEmpty()) {
                LOG.error("module editors was not disposed");
                this.myModuleEditors.clear();
            }
            if ((modules = this.myModuleModel.getModules()).length > 0) {
                for (Module module : modules) {
                    this.getOrCreateModuleEditor(module);
                }
            }
        });
        this.myFacetsConfigurator.resetEditors();
        this.myModified = false;
    }

    @Override
    public void moduleStateChanged(ModifiableRootModel moduleRootModel) {
        for (ModuleEditor.ChangeListener listener : this.myAllModulesChangeListeners) {
            listener.moduleStateChanged(moduleRootModel);
        }
        this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, moduleRootModel.getModule()));
    }

    public void addAllModuleChangeListener(ModuleEditor.ChangeListener listener) {
        this.myAllModulesChangeListeners.add(listener);
    }

    public void apply() throws ConfigurationException {
        HashMap<VirtualFile, String> contentRootToModuleNameMap = new HashMap<VirtualFile, String>();
        HashMap<VirtualFile, VirtualFile> srcRootsToContentRootMap = new HashMap<VirtualFile, VirtualFile>();
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            ModuleRootModel rootModel = moduleEditor.getRootModel();
            ContentEntry[] contentEntryArray = rootModel.getContentEntries();
            String moduleName = moduleEditor.getName();
            HashSet<VirtualFile> sourceRoots = new HashSet<VirtualFile>();
            for (ContentEntry content : contentEntryArray) {
                for (VirtualFile root : content.getSourceFolderFiles()) {
                    if (sourceRoots.add(root)) continue;
                    throw new ConfigurationException(JavaUiBundle.message("module.paths.validation.duplicate.source.root.in.same.module.error", root.getPresentableUrl(), moduleName));
                }
            }
            for (ContentEntry contentEntry : contentEntryArray) {
                VirtualFile contentRoot = contentEntry.getFile();
                if (contentRoot == null) continue;
                String previousName = contentRootToModuleNameMap.put(contentRoot, moduleName);
                if (previousName != null && !previousName.equals(moduleName)) {
                    throw new ConfigurationException(JavaUiBundle.message("module.paths.validation.duplicate.content.error", contentRoot.getPresentableUrl(), previousName, moduleName));
                }
                for (VirtualFile srcRoot : contentEntry.getSourceFolderFiles()) {
                    String correctModule;
                    String problematicModule;
                    VirtualFile anotherContentRoot = srcRootsToContentRootMap.put(srcRoot, contentRoot);
                    if (anotherContentRoot == null) continue;
                    if (VfsUtilCore.isAncestor((VirtualFile)anotherContentRoot, (VirtualFile)contentRoot, (boolean)true)) {
                        problematicModule = (String)contentRootToModuleNameMap.get(anotherContentRoot);
                        correctModule = (String)contentRootToModuleNameMap.get(contentRoot);
                    } else {
                        problematicModule = (String)contentRootToModuleNameMap.get(contentRoot);
                        correctModule = (String)contentRootToModuleNameMap.get(anotherContentRoot);
                    }
                    throw new ConfigurationException(JavaUiBundle.message("module.paths.validation.duplicate.source.root.error", problematicModule, srcRoot.getPresentableUrl(), correctModule));
                }
            }
        }
        for (Map.Entry entry : srcRootsToContentRootMap.entrySet()) {
            VirtualFile srcRoot = (VirtualFile)entry.getKey();
            VirtualFile virtualFile = (VirtualFile)entry.getValue();
            String expectedModuleName = (String)contentRootToModuleNameMap.get(virtualFile);
            for (VirtualFile candidateContent = srcRoot; candidateContent != null && !candidateContent.equals(virtualFile); candidateContent = candidateContent.getParent()) {
                String moduleName = (String)contentRootToModuleNameMap.get(candidateContent);
                if (moduleName == null || moduleName.equals(expectedModuleName)) continue;
                throw new ConfigurationException(JavaUiBundle.message("module.paths.validation.source.root.belongs.to.another.module.error", srcRoot.getPresentableUrl(), expectedModuleName, moduleName));
            }
        }
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            moduleEditor.canApply();
        }
        THashMap modifiedToOriginalMap = new THashMap();
        ProjectSdksModel projectSdksModel = ProjectStructureConfigurable.getInstance(this.myProject).getProjectJdksModel();
        for (Map.Entry entry : projectSdksModel.getProjectSdks().entrySet()) {
            modifiedToOriginalMap.put(entry.getValue(), entry.getKey());
        }
        Ref exceptionRef = Ref.create();
        ApplicationManager.getApplication().runWriteAction(() -> this.lambda$apply$3((Map)modifiedToOriginalMap, exceptionRef));
        if (!exceptionRef.isNull()) {
            throw (ConfigurationException)((Object)exceptionRef.get());
        }
        this.myModified = false;
    }

    private ProjectFacetsConfigurator createFacetsConfigurator() {
        return new ProjectFacetsConfigurator(this.myContext, this.myFacetsConfigurator);
    }

    public void setModified(boolean modified) {
        this.myModified = modified;
    }

    public ModifiableModuleModel getModuleModel() {
        return this.myModuleModel;
    }

    public boolean isModuleModelCommitted() {
        return this.myModuleModelCommitted;
    }

    public List<Module> deleteModules(Collection<? extends Module> modules) {
        ArrayList<Module> deleted = new ArrayList<Module>();
        ArrayList<ModuleEditor> moduleEditors = new ArrayList<ModuleEditor>();
        for (Module module : modules) {
            ModuleEditor moduleEditor = this.getModuleEditor(module);
            if (moduleEditor == null) continue;
            deleted.add(module);
            moduleEditors.add(moduleEditor);
        }
        if (this.doRemoveModules(moduleEditors)) {
            return deleted;
        }
        return Collections.emptyList();
    }

    @Nullable
    public List<Module> addModule(Component parent, boolean anImport, String defaultModuleName) {
        if (this.myProject.isDefault()) {
            return null;
        }
        ProjectBuilder builder = this.runModuleWizard(parent, anImport, defaultModuleName);
        if (builder != null) {
            List<Module> committedModules;
            ArrayList<Module> modules = new ArrayList<Module>();
            if (builder instanceof ProjectImportBuilder) {
                ModifiableArtifactModel artifactModel = ProjectStructureConfigurable.getInstance(this.myProject).getArtifactsStructureConfigurable().getModifiableArtifactModel();
                committedModules = ((ProjectImportBuilder)builder).commit(this.myProject, this.myModuleModel, this, artifactModel);
            } else {
                committedModules = builder.commit(this.myProject, this.myModuleModel, (ModulesProvider)this);
            }
            if (committedModules != null) {
                modules.addAll(committedModules);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (Module module : modules) {
                    this.getOrCreateModuleEditor(module);
                }
            });
            return modules;
        }
        return null;
    }

    private Module createModule(ModuleBuilder builder) {
        try {
            return (Module)ApplicationManager.getApplication().runWriteAction(() -> builder.createModule(this.myModuleModel));
        }
        catch (Exception e) {
            LOG.error(JavaUiBundle.message("module.add.error.message", e.getMessage()), (Throwable)e);
            Messages.showErrorDialog((String)JavaUiBundle.message("module.add.error.message", e.getMessage()), (String)JavaUiBundle.message("module.add.error.title", new Object[0]));
            return null;
        }
    }

    @Nullable
    public Module addModule(ModuleBuilder moduleBuilder) {
        Module module = this.createModule(moduleBuilder);
        if (module != null) {
            ApplicationManager.getApplication().runWriteAction(() -> this.getOrCreateModuleEditor(module));
            this.processModuleCountChanged();
        }
        return module;
    }

    @Nullable
    private ProjectBuilder runModuleWizard(Component dialogParent, boolean anImport, String defaultModuleName) {
        AbstractProjectWizard wizard;
        if (anImport) {
            wizard = ImportModuleAction.selectFileAndCreateWizard(this.myProject, dialogParent);
            if (wizard == null) {
                return null;
            }
            if (wizard.getStepCount() == 0) {
                ProjectBuilder builder = this.getProjectBuilder(wizard);
                Disposer.dispose((Disposable)wizard.getDisposable());
                return builder;
            }
        } else {
            wizard = new NewProjectWizard(this.myProject, dialogParent, this, defaultModuleName);
        }
        if (!wizard.showAndGet()) {
            return null;
        }
        return wizard.getBuilder(this.myProject);
    }

    private ProjectBuilder getProjectBuilder(@NotNull AbstractProjectWizard wizard) {
        ProjectBuilder builder = wizard.getProjectBuilder();
        if (!builder.validate(this.myProject, this.myProject)) {
            return null;
        }
        return builder;
    }

    private boolean doRemoveModules(@NotNull List<? extends ModuleEditor> selectedEditors) {
        if (selectedEditors.isEmpty()) {
            return true;
        }
        String question = this.myModuleEditors.size() == selectedEditors.size() ? JavaUiBundle.message("module.remove.last.confirmation", selectedEditors.size()) : JavaUiBundle.message("module.remove.confirmation", selectedEditors.get(0).getModule().getName(), selectedEditors.size());
        int result = Messages.showYesNoDialog((Project)this.myProject, (String)question, (String)JavaUiBundle.message("module.remove.confirmation.title", selectedEditors.size()), (Icon)Messages.getQuestionIcon());
        if (result != 0) {
            return false;
        }
        WriteAction.run(() -> {
            for (ModuleEditor editor : selectedEditors) {
                this.myModuleEditors.remove(editor.getModule());
                Module moduleToRemove = editor.getModule();
                ArrayList modifiableRootModels = new ArrayList();
                for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
                    ModifiableRootModel modifiableRootModel = moduleEditor.getModifiableRootModelProxy();
                    ContainerUtil.addIfNotNull(modifiableRootModels, (Object)modifiableRootModel);
                }
                ModuleDeleteProvider.removeModule((Module)moduleToRemove, modifiableRootModels, (ModifiableModuleModel)this.myModuleModel);
                Disposer.dispose((Disposable)editor);
            }
        });
        this.processModuleCountChanged();
        return true;
    }

    private void processModuleCountChanged() {
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            moduleEditor.moduleCountChanged();
        }
    }

    public void processModuleCompilerOutputChanged(String baseUrl) {
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            moduleEditor.updateCompilerOutputPathChanged(baseUrl, moduleEditor.getName());
        }
    }

    public boolean isModified() {
        if (this.myModuleModel.isChanged()) {
            return true;
        }
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            if (!moduleEditor.isModified()) continue;
            return true;
        }
        return this.myModified || this.myFacetsConfigurator.isModified();
    }

    public static boolean showArtifactSettings(@NotNull Project project, @Nullable Artifact artifact) {
        ProjectStructureConfigurable configurable = ProjectStructureConfigurable.getInstance(project);
        return ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> configurable.select(artifact, true));
    }

    public static boolean showFacetSettingsDialog(@NotNull Facet facet, @Nullable String tabNameToSelect) {
        Project project = facet.getModule().getProject();
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(project);
        return ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)config, () -> {
            ModuleStructureConfigurable modulesConfig = config.getModulesConfig();
            config.select(facet, true).doWhenDone(() -> {
                if (tabNameToSelect != null) {
                    FacetEditorImpl facetEditor = modulesConfig.getFacetConfigurator().getOrCreateEditor(facet);
                    facetEditor.setSelectedTabName(tabNameToSelect);
                }
            });
        });
    }

    public static boolean showDialog(@NotNull Project project, @Nullable String moduleToSelect, @Nullable String editorNameToSelect) {
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(project);
        return ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)config, () -> config.select(moduleToSelect, editorNameToSelect, true));
    }

    public void moduleRenamed(@NotNull Module module, String oldName, @NotNull String name2) {
        ModuleEditor moduleEditor = this.myModuleEditors.get(module);
        if (moduleEditor != null) {
            moduleEditor.setModuleName(name2);
            moduleEditor.updateCompilerOutputPathChanged(ProjectStructureConfigurable.getInstance(this.myProject).getProjectConfig().getCompilerOutputUrl(), name2);
            this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, module));
        }
    }

    public StructureConfigurableContext getContext() {
        return this.myContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$apply$3(Map modifiedToOriginalMap, Ref exceptionRef) {
        ArrayList<ModifiableRootModel> models = new ArrayList<ModifiableRootModel>(this.myModuleEditors.size());
        try {
            for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
                Sdk original;
                Sdk modelSdk;
                ModifiableRootModel model = moduleEditor.apply();
                if (model == null) continue;
                if (!model.isSdkInherited() && (modelSdk = model.getSdk()) != null && (original = (Sdk)modifiedToOriginalMap.get(modelSdk)) != null) {
                    model.setSdk(original);
                }
                models.add(model);
            }
            this.myFacetsConfigurator.applyEditors();
        }
        catch (ConfigurationException e) {
            exceptionRef.set((Object)e);
            return;
        }
        try {
            for (ModuleEditor editor : this.myModuleEditors.values()) {
                editor.resetModifiableModel();
            }
            ModifiableModelCommitter.multiCommit(models, (ModifiableModuleModel)this.myModuleModel);
            this.myModuleModelCommitted = true;
            this.myFacetsConfigurator.commitFacets();
        }
        finally {
            ModuleStructureConfigurable.getInstance(this.myProject).getFacetEditorFacade().clearMaps(false);
            this.myFacetsConfigurator = this.createFacetsConfigurator();
            this.myModuleModel = ModuleManager.getInstance((Project)this.myProject).getModifiableModel();
            this.myModuleModelCommitted = false;
        }
    }
}

