/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.SdkComboBoxBase;
import com.intellij.openapi.roots.ui.configuration.SdkListItem;
import com.intellij.openapi.roots.ui.configuration.SdkListModel;
import com.intellij.openapi.roots.ui.configuration.SdkListModelBuilder;
import com.intellij.openapi.roots.ui.configuration.SdkListPresenter;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBoxPopupState;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkComboBox
extends SdkComboBoxBase<JdkComboBoxItem> {
    private static final Logger LOG = Logger.getInstance(JdkComboBox.class);
    @NotNull
    private final Consumer<Sdk> myOnNewSdkAdded = sdk -> {
        if (onNewSdkAdded != null) {
            onNewSdkAdded.consume(sdk);
        }
    };
    @Nullable
    private JButton mySetUpButton;

    @Deprecated
    public JdkComboBox(@NotNull ProjectSdksModel jdkModel) {
        this(jdkModel, null);
    }

    @Deprecated
    public JdkComboBox(@NotNull ProjectSdksModel jdkModel, @Nullable Condition<? super SdkTypeId> filter) {
        this(jdkModel, filter, JdkComboBox.getSdkFilter(filter), filter, false);
    }

    @Deprecated
    public JdkComboBox(@NotNull ProjectSdksModel jdkModel, @Nullable Condition<? super SdkTypeId> sdkTypeFilter, @Nullable Condition<? super Sdk> filter, @Nullable Condition<? super SdkTypeId> creationFilter, boolean addSuggestedItems) {
        this(null, jdkModel, sdkTypeFilter, filter, creationFilter, null);
    }

    public JdkComboBox(@Nullable Project project, @NotNull ProjectSdksModel sdkModel, @Nullable Condition<? super SdkTypeId> sdkTypeFilter, @Nullable Condition<? super Sdk> sdkFilter, @Nullable Condition<? super SdkTypeId> creationFilter, @Nullable Consumer<? super Sdk> onNewSdkAdded) {
        super(new SdkListModelBuilder(project, sdkModel, sdkTypeFilter, SimpleJavaSdkType.notSimpleJavaSdkType(creationFilter), sdkFilter));
        this.setRenderer(new SdkListPresenter(() -> ((JdkComboBoxModel)this.getModel()).myInnerModel).forType(JdkComboBox::unwrapItem));
        this.reloadModel();
    }

    protected void onModelUpdated(@NotNull SdkListModel model) {
        JdkComboBoxItem previousSelection = this.getSelectedItem();
        JdkComboBoxModel newModel = new JdkComboBoxModel(model);
        newModel.setSelectedItem(previousSelection);
        this.setModel(newModel);
    }

    @NotNull
    private static SdkListItem unwrapItem(@Nullable JdkComboBoxItem item) {
        if (item == null) {
            item = new ProjectJdkComboBoxItem();
        }
        if (item instanceof InnerComboBoxItem) {
            return ((InnerComboBoxItem)((Object)item)).getItem();
        }
        throw new RuntimeException("Failed to unwrap " + item.getClass().getName() + ": " + item);
    }

    @NotNull
    private static JdkComboBoxItem wrapItem(@NotNull SdkListItem item) {
        if (item instanceof SdkListItem.SdkItem) {
            return new ActualJdkInnerItem((SdkListItem.SdkItem)item);
        }
        if (item instanceof SdkListItem.NoneSdkItem) {
            return new NoneJdkComboBoxItem();
        }
        if (item instanceof SdkListItem.ProjectSdkItem) {
            return new ProjectJdkComboBoxItem();
        }
        return new InnerJdkComboBoxItem(item);
    }

    @Deprecated
    public void setSetupButton(JButton setUpButton, @Nullable Project project, ProjectSdksModel jdksModel, JdkComboBoxItem firstItem, @Nullable Condition<? super Sdk> additionalSetup, boolean moduleJdkSetup) {
        this.setSetupButton(setUpButton, project, jdksModel, firstItem, additionalSetup, "");
    }

    @Deprecated
    public void setSetupButton(JButton setUpButton, @Nullable Project project, ProjectSdksModel jdksModel, JdkComboBoxItem firstItem, @Nullable Condition<? super Sdk> additionalSetup, String actionGroupTitle) {
        this.mySetUpButton = setUpButton;
        this.mySetUpButton.setVisible(false);
    }

    public void setEditButton(@NotNull JButton editButton, @NotNull Project project, @NotNull Supplier<? extends Sdk> retrieveJDK) {
        editButton.addActionListener(e -> {
            Sdk projectJdk = (Sdk)retrieveJDK.get();
            if (projectJdk != null) {
                ProjectStructureConfigurable.getInstance(project).select(projectJdk, true);
            }
        });
        this.addActionListener(e -> {
            JdkComboBoxItem selectedItem = this.getSelectedItem();
            if (selectedItem instanceof ProjectJdkComboBoxItem) {
                editButton.setEnabled(ProjectStructureConfigurable.getInstance(project).getProjectJdksModel().getProjectSdk() != null);
            } else {
                editButton.setEnabled(selectedItem != null && selectedItem.getJdk() != null);
            }
        });
    }

    @Deprecated
    @Nullable
    public JButton getSetUpButton() {
        return this.mySetUpButton;
    }

    @Nullable
    public JdkComboBoxItem getSelectedItem() {
        return (JdkComboBoxItem)super.getSelectedItem();
    }

    @Nullable
    public Sdk getSelectedJdk() {
        JdkComboBoxItem selectedItem = this.getSelectedItem();
        return selectedItem != null ? selectedItem.getJdk() : null;
    }

    public void setSelectedJdk(@Nullable Sdk jdk) {
        this.setSelectedItem(jdk);
    }

    @Deprecated
    public void reloadModel(JdkComboBoxItem firstItem, @Nullable Project project) {
        this.processFirstItem(firstItem);
        this.reloadModel();
    }

    private void processFirstItem(@Nullable JdkComboBoxItem firstItem) {
        if (firstItem instanceof ProjectJdkComboBoxItem) {
            this.myModel.showProjectSdkItem();
        } else if (firstItem instanceof NoneJdkComboBoxItem) {
            this.myModel.showNoneSdkItem();
        } else if (firstItem instanceof ActualJdkComboBoxItem) {
            this.setSelectedJdk(((ActualJdkComboBoxItem)firstItem).myJdk);
        }
    }

    public void firePopupMenuWillBecomeVisible() {
        this.resolveSuggestionsIfNeeded();
        super.firePopupMenuWillBecomeVisible();
    }

    private void resolveSuggestionsIfNeeded() {
        this.myModel.reloadActions();
        DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)((Object)this));
        if (dialogWrapper == null) {
            LOG.warn("Cannot find DialogWrapper parent for the JdkComboBox " + (Object)((Object)this) + ", SDK search is disabled", (Throwable)new RuntimeException());
            return;
        }
        this.myModel.detectItems((JComponent)((Object)this), dialogWrapper.getDisposable());
    }

    public void setSelectedItem(@Nullable Object anObject) {
        SdkListItem item;
        if (anObject instanceof SdkListItem) {
            this.setSelectedItem(JdkComboBox.wrapItem((SdkListItem)anObject));
            return;
        }
        if (anObject == null) {
            SdkListModel innerModel = ((JdkComboBoxModel)this.getModel()).myInnerModel;
            SdkListItem candidate = innerModel.findProjectSdkItem();
            if (candidate == null) {
                candidate = innerModel.findNoneSdkItem();
            }
            if (candidate == null) {
                candidate = this.myModel.showProjectSdkItem();
            }
            this.setSelectedItem(candidate);
            return;
        }
        if (anObject instanceof Sdk) {
            this.myModel.reloadSdks();
            ((JdkComboBoxModel)this.getModel()).trySelectSdk((Sdk)anObject);
            return;
        }
        if (anObject instanceof InnerComboBoxItem && this.myModel.executeAction((JComponent)((Object)this), item = ((InnerComboBoxItem)anObject).getItem(), newItem -> {
            this.setSelectedItem(newItem);
            if (newItem instanceof SdkListItem.SdkItem) {
                this.myOnNewSdkAdded.consume((Object)((SdkListItem.SdkItem)newItem).getSdk());
            }
        })) {
            return;
        }
        if (anObject instanceof SelectableComboBoxItem) {
            super.setSelectedItem(anObject);
        }
    }

    @NotNull
    public static Condition<Sdk> getSdkFilter(@Nullable Condition<? super SdkTypeId> filter) {
        return filter == null ? Conditions.alwaysTrue() : sdk -> filter.value((Object)sdk.getSdkType());
    }

    @Deprecated
    public void insertItemAt(JdkComboBoxItem item, int index) {
        super.insertItemAt((Object)item, index);
        this.processFirstItem(item);
    }

    @Deprecated
    public static class SuggestedJdkItem
    extends JdkComboBoxItem {
        private final SdkType mySdkType;
        private final String myPath;

        SuggestedJdkItem(@NotNull SdkType sdkType, @NotNull String path) {
            this.mySdkType = sdkType;
            this.myPath = path;
        }

        @NotNull
        public SdkType getSdkType() {
            return this.mySdkType;
        }

        @NotNull
        public String getPath() {
            return this.myPath;
        }

        public String toString() {
            return this.myPath;
        }
    }

    public static class NoneJdkComboBoxItem
    extends JdkComboBoxItem
    implements InnerComboBoxItem,
    SelectableComboBoxItem {
        @Override
        @NotNull
        public SdkListItem getItem() {
            return new SdkListItem.NoneSdkItem();
        }

        public String toString() {
            return JavaUiBundle.message("jdk.combo.box.none.item", new Object[0]);
        }

        public int hashCode() {
            return 42;
        }

        public boolean equals(Object obj) {
            return obj instanceof NoneJdkComboBoxItem;
        }
    }

    public static class ProjectJdkComboBoxItem
    extends JdkComboBoxItem
    implements InnerComboBoxItem,
    SelectableComboBoxItem {
        @Override
        @NotNull
        public SdkListItem getItem() {
            return new SdkListItem.ProjectSdkItem();
        }

        public int hashCode() {
            return 42;
        }

        public boolean equals(Object obj) {
            return obj instanceof ProjectJdkComboBoxItem;
        }
    }

    public static class ActualJdkComboBoxItem
    extends JdkComboBoxItem
    implements SelectableComboBoxItem {
        private final Sdk myJdk;

        public ActualJdkComboBoxItem(@NotNull Sdk jdk) {
            this.myJdk = jdk;
        }

        public String toString() {
            return this.myJdk.getName();
        }

        @Override
        @NotNull
        public Sdk getJdk() {
            return this.myJdk;
        }

        @Override
        @Nullable
        public String getSdkName() {
            return this.myJdk.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActualJdkComboBoxItem item = (ActualJdkComboBoxItem)o;
            return this.myJdk.equals(item.myJdk);
        }

        public int hashCode() {
            return Objects.hash(this.myJdk);
        }
    }

    private static class ActualJdkInnerItem
    extends ActualJdkComboBoxItem
    implements InnerComboBoxItem {
        private final SdkListItem.SdkItem myItem;

        private ActualJdkInnerItem(@NotNull SdkListItem.SdkItem item) {
            super(item.getSdk());
            this.myItem = item;
        }

        @Override
        @NotNull
        public SdkListItem getItem() {
            return this.myItem;
        }
    }

    private static class InnerJdkComboBoxItem
    extends JdkComboBoxItem
    implements InnerComboBoxItem {
        private final SdkListItem myItem;

        private InnerJdkComboBoxItem(@NotNull SdkListItem item) {
            this.myItem = item;
        }

        @Override
        @NotNull
        public SdkListItem getItem() {
            return this.myItem;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InnerJdkComboBoxItem item = (InnerJdkComboBoxItem)o;
            return this.myItem.equals(item.myItem);
        }

        public int hashCode() {
            return Objects.hash(this.myItem);
        }
    }

    public static abstract class JdkComboBoxItem {
        @Nullable
        public Sdk getJdk() {
            return null;
        }

        @Nullable
        public String getSdkName() {
            return null;
        }
    }

    private static interface SelectableComboBoxItem {
    }

    private static interface InnerComboBoxItem {
        @NotNull
        public SdkListItem getItem();
    }

    private static class JdkComboBoxModel
    extends AbstractListModel<JdkComboBoxItem>
    implements ComboBoxPopupState<JdkComboBoxItem>,
    ComboBoxModel<JdkComboBoxItem> {
        private final SdkListModel myInnerModel;
        private JdkComboBoxItem mySelectedItem;

        JdkComboBoxModel(@NotNull SdkListModel innerModel) {
            this.myInnerModel = innerModel;
        }

        @Override
        public int getSize() {
            return this.myInnerModel.getItems().size();
        }

        @Override
        public JdkComboBoxItem getElementAt(int index) {
            return JdkComboBox.wrapItem((SdkListItem)this.myInnerModel.getItems().get(index));
        }

        @Nullable
        public ListModel<JdkComboBoxItem> onChosen(JdkComboBoxItem selectedValue) {
            if (selectedValue instanceof InnerComboBoxItem) {
                SdkListModel inner = this.myInnerModel.onChosen(((InnerComboBoxItem)((Object)selectedValue)).getItem());
                return inner == null ? null : new JdkComboBoxModel(inner);
            }
            return null;
        }

        public boolean hasSubstep(JdkComboBoxItem selectedValue) {
            if (selectedValue instanceof InnerComboBoxItem) {
                return this.myInnerModel.hasSubstep(((InnerComboBoxItem)((Object)selectedValue)).getItem());
            }
            return false;
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (!(anObject instanceof JdkComboBoxItem)) {
                return;
            }
            if (!(anObject instanceof InnerComboBoxItem)) {
                return;
            }
            SdkListItem innerItem = ((InnerComboBoxItem)anObject).getItem();
            if (!this.myInnerModel.getItems().contains(innerItem)) {
                return;
            }
            this.mySelectedItem = (JdkComboBoxItem)anObject;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.mySelectedItem;
        }

        void trySelectSdk(@NotNull Sdk sdk) {
            SdkListItem.SdkItem item = this.myInnerModel.findSdkItem(sdk);
            if (item == null) {
                return;
            }
            this.setSelectedItem(JdkComboBox.wrapItem((SdkListItem)item));
        }
    }
}

