/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ConfigurationError;
import com.intellij.openapi.roots.ui.configuration.ConfigurationErrors;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectConfigurationProblem;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorPaneConfigurable
extends JPanel
implements Configurable,
Disposable,
ConfigurationErrors {
    private final Alarm myAlarm;
    private final List<ConfigurationError> myErrors = new ArrayList<ConfigurationError>();
    private int myComputedErrorsStamp;
    private int myShownErrorsStamp;
    private final Object myLock = new Object();
    private final MergingUpdateQueue myContentUpdateQueue;
    private final JTextPane myContent = new JTextPane();
    private final Runnable myOnErrorsChanged;

    public ErrorPaneConfigurable(Project project, StructureConfigurableContext context, Runnable onErrorsChanged) {
        super(new BorderLayout());
        this.myOnErrorsChanged = onErrorsChanged;
        this.myContent.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myContent.setEditable(false);
        this.myContent.setBackground(UIUtil.getListBackground());
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myContent, (boolean)true);
        pane.setHorizontalScrollBarPolicy(31);
        this.add(pane);
        this.myContentUpdateQueue = new MergingUpdateQueue("ErrorPaneConfigurable Content Updates", 300, false, (JComponent)pane, (Disposable)this, (JComponent)pane);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        project.getMessageBus().connect((Disposable)this).subscribe(ConfigurationErrors.TOPIC, (Object)this);
        this.myContent.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            public void hyperlinkActivated(HyperlinkEvent e) {
                URL url = e.getURL();
                AWTEvent awtEvent = EventQueue.getCurrentEvent();
                if (!(awtEvent instanceof MouseEvent)) {
                    return;
                }
                MouseEvent me = (MouseEvent)awtEvent;
                if (url != null) {
                    ConfigurationError error = null;
                    for (Element element = e.getSourceElement(); element != null; element = element.getParentElement()) {
                        if (!"li".equals(element.getName())) continue;
                        Element ol = element.getParentElement();
                        for (int i = 0; i < ol.getElementCount(); ++i) {
                            if (ol.getElement(i) != element) continue;
                            error = ErrorPaneConfigurable.this.getError(i, ErrorPaneConfigurable.this.myShownErrorsStamp);
                        }
                        break;
                    }
                    if (error == null) {
                        return;
                    }
                    String host = url.getHost();
                    String path = url.getPath();
                    if (path != null && path.startsWith("/")) {
                        path = StringUtil.unescapeXmlEntities((String)path.substring(1));
                    }
                    if (path != null) {
                        if ("fix".equals(host)) {
                            MouseEvent mouseEvent = new MouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers(), me.getX() - 15, me.getY() + 10, me.getClickCount(), me.isPopupTrigger());
                            error.fix(ErrorPaneConfigurable.this.myContent, new RelativePoint(mouseEvent));
                        } else {
                            error.navigate();
                        }
                    }
                }
            }
        });
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationError getError(int i, int expectedStamp) {
        Object object = this.myLock;
        synchronized (object) {
            return expectedStamp == this.myComputedErrorsStamp ? this.myErrors.get(i) : null;
        }
    }

    public void refresh() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            String header = "<html><header><style type='text/css'>body {  color: #" + ColorUtil.toHex((Color)new JBColor((Color)Gray.x33, UIUtil.getLabelForeground())) + ";  font-family: '" + StartupUiUtil.getLabelFont().getName() + ",serif';  font-size: " + StartupUiUtil.getLabelFont().getSize() + ";}li {  margin-bottom: 5;}ol {}a { text-decoration: none;}</style></header><body>";
            StringBuilder html = new StringBuilder(header);
            int i = 0;
            html.append("<ol>");
            ConfigurationError[] configurationErrorArray = this.myLock;
            synchronized (this.myLock) {
                ConfigurationError[] errors = this.myErrors.toArray(new ConfigurationError[0]);
                int currentStamp = this.myComputedErrorsStamp;
                // ** MonitorExit[var6_4] (shouldn't be in output)
                for (ConfigurationError error : errors) {
                    String description;
                    if (++i > 100) break;
                    html.append("<li>");
                    if (error instanceof ProjectConfigurationProblem) {
                        ProjectStructureProblemDescription problemDescription = ((ProjectConfigurationProblem)error).getProblemDescription();
                        description = problemDescription.getDescription();
                        if (description == null) {
                            ProjectStructureElement place = problemDescription.getPlace().getContainingElement();
                            description = XmlStringUtil.convertToHtmlContent((String)problemDescription.getMessage(false));
                            if (problemDescription.canShowPlace()) {
                                description = place.getTypeName() + " <a href='http://navigate/" + i + "'>" + XmlStringUtil.convertToHtmlContent((String)place.getPresentableName()) + "</a>: " + StringUtil.decapitalize((String)description);
                            }
                        } else {
                            description = XmlStringUtil.convertToHtmlContent((String)description);
                        }
                    } else {
                        description = XmlStringUtil.convertToHtmlContent((String)error.getDescription());
                    }
                    if (error.canBeFixed()) {
                        description = description + " <a href='http://fix/" + i + "'>[Fix]</a>";
                    }
                    html.append(description).append("</li>");
                }
                html.append("</ol></body></html>");
                this.myContentUpdateQueue.queue((Update)new ShowErrorsUpdate(currentStamp, html.toString()));
                if (this.myOnErrorsChanged != null) {
                    this.myOnErrorsChanged.run();
                }
                return;
            }
        }, 100);
    }

    @Nls
    public String getDisplayName() {
        return JavaUiBundle.message("configurable.ErrorPaneConfigurable.display.name", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        return this;
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addError(@NotNull ConfigurationError error) {
        Object object = this.myLock;
        synchronized (object) {
            this.myErrors.add(error);
            ++this.myComputedErrorsStamp;
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeError(@NotNull ConfigurationError error) {
        Object object = this.myLock;
        synchronized (object) {
            this.myErrors.remove(error);
            ++this.myComputedErrorsStamp;
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getErrorsCount() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myErrors.size();
        }
    }

    private class ShowErrorsUpdate
    extends Update {
        private final int myCurrentStamp;
        private final String myText;

        ShowErrorsUpdate(int currentStamp, String text2) {
            super((Object)currentStamp);
            this.myCurrentStamp = currentStamp;
            this.myText = text2;
        }

        public void run() {
            if (!Disposer.isDisposed((Disposable)ErrorPaneConfigurable.this)) {
                ErrorPaneConfigurable.this.myContent.setText(this.myText);
                ErrorPaneConfigurable.this.myShownErrorsStamp = this.myCurrentStamp;
            }
        }

        public boolean canEat(Update update2) {
            return update2 instanceof ShowErrorsUpdate && this.myCurrentStamp > ((ShowErrorsUpdate)update2).myCurrentStamp;
        }
    }
}

