/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModulePackageIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public final class ModulePackageIndexImpl
extends ModulePackageIndex {
    private final ModuleFileIndex myModuleFileIndex;
    private final DirectoryIndex myDirectoryIndex;
    private final Condition<VirtualFile> myDirCondition = new Condition<VirtualFile>(){

        public boolean value(VirtualFile dir) {
            return dir.isValid() && ModulePackageIndexImpl.this.myModuleFileIndex.getOrderEntryForFile(dir) != null;
        }
    };

    public ModulePackageIndexImpl(@NotNull Module module) {
        this.myModuleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
        this.myDirectoryIndex = DirectoryIndex.getInstance((Project)module.getProject());
    }

    @NotNull
    public Query<VirtualFile> getDirsByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        return new FilteredQuery(this.myDirectoryIndex.getDirectoriesByPackageName(packageName, includeLibrarySources), this.myDirCondition);
    }

    public VirtualFile @NotNull [] getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        return (VirtualFile[])this.getDirsByPackageName(packageName, includeLibrarySources).toArray((Object[])VirtualFile.EMPTY_ARRAY);
    }
}

