/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.pom.java.LanguageLevel;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class JavaProjectModelModificationServiceImpl
extends JavaProjectModelModificationService {
    private final Project myProject;

    public JavaProjectModelModificationServiceImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public Promise<Void> addDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope, boolean exported) {
        for (JavaProjectModelModifier modifier : this.getModelModifiers()) {
            Promise<Void> promise = modifier.addModuleDependency(from, to, scope, exported);
            if (promise == null) continue;
            return promise;
        }
        return Promises.rejectedPromise();
    }

    @Override
    public Promise<Void> addDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope, boolean exported) {
        for (JavaProjectModelModifier modifier : this.getModelModifiers()) {
            Promise<Void> promise = modifier.addLibraryDependency(from, library, scope, exported);
            if (promise == null) continue;
            return promise;
        }
        return Promises.rejectedPromise();
    }

    @Override
    public Promise<Void> addDependency(@NotNull Collection<? extends Module> from, @NotNull ExternalLibraryDescriptor libraryDescriptor, @NotNull DependencyScope scope) {
        for (JavaProjectModelModifier modifier : this.getModelModifiers()) {
            Promise<Void> promise = modifier.addExternalLibraryDependency(from, libraryDescriptor, scope);
            if (promise == null) continue;
            return promise;
        }
        return Promises.rejectedPromise();
    }

    @Override
    public Promise<Void> changeLanguageLevel(@NotNull Module module, @NotNull LanguageLevel languageLevel) {
        for (JavaProjectModelModifier modifier : this.getModelModifiers()) {
            Promise<Void> promise = modifier.changeLanguageLevel(module, languageLevel);
            if (promise == null) continue;
            return promise;
        }
        return Promises.rejectedPromise();
    }

    private JavaProjectModelModifier @NotNull [] getModelModifiers() {
        return (JavaProjectModelModifier[])JavaProjectModelModifier.EP_NAME.getExtensions((AreaInstance)this.myProject);
    }
}

