/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ArrayUtilRt;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class JavaModuleExternalPathsImpl
extends JavaModuleExternalPaths {
    private static final String ROOT_ELEMENT = "root";
    private final Map<OrderRootType, VirtualFilePointerContainer> myOrderRootPointerContainers = new THashMap();
    private final JavaModuleExternalPathsImpl mySource;

    public JavaModuleExternalPathsImpl() {
        this(null);
    }

    @NonInjectable
    private JavaModuleExternalPathsImpl(JavaModuleExternalPathsImpl source) {
        this.mySource = source;
        if (source != null) {
            this.copyContainersFrom(source);
        }
    }

    @NotNull
    public ModuleExtension getModifiableModel(boolean writable) {
        return new JavaModuleExternalPathsImpl(this);
    }

    public void commit() {
        this.mySource.copyContainersFrom(this);
    }

    public String @NotNull [] getJavadocUrls() {
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(JavadocOrderRootType.getInstance());
        return container != null ? container.getUrls() : ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public VirtualFile @NotNull [] getExternalAnnotationsRoots() {
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(AnnotationOrderRootType.getInstance());
        return container != null ? container.getFiles() : VirtualFile.EMPTY_ARRAY;
    }

    public String @NotNull [] getExternalAnnotationsUrls() {
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(AnnotationOrderRootType.getInstance());
        return container != null ? container.getUrls() : ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public void setJavadocUrls(String @NotNull [] urls) {
        this.setRootUrls(JavadocOrderRootType.getInstance(), urls);
    }

    public void setExternalAnnotationUrls(String @NotNull [] urls) {
        this.setRootUrls(AnnotationOrderRootType.getInstance(), urls);
    }

    private void setRootUrls(OrderRootType orderRootType, String @NotNull [] urls) {
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(orderRootType);
        if (container == null) {
            if (urls.length == 0) {
                return;
            }
            container = VirtualFilePointerManager.getInstance().createContainer((Disposable)this, null);
            this.myOrderRootPointerContainers.put(orderRootType, container);
        } else {
            container.clear();
        }
        for (String url : urls) {
            container.add(url);
        }
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        for (PersistentOrderRootType orderRootType : OrderRootType.getAllPersistentTypes()) {
            Element pathsElement;
            String paths = orderRootType.getModulePathsName();
            if (paths == null || (pathsElement = element.getChild(paths)) == null || pathsElement.getChildren(ROOT_ELEMENT).isEmpty()) continue;
            VirtualFilePointerContainer container = VirtualFilePointerManager.getInstance().createContainer((Disposable)this, null);
            this.myOrderRootPointerContainers.put((OrderRootType)orderRootType, container);
            container.readExternal(pathsElement, ROOT_ELEMENT, false);
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        ArrayList<Element> toWrite = null;
        for (OrderRootType orderRootType : this.myOrderRootPointerContainers.keySet()) {
            VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(orderRootType);
            if (container == null || container.size() <= 0) continue;
            Element content = new Element(((PersistentOrderRootType)orderRootType).getModulePathsName());
            container.writeExternal(content, ROOT_ELEMENT, false);
            if (toWrite == null) {
                toWrite = new ArrayList<Element>();
            }
            toWrite.add(content);
        }
        if (toWrite != null) {
            toWrite.sort(Comparator.comparing(Element::getName));
            for (Element content : toWrite) {
                element.addContent(content);
            }
        }
    }

    private void copyContainersFrom(@NotNull JavaModuleExternalPathsImpl source) {
        this.myOrderRootPointerContainers.clear();
        for (OrderRootType orderRootType : source.myOrderRootPointerContainers.keySet()) {
            VirtualFilePointerContainer otherContainer = source.myOrderRootPointerContainers.get(orderRootType);
            if (otherContainer == null) continue;
            this.myOrderRootPointerContainers.put(orderRootType, otherContainer.clone((Disposable)this, null));
        }
    }

    public boolean isChanged() {
        if (this.myOrderRootPointerContainers.size() != this.mySource.myOrderRootPointerContainers.size()) {
            return true;
        }
        for (OrderRootType type2 : this.myOrderRootPointerContainers.keySet()) {
            String[] otherUrls;
            VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(type2);
            VirtualFilePointerContainer otherContainer = this.mySource.myOrderRootPointerContainers.get(type2);
            if (container == null || otherContainer == null) {
                if (container == otherContainer) continue;
                return true;
            }
            String[] urls = container.getUrls();
            if (urls.length != (otherUrls = otherContainer.getUrls()).length) {
                return true;
            }
            for (int i = 0; i < urls.length; ++i) {
                if (Comparing.strEqual((String)urls[i], (String)otherUrls[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void dispose() {
    }
}

