/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ExcludeCompilerOutputPolicy
implements DirectoryIndexExcludePolicy {
    private final Project myProject;

    public ExcludeCompilerOutputPolicy(Project project) {
        this.myProject = project;
    }

    public String @NotNull [] getExcludeUrlsForProject() {
        String outputPath;
        CompilerProjectExtension projectExtension = CompilerProjectExtension.getInstance((Project)this.myProject);
        String string = outputPath = projectExtension == null ? null : projectExtension.getCompilerOutputUrl();
        if (outputPath != null) {
            return new String[]{outputPath};
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public VirtualFilePointer @NotNull [] getExcludeRootsForModule(@NotNull ModuleRootModel rootModel) {
        ArrayList result = new ArrayList();
        CompilerModuleExtension extension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class);
        if (extension == null) {
            return VirtualFilePointer.EMPTY_ARRAY;
        }
        if (extension.isCompilerOutputPathInherited()) {
            CompilerProjectExtension projectExtension = CompilerProjectExtension.getInstance((Project)this.myProject);
            if (projectExtension != null) {
                ContainerUtil.addIfNotNull(result, (Object)projectExtension.getCompilerOutputPointer());
            }
        } else {
            if (!extension.isExcludeOutput()) {
                return VirtualFilePointer.EMPTY_ARRAY;
            }
            ContainerUtil.addIfNotNull(result, (Object)extension.getCompilerOutputPointer());
            ContainerUtil.addIfNotNull(result, (Object)extension.getCompilerOutputForTestsPointer());
        }
        return result.isEmpty() ? VirtualFilePointer.EMPTY_ARRAY : result.toArray(VirtualFilePointer.EMPTY_ARRAY);
    }
}

