/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.pom.java.LanguageLevel;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public abstract class JavaProjectModelModificationService {
    public static JavaProjectModelModificationService getInstance(@NotNull Project project) {
        return (JavaProjectModelModificationService)ServiceManager.getService((Project)project, JavaProjectModelModificationService.class);
    }

    public Promise<Void> addDependency(@NotNull Module from, @NotNull Module to) {
        return this.addDependency(from, to, DependencyScope.COMPILE);
    }

    public Promise<Void> addDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope) {
        return this.addDependency(from, to, scope, false);
    }

    public abstract Promise<Void> addDependency(@NotNull Module var1, @NotNull Module var2, @NotNull DependencyScope var3, boolean var4);

    public Promise<Void> addDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope) {
        return this.addDependency(from, library, scope, false);
    }

    public abstract Promise<Void> addDependency(@NotNull Module var1, @NotNull Library var2, @NotNull DependencyScope var3, boolean var4);

    public Promise<Void> addDependency(@NotNull Module from, @NotNull ExternalLibraryDescriptor libraryDescriptor) {
        return this.addDependency(from, libraryDescriptor, DependencyScope.COMPILE);
    }

    public Promise<Void> addDependency(@NotNull Module from, @NotNull ExternalLibraryDescriptor descriptor, @NotNull DependencyScope scope) {
        return this.addDependency(Collections.singletonList(from), descriptor, scope);
    }

    public abstract Promise<Void> addDependency(@NotNull Collection<? extends Module> var1, @NotNull ExternalLibraryDescriptor var2, @NotNull DependencyScope var3);

    public abstract Promise<Void> changeLanguageLevel(@NotNull Module var1, @NotNull LanguageLevel var2);
}

