/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ui;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.plugins.newui.TwoLineProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.SdkEditorAdditionalOptionsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.projectRoots.ui.PathEditor;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTracker;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkEditor
implements Configurable,
Place.Navigator {
    private static final Logger LOG = Logger.getInstance(SdkEditor.class);
    private static final String SDK_TAB = "sdkTab";
    @NotNull
    private final Sdk mySdk;
    private final Map<OrderRootType, SdkPathEditor> myPathEditors = new HashMap<OrderRootType, SdkPathEditor>();
    private TextFieldWithBrowseButton myHomeComponent;
    private final Map<SdkType, List<AdditionalDataConfigurable>> myAdditionalDataConfigurables = new HashMap<SdkType, List<AdditionalDataConfigurable>>();
    private final Map<AdditionalDataConfigurable, JComponent> myAdditionalDataComponents = new HashMap<AdditionalDataConfigurable, JComponent>();
    private JPanel myAdditionalDataPanel;
    private JPanel myDownloadingPanel;
    private InlineProgressIndicator myDownloadProgressIndicator;
    private final SdkModificator myEditedSdkModificator = new EditedSdkModificator();
    private JPanel myMainPanel;
    private TabbedPaneWrapper myTabbedPane;
    private final Project myProject;
    private final SdkModel mySdkModel;
    private JLabel myHomeFieldLabel;
    private String myVersionString;
    private String myInitialName;
    private String myInitialPath;
    private boolean myIsDownloading = false;
    private final History myHistory;
    private final Disposable myDisposable = Disposer.newDisposable();
    private boolean myIsDisposed = false;
    private final Consumer<Boolean> myResetCallback = __ -> {
        if (!this.myIsDisposed) {
            this.reset();
        }
    };

    public SdkEditor(@NotNull Project project, @NotNull SdkModel sdkModel, @NotNull History history, @NotNull ProjectJdkImpl sdk) {
        this.myProject = project;
        this.mySdkModel = sdkModel;
        this.myHistory = history;
        this.mySdk = sdk;
        this.myInitialName = this.mySdk.getName();
        this.myInitialPath = this.mySdk.getHomePath();
        this.createMainPanel();
        for (AdditionalDataConfigurable additionalDataConfigurable : this.getAdditionalDataConfigurable()) {
            additionalDataConfigurable.setSdk((Sdk)sdk);
        }
        this.reset();
    }

    public String getDisplayName() {
        return JavaUiBundle.message("sdk.configure.editor.title", new Object[0]);
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    private void createMainPanel() {
        this.myMainPanel = new JPanel(new GridBagLayout());
        this.myTabbedPane = new TabbedPaneWrapper(this.myDisposable);
        for (OrderRootType type2 : OrderRootType.getAllTypes()) {
            SdkPathEditor pathEditor;
            if (!this.showTabForType(type2) || (pathEditor = ((OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)type2)).createPathEditor(this.mySdk)) == null) continue;
            pathEditor.setAddBaseDir(this.mySdk.getHomeDirectory());
            this.myTabbedPane.addTab(pathEditor.getDisplayName(), pathEditor.createComponent());
            this.myPathEditors.put(type2, pathEditor);
        }
        this.myTabbedPane.addChangeListener(e -> this.myHistory.pushQueryPlace());
        this.myHomeComponent = this.createHomeComponent();
        this.myHomeComponent.getTextField().setEditable(false);
        this.myHomeFieldLabel = new JLabel(this.getHomeFieldLabelValue());
        this.myHomeFieldLabel.setLabelFor(this.myHomeComponent.getTextField());
        this.myMainPanel.add((Component)this.myHomeFieldLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)2, (int)10, (int)2, (int)2), 0, 0));
        this.myMainPanel.add((Component)this.myHomeComponent, new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 10, 2, (Insets)JBUI.insets((int)2, (int)2, (int)2, (int)10), 0, 0));
        this.myAdditionalDataPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add((Component)this.myAdditionalDataPanel, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 10, 1, (Insets)JBUI.insets((int)2, (int)10, (int)0, (int)10), 0, 0));
        this.myMainPanel.add((Component)this.myTabbedPane.getComponent(), new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.insetsTop((int)2), 0, 0));
        this.myDownloadingPanel = new JPanel(new BorderLayout());
        this.myDownloadProgressIndicator = new TwoLineProgressIndicator(true);
        this.myDownloadProgressIndicator.setIndeterminate(true);
        this.myDownloadingPanel.add((Component)this.myDownloadProgressIndicator.getComponent(), "North");
        this.myDownloadProgressIndicator.getComponent().setMaximumSize((Dimension)JBUI.size((int)300, (int)200));
        this.myMainPanel.add((Component)this.myDownloadingPanel, new GridBagConstraints(0, -1, 2, 1, 0.0, 1.0, 15, 1, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
    }

    protected TextFieldWithBrowseButton createHomeComponent() {
        return new TextFieldWithBrowseButton(e -> this.doSelectHomePath());
    }

    protected boolean showTabForType(@NotNull OrderRootType type2) {
        return ((SdkType)this.mySdk.getSdkType()).isRootTypeApplicable(type2);
    }

    private String getHomeFieldLabelValue() {
        return ((SdkType)this.mySdk.getSdkType()).getHomeFieldLabel();
    }

    public boolean isModified() {
        boolean isModified;
        boolean bl = isModified = !Objects.equals(this.mySdk.getName(), this.myInitialName);
        if (this.myIsDownloading) {
            return isModified;
        }
        isModified = isModified || !Objects.equals(FileUtil.toSystemIndependentName((String)this.getHomeValue()), FileUtil.toSystemIndependentName((String)this.myInitialPath));
        for (PathEditor pathEditor : this.myPathEditors.values()) {
            isModified = isModified || pathEditor.isModified();
        }
        for (AdditionalDataConfigurable additionalDataConfigurable : this.getAdditionalDataConfigurable()) {
            isModified = isModified || additionalDataConfigurable.isModified();
        }
        return isModified;
    }

    public void apply() throws ConfigurationException {
        if (this.myIsDownloading) {
            return;
        }
        if (!Objects.equals(this.myInitialName, this.mySdk.getName()) && this.mySdk.getName().isEmpty()) {
            throw new ConfigurationException(ProjectBundle.message((String)"sdk.list.name.required.error", (Object[])new Object[0]));
        }
        this.myInitialName = this.mySdk.getName();
        this.myInitialPath = this.mySdk.getHomePath();
        SdkModificator sdkModificator = this.mySdk.getSdkModificator();
        sdkModificator.setHomePath(FileUtil.toSystemIndependentName((String)this.getHomeValue()));
        for (SdkPathEditor pathEditor : this.myPathEditors.values()) {
            pathEditor.apply(sdkModificator);
        }
        ApplicationManager.getApplication().runWriteAction(() -> ((SdkModificator)sdkModificator).commitChanges());
        for (AdditionalDataConfigurable configurable : this.getAdditionalDataConfigurable()) {
            if (configurable == null) continue;
            configurable.apply();
        }
    }

    public void reset() {
        this.myIsDownloading = SdkDownloadTracker.getInstance().tryRegisterDownloadingListener(this.mySdk, this.myDisposable, (ProgressIndicator)this.myDownloadProgressIndicator, this.myResetCallback);
        if (!this.myIsDownloading) {
            SdkModificator sdkModificator = this.mySdk.getSdkModificator();
            for (OrderRootType type2 : this.myPathEditors.keySet()) {
                this.myPathEditors.get(type2).reset(sdkModificator);
            }
            sdkModificator.commitChanges();
        }
        this.setHomePathValue(FileUtil.toSystemDependentName((String)((String)ObjectUtils.notNull((Object)this.mySdk.getHomePath(), (Object)""))));
        this.myVersionString = null;
        this.myHomeFieldLabel.setText(this.getHomeFieldLabelValue());
        this.myTabbedPane.getComponent().setVisible(!this.myIsDownloading);
        this.myAdditionalDataPanel.setVisible(!this.myIsDownloading);
        this.myDownloadingPanel.setVisible(this.myIsDownloading);
        this.myHomeComponent.setEnabled(!this.myIsDownloading);
        if (!this.myIsDownloading) {
            this.updateAdditionalDataComponent();
            for (AdditionalDataConfigurable configurable : this.getAdditionalDataConfigurable()) {
                configurable.reset();
            }
            for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
                this.myTabbedPane.setEnabledAt(i, true);
            }
        }
    }

    public void disposeUIResources() {
        this.myIsDisposed = true;
        for (SdkType sdkType : this.myAdditionalDataConfigurables.keySet()) {
            for (AdditionalDataConfigurable configurable : this.myAdditionalDataConfigurables.get(sdkType)) {
                configurable.disposeUIResources();
            }
        }
        this.myAdditionalDataConfigurables.clear();
        this.myAdditionalDataComponents.clear();
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private String getHomeValue() {
        return this.myHomeComponent.getText().trim();
    }

    private void clearAllPaths() {
        for (PathEditor pathEditor : this.myPathEditors.values()) {
            pathEditor.clearList();
        }
    }

    private void setHomePathValue(String absolutePath) {
        Color fg;
        this.myHomeComponent.setText(absolutePath);
        if (absolutePath != null && !absolutePath.isEmpty() && this.mySdk.getSdkType().isLocalSdk(this.mySdk)) {
            File homeDir = new File(absolutePath);
            boolean homeMustBeDirectory = ((SdkType)this.mySdk.getSdkType()).getHomeChooserDescriptor().isChooseFolders();
            fg = homeDir.exists() && homeDir.isDirectory() == homeMustBeDirectory ? UIUtil.getFieldForegroundColor() : PathEditor.INVALID_COLOR;
        } else {
            fg = UIUtil.getFieldForegroundColor();
        }
        this.myHomeComponent.getTextField().setForeground(fg);
    }

    private void doSelectHomePath() {
        SdkType sdkType = (SdkType)this.mySdk.getSdkType();
        SdkConfigurationUtil.selectSdkHome((SdkType)sdkType, path -> this.doSetHomePath((String)path, sdkType));
    }

    private void doSetHomePath(String homePath, SdkType sdkType) {
        if (homePath == null) {
            return;
        }
        this.setHomePathValue(homePath.replace('/', File.separatorChar));
        String newSdkName = this.suggestSdkName(homePath);
        ((ProjectJdkImpl)this.mySdk).setName(newSdkName);
        try {
            Sdk dummySdk = (Sdk)this.mySdk.clone();
            SdkModificator sdkModificator = dummySdk.getSdkModificator();
            sdkModificator.setHomePath(homePath);
            sdkModificator.removeAllRoots();
            sdkModificator.commitChanges();
            sdkType.setupSdkPaths(dummySdk, this.mySdkModel);
            this.clearAllPaths();
            this.myVersionString = dummySdk.getVersionString();
            if (this.myVersionString == null) {
                Messages.showMessageDialog((String)ProjectBundle.message((String)"sdk.java.corrupt.error", (Object[])new Object[]{homePath}), (String)ProjectBundle.message((String)"sdk.java.corrupt.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            }
            sdkModificator = dummySdk.getSdkModificator();
            for (OrderRootType type2 : this.myPathEditors.keySet()) {
                SdkPathEditor pathEditor = this.myPathEditors.get(type2);
                pathEditor.setAddBaseDir(dummySdk.getHomeDirectory());
                pathEditor.addPaths(sdkModificator.getRoots(type2));
            }
            this.mySdkModel.getMulticaster().sdkHomeSelected(dummySdk, homePath);
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
        }
    }

    private String suggestSdkName(String homePath) {
        Sdk[] sdks;
        String suggestedName;
        String currentName = this.mySdk.getName();
        if (Objects.equals(currentName, suggestedName = ((SdkType)this.mySdk.getSdkType()).suggestSdkName(currentName, homePath))) {
            return currentName;
        }
        String newSdkName = suggestedName;
        HashSet<String> allNames = new HashSet<String>();
        for (Sdk sdk : sdks = this.mySdkModel.getSdks()) {
            allNames.add(sdk.getName());
        }
        int i = 0;
        while (allNames.contains(newSdkName)) {
            newSdkName = suggestedName + " (" + ++i + ")";
        }
        return newSdkName;
    }

    private void updateAdditionalDataComponent() {
        this.myAdditionalDataPanel.removeAll();
        for (AdditionalDataConfigurable configurable : this.getAdditionalDataConfigurable()) {
            JComponent component = this.myAdditionalDataComponents.get(configurable);
            if (component == null) {
                component = configurable.createComponent();
                this.myAdditionalDataComponents.put(configurable, component);
            }
            if (component == null) continue;
            if (configurable.getTabName() != null) {
                for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
                    if (!configurable.getTabName().equals(this.myTabbedPane.getTitleAt(i))) continue;
                    this.myTabbedPane.removeTabAt(i);
                }
                this.myTabbedPane.addTab(configurable.getTabName(), component);
                continue;
            }
            this.myAdditionalDataPanel.add((Component)component, "Center");
        }
    }

    @NotNull
    private List<AdditionalDataConfigurable> getAdditionalDataConfigurable() {
        return this.initAdditionalDataConfigurable(this.mySdk);
    }

    @NotNull
    private List<AdditionalDataConfigurable> initAdditionalDataConfigurable(Sdk sdk) {
        SdkType sdkType = (SdkType)sdk.getSdkType();
        List<AdditionalDataConfigurable> configurables = this.myAdditionalDataConfigurables.get(sdkType);
        if (configurables == null) {
            configurables = new ArrayList<AdditionalDataConfigurable>();
            this.myAdditionalDataConfigurables.put(sdkType, configurables);
            AdditionalDataConfigurable sdkConfigurable = sdkType.createAdditionalDataConfigurable(this.mySdkModel, this.myEditedSdkModificator);
            if (sdkConfigurable != null) {
                configurables.add(sdkConfigurable);
            }
            for (SdkEditorAdditionalOptionsProvider factory : SdkEditorAdditionalOptionsProvider.getSdkOptionsFactory(this.mySdk.getSdkType())) {
                AdditionalDataConfigurable options = factory.createOptions(this.myProject, this.mySdk);
                if (options == null) continue;
                configurables.add(options);
            }
        }
        return configurables;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        if (place == null) {
            return ActionCallback.DONE;
        }
        this.myTabbedPane.setSelectedTitle((String)place.getPath(SDK_TAB));
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        place.putPath(SDK_TAB, (Object)this.myTabbedPane.getSelectedTitle());
    }

    private class EditedSdkModificator
    implements SdkModificator {
        private EditedSdkModificator() {
        }

        @NotNull
        public String getName() {
            return SdkEditor.this.mySdk.getName();
        }

        public void setName(@NotNull String name2) {
            ((ProjectJdkImpl)SdkEditor.this.mySdk).setName(name2);
        }

        public String getHomePath() {
            return SdkEditor.this.getHomeValue();
        }

        public void setHomePath(String path) {
            SdkEditor.this.doSetHomePath(path, (SdkType)SdkEditor.this.mySdk.getSdkType());
        }

        public String getVersionString() {
            return SdkEditor.this.myVersionString != null ? SdkEditor.this.myVersionString : SdkEditor.this.mySdk.getVersionString();
        }

        public void setVersionString(String versionString) {
            throw new UnsupportedOperationException();
        }

        public SdkAdditionalData getSdkAdditionalData() {
            return SdkEditor.this.mySdk.getSdkAdditionalData();
        }

        public void setSdkAdditionalData(SdkAdditionalData data) {
            throw new UnsupportedOperationException();
        }

        public VirtualFile @NotNull [] getRoots(@NotNull OrderRootType rootType) {
            PathEditor editor = (PathEditor)SdkEditor.this.myPathEditors.get(rootType);
            if (editor == null) {
                throw new IllegalStateException("no editor for root type " + rootType);
            }
            return editor.getRoots();
        }

        public void addRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
            ((SdkPathEditor)SdkEditor.this.myPathEditors.get(rootType)).addPaths(new VirtualFile[]{root});
        }

        public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
            ((SdkPathEditor)SdkEditor.this.myPathEditors.get(rootType)).removePaths(new VirtualFile[]{root});
        }

        public void removeRoots(@NotNull OrderRootType rootType) {
            ((SdkPathEditor)SdkEditor.this.myPathEditors.get(rootType)).clearList();
        }

        public void removeAllRoots() {
            for (PathEditor editor : SdkEditor.this.myPathEditors.values()) {
                editor.clearList();
            }
        }

        public void commitChanges() {
        }

        public boolean isWritable() {
            return true;
        }
    }
}

