/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileHighlighter;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighterProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSyntaxHighlighterFactory
extends SyntaxHighlighterFactory
implements SyntaxHighlighterProvider {
    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile file) {
        return new JavaFileHighlighter(project == null ? LanguageLevel.HIGHEST : JavaPsiImplementationHelper.getInstance(project).getEffectiveLanguageLevel(file));
    }

    @Nullable
    public SyntaxHighlighter create(@NotNull FileType fileType, @Nullable Project project, @Nullable VirtualFile file) {
        if (project != null && file != null) {
            Language language;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (fileType == JavaClassFileType.INSTANCE && psiFile != null && (language = psiFile.getLanguage()) != JavaLanguage.INSTANCE) {
                return SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)file);
            }
            if (psiFile instanceof ClsFileImpl) {
                LanguageLevel sourceLevel = ((ClsFileImpl)psiFile).getLanguageLevel();
                return new JavaFileHighlighter(sourceLevel);
            }
        }
        return new JavaFileHighlighter();
    }
}

