/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.services.nexus;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.services.MavenRepositoryService;
import com.intellij.jarRepository.services.nexus.NexusModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NexusRepositoryService
extends MavenRepositoryService {
    private final Gson gson = new Gson();

    @Nullable
    public static RemoteRepositoryDescription convertRepositoryInfo(@NotNull NexusModel.RepositoryType repo) {
        if (repo.id == null) {
            return null;
        }
        if (repo.name == null) {
            return null;
        }
        if (repo.contentResourceURI == null) {
            return null;
        }
        return new RemoteRepositoryDescription(repo.id, repo.name, repo.contentResourceURI);
    }

    public static RepositoryArtifactDescription convertArtifactInfo(NexusModel.ArtifactType t) {
        return new RepositoryArtifactDescription(t.groupId, t.artifactId, t.version, t.packaging, t.classifier, null, t.repoId);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Nexus";
    }

    @Override
    @NotNull
    public List<RemoteRepositoryDescription> getRepositories(@NotNull String url) throws IOException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        try {
            NexusModel.RepositorySearchResults repos = (NexusModel.RepositorySearchResults)this.gson.fromJson(HttpRequests.request((Url)this.toUrl(url, "repositories")).productNameAsUserAgent().accept("application/json").readString(), NexusModel.RepositorySearchResults.class);
            SmartList result = new SmartList();
            if (repos.data != null) {
                for (NexusModel.RepositoryType repo : repos.data) {
                    RemoteRepositoryDescription desc;
                    if (!"maven2".equals(repo.provider) || (desc = NexusRepositoryService.convertRepositoryInfo(repo)) == null) continue;
                    result.add(desc);
                }
            }
            return result;
        }
        catch (JsonSyntaxException e) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    @NotNull
    public List<RepositoryArtifactDescription> findArtifacts(@NotNull String url, @NotNull RepositoryArtifactDescription template) throws IOException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        try {
            String packaging = StringUtil.notNullize((String)template.getPackaging());
            NexusModel.ArtifactSearchResults results = (NexusModel.ArtifactSearchResults)this.gson.fromJson(HttpRequests.request((Url)this.toUrl(url, "data_index", this.prepareParameters(template))).accept("application/json").readString(), NexusModel.ArtifactSearchResults.class);
            ArrayList<RepositoryArtifactDescription> result = new ArrayList<RepositoryArtifactDescription>();
            if (results.data != null) {
                for (NexusModel.ArtifactType each : results.data) {
                    if (!Objects.equals(each.packaging, packaging)) continue;
                    result.add(NexusRepositoryService.convertArtifactInfo(each));
                }
            }
            return result;
        }
        catch (JsonSyntaxException e) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @NotNull
    private String prepareParameters(@NotNull RepositoryArtifactDescription template) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("q", StringUtil.join(Arrays.asList(template.getGroupId(), template.getArtifactId(), template.getVersion()), (String)":"));
        params.put("g", template.getGroupId());
        params.put("a", template.getArtifactId());
        params.put("v", template.getVersion());
        params.put("cn", template.getClassNames());
        return this.mapToParamString(params);
    }
}

