/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.ide.JavaUiBundle;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

class RepositoryLibraryRootsComponentDescriptor
extends LibraryRootsComponentDescriptor {
    private static final Logger LOG = Logger.getInstance(RepositoryLibraryRootsComponentDescriptor.class);

    RepositoryLibraryRootsComponentDescriptor() {
    }

    @Nullable
    public OrderRootTypePresentation getRootTypePresentation(@NotNull OrderRootType type2) {
        return DefaultLibraryRootsComponentDescriptor.getDefaultPresentation(type2);
    }

    @NotNull
    public List<? extends RootDetector> getRootDetectors() {
        return Collections.singletonList(DefaultLibraryRootsComponentDescriptor.createAnnotationsRootDetector());
    }

    @NotNull
    public FileChooserDescriptor createAttachFilesChooserDescriptor(@Nullable String libraryName) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle(JavaUiBundle.message("chooser.title.attach.external.annotations", new Object[0]));
        descriptor.setDescription(JavaUiBundle.message("chooser.description.select.directory.where.external.annotations.are.located", new Object[0]));
        return descriptor;
    }

    public String getAttachFilesActionName() {
        return "Attach Annotations...";
    }

    @NotNull
    public List<? extends AttachRootButtonDescriptor> createAttachButtons() {
        return Collections.emptyList();
    }

    @NotNull
    public LibraryRootsComponentDescriptor.RootRemovalHandler createRootRemovalHandler() {
        return new LibraryRootsComponentDescriptor.RootRemovalHandler(){

            public void onRootRemoved(@NotNull String rootUrl, @NotNull OrderRootType rootType, @NotNull LibraryEditor libraryEditor) {
                if (rootType == OrderRootType.CLASSES) {
                    String coordinates = RepositoryLibraryRootsComponentDescriptor.getMavenCoordinates(rootUrl);
                    if (coordinates != null) {
                        RepositoryLibraryProperties properties = (RepositoryLibraryProperties)libraryEditor.getProperties();
                        properties.setExcludedDependencies(ContainerUtil.append((List)properties.getExcludedDependencies(), (Object[])new String[]{coordinates}));
                    } else {
                        LOG.warn("Cannot determine Maven coordinates for removed library root " + rootUrl);
                    }
                }
            }
        };
    }

    @Nullable
    private static String getMavenCoordinates(@NotNull String jarUrl) {
        File jarFile = new File(PathUtil.getLocalPath((String)VfsUtilCore.urlToPath((String)jarUrl)));
        if (jarFile.getParentFile() == null) {
            return null;
        }
        File artifactDir = jarFile.getParentFile().getParentFile();
        if (artifactDir == null) {
            return null;
        }
        File localRepoRoot = JarRepositoryManager.getLocalRepositoryPath();
        if (!FileUtil.isAncestor((File)localRepoRoot, (File)artifactDir, (boolean)true)) {
            return null;
        }
        String relativePath = FileUtil.getRelativePath((File)localRepoRoot, (File)artifactDir.getParentFile());
        if (relativePath == null) {
            return null;
        }
        return relativePath.replace(File.separatorChar, '.') + ":" + artifactDir.getName();
    }
}

