/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.ide.JavaUiBundle;
import com.intellij.jarFinder.AbstractAttachSourceProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IvyAttachSourceProvider
extends AbstractAttachSourceProvider {
    private static final Logger LOG = Logger.getInstance(IvyAttachSourceProvider.class);

    @NotNull
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(List<LibraryOrderEntry> orderEntries, PsiFile psiFile) {
        VirtualFile srcFile;
        String artifactName;
        VirtualFile jar = IvyAttachSourceProvider.getJarByPsiFile(psiFile);
        if (jar == null) {
            return Collections.emptyList();
        }
        VirtualFile jarsDir = jar.getParent();
        if (jarsDir == null || !jarsDir.getName().equals("jars")) {
            return Collections.emptyList();
        }
        final VirtualFile artifactDir = jarsDir.getParent();
        if (artifactDir == null) {
            return Collections.emptyList();
        }
        String jarNameWithoutExt = jar.getNameWithoutExtension();
        if (!jarNameWithoutExt.startsWith(artifactName = artifactDir.getName()) || !jarNameWithoutExt.substring(artifactName.length()).startsWith("-")) {
            return Collections.emptyList();
        }
        String version = jarNameWithoutExt.substring(artifactName.length() + 1);
        VirtualFile propertiesFile = artifactDir.findChild("ivydata-" + version + ".properties");
        if (propertiesFile == null) {
            return Collections.emptyList();
        }
        final Library library = IvyAttachSourceProvider.getLibraryFromOrderEntriesList(orderEntries);
        if (library == null) {
            return Collections.emptyList();
        }
        final String sourceFileName = artifactName + '-' + version + "-sources.jar";
        final VirtualFile sources = artifactDir.findChild("sources");
        if (sources != null && (srcFile = sources.findChild(sourceFileName)) != null) {
            VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(srcFile);
            if (jarRoot == null || ArrayUtil.contains((Object)jarRoot, (Object[])library.getFiles(OrderRootType.SOURCES))) {
                return Collections.emptyList();
            }
            return Collections.singleton(new AbstractAttachSourceProvider.AttachExistingSourceAction(jarRoot, library, "Attache sources from Ivy repository"));
        }
        String url = IvyAttachSourceProvider.extractUrl(propertiesFile, artifactName);
        if (StringUtil.isEmptyOrSpaces((String)url)) {
            return Collections.emptyList();
        }
        return Collections.singleton(new AbstractAttachSourceProvider.DownloadSourcesAction(psiFile.getProject(), "Downloading Ivy Sources", url){

            @Override
            protected void storeFile(byte[] content) {
                try {
                    VirtualFile existingSourcesFolder = sources;
                    if (existingSourcesFolder == null) {
                        existingSourcesFolder = artifactDir.createChildDirectory((Object)this, "sources");
                    }
                    VirtualFile srcFile = existingSourcesFolder.createChildData((Object)this, sourceFileName);
                    srcFile.setBinaryContent(content);
                    IvyAttachSourceProvider.this.addSourceFile(JarFileSystem.getInstance().getJarRootForLocalFile(srcFile), library);
                }
                catch (IOException e) {
                    String message2 = JavaUiBundle.message("error.message.failed.to.save.0", artifactDir.getPath() + "/sources/" + sourceFileName);
                    new Notification(this.myMessageGroupId, JavaUiBundle.message("notification.title.io.error", new Object[0]), message2, NotificationType.ERROR).notify(this.myProject);
                    LOG.warn((Throwable)e);
                }
            }
        });
    }

    @Nullable
    private static String extractUrl(VirtualFile properties, String artifactName) {
        String prefix = "artifact:" + artifactName + "#source#jar#";
        try {
            Properties p = new Properties();
            p.load(new StringReader(VfsUtilCore.loadText((VirtualFile)properties)));
            for (Object o : p.keySet()) {
                String key2 = o.toString();
                if (key2 == null || !key2.startsWith(prefix) || !key2.endsWith(".location")) continue;
                return p.getProperty(key2);
            }
        }
        catch (Exception e) {
            LOG.debug(properties.getPath(), (Throwable)e);
        }
        return null;
    }
}

