/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import org.jetbrains.annotations.NotNull;

public class StaticIconFieldsAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        final Project project = (Project)e.getData(LangDataKeys.PROJECT);
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabName("Statics");
        presentation.setTabText("Statitcs");
        final UsageView view = UsageViewManager.getInstance((Project)project).showUsages(UsageTarget.EMPTY_ARRAY, Usage.EMPTY_ARRAY, presentation);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Searching icons usages"){

            public void run(@NotNull ProgressIndicator indicator) {
                PsiClass[] classes2;
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                GlobalSearchScope all = GlobalSearchScope.allScope((Project)project);
                PsiClass allIcons = (PsiClass)ReadAction.compute(() -> facade.findClass("com.intellij.icons.AllIcons", all));
                StaticIconFieldsAction.searchFields(allIcons, view, indicator);
                for (PsiClass iconsClass : classes2 = (PsiClass[])ReadAction.compute(() -> facade.findPackage("icons").getClasses(all))) {
                    StaticIconFieldsAction.searchFields(iconsClass, view, indicator);
                }
            }
        });
    }

    private static void searchFields(PsiClass allIcons, UsageView view, ProgressIndicator indicator) {
        ApplicationManager.getApplication().runReadAction(() -> indicator.setText("Searching for: " + allIcons.getQualifiedName()));
        ReferencesSearch.search((PsiElement)allIcons).forEach(reference -> {
            PsiElement elt = reference.getElement();
            while (elt instanceof PsiExpression) {
                elt = elt.getParent();
            }
            if (elt instanceof PsiField) {
                UsageInfo info = new UsageInfo(elt, false);
                view.appendUsage((Usage)new UsageInfo2UsageAdapter(info));
            }
            return true;
        });
    }
}

