/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard.modes;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.importProject.FrameworkDetectionStep;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.importProject.RootsDetectionStep;
import com.intellij.ide.util.newProjectWizard.ProjectNameStep;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.modes.WizardMode;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFromSourcesMode
extends WizardMode {
    protected ProjectFromSourcesBuilderImpl myProjectBuilder;

    @Override
    @NotNull
    public String getDisplayName(WizardContext context) {
        return JavaUiBundle.message("project.new.wizard.from.existent.sources.title", context.getPresentationName());
    }

    @Override
    @NotNull
    public String getDescription(WizardContext context) {
        return JavaUiBundle.message("project.new.wizard.from.existent.sources.description", ApplicationNamesInfo.getInstance().getFullProductName(), context.getPresentationName());
    }

    @Override
    @Nullable
    protected StepSequence createSteps(@NotNull WizardContext context, @NotNull ModulesProvider modulesProvider) {
        StepSequence sequence = new StepSequence(new ModuleWizardStep[0]);
        this.addSteps(context, modulesProvider, sequence, null);
        return sequence;
    }

    public void addSteps(WizardContext context, ModulesProvider modulesProvider, StepSequence sequence, String specific) {
        ProjectFromSourcesBuilderImpl projectBuilder;
        this.myProjectBuilder = projectBuilder = new ProjectFromSourcesBuilderImpl(context, modulesProvider);
        Icon icon = context.getStepIcon();
        if (context.isCreatingNewProject()) {
            CreateFromSourcesMode.addStep(sequence, new ProjectNameStep(context, this), specific);
        }
        CreateFromSourcesMode.addStep(sequence, new RootsDetectionStep(projectBuilder, context, sequence, icon, "reference.dialogs.new.project.fromCode.source"), specific);
        HashSet<String> detectorTypes = new HashSet<String>();
        for (ProjectStructureDetector detector : (ProjectStructureDetector[])ProjectStructureDetector.EP_NAME.getExtensions()) {
            detectorTypes.add(detector.getDetectorId());
            for (ModuleWizardStep step2 : detector.createWizardSteps(projectBuilder, projectBuilder.getProjectDescriptor(detector), icon)) {
                sequence.addSpecificStep(detector.getDetectorId(), step2);
            }
        }
        if (FrameworkDetectionStep.isEnabled()) {
            FrameworkDetectionStep frameworkDetectionStep = new FrameworkDetectionStep(icon, projectBuilder){

                @Override
                public List<ModuleDescriptor> getModuleDescriptors() {
                    ArrayList<ModuleDescriptor> moduleDescriptors = new ArrayList<ModuleDescriptor>();
                    for (ProjectDescriptor descriptor : projectBuilder.getSelectedDescriptors()) {
                        moduleDescriptors.addAll(descriptor.getModules());
                    }
                    return moduleDescriptors;
                }
            };
            projectBuilder.addConfigurationUpdater(frameworkDetectionStep);
            sequence.addCommonFinishingStep(frameworkDetectionStep, detectorTypes);
        }
    }

    private static void addStep(StepSequence sequence, ModuleWizardStep step2, String specific) {
        if (specific == null) {
            sequence.addCommonStep(step2);
        } else {
            sequence.addSpecificStep(specific, step2);
        }
    }

    @Override
    public ProjectBuilder getModuleBuilder() {
        return this.myProjectBuilder;
    }

    @Override
    public void onChosen(boolean enabled) {
    }

    @Override
    public String getShortName() {
        return "Create from Sources";
    }

    @Override
    public void dispose() {
        this.myProjectBuilder = null;
        super.dispose();
    }
}

