/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.WizardDelegate;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.StepWithSubSteps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.io.File;
import java.nio.file.Paths;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProjectWizard
extends AbstractWizard<ModuleWizardStep> {
    protected final WizardContext myWizardContext;
    @Nullable
    private WizardDelegate myDelegate;

    public AbstractProjectWizard(String title, Project project, String defaultPath) {
        super(title, project);
        this.myWizardContext = AbstractProjectWizard.initContext(project, defaultPath, this.getDisposable());
        this.myWizardContext.setWizard((AbstractWizard)this);
    }

    public AbstractProjectWizard(@NlsContexts.DialogTitle String title, Project project, Component dialogParent) {
        super(title, dialogParent);
        this.myWizardContext = AbstractProjectWizard.initContext(project, null, this.getDisposable());
        this.myWizardContext.setWizard((AbstractWizard)this);
    }

    protected String addStepComponent(@NotNull Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder((Border)JBUI.Borders.empty());
        }
        return super.addStepComponent(component);
    }

    public abstract StepSequence getSequence();

    private static WizardContext initContext(@Nullable Project project, @Nullable String defaultPath, Disposable parentDisposable) {
        WizardContext context = new WizardContext(project, parentDisposable);
        if (defaultPath != null) {
            context.setProjectFileDirectory(Paths.get(defaultPath, new String[0]), true);
            context.setProjectName(defaultPath.substring(FileUtil.toSystemIndependentName((String)defaultPath).lastIndexOf("/") + 1));
        }
        return context;
    }

    @Nullable
    public static Sdk getNewProjectJdk(WizardContext context) {
        if (context.getProjectJdk() != null) {
            return context.getProjectJdk();
        }
        return AbstractProjectWizard.getProjectSdkByDefault(context);
    }

    public static Sdk getProjectSdkByDefault(WizardContext context) {
        Project project = context.getProject() == null ? ProjectManager.getInstance().getDefaultProject() : context.getProject();
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (projectJdk != null) {
            return projectJdk;
        }
        return null;
    }

    @NotNull
    public String getNewProjectFilePath() {
        if (this.myWizardContext.getProjectStorageFormat() == StorageScheme.DEFAULT) {
            return this.myWizardContext.getProjectFileDirectory() + File.separator + this.myWizardContext.getProjectName() + ".ipr";
        }
        return this.myWizardContext.getProjectFileDirectory();
    }

    @NotNull
    public StorageScheme getStorageScheme() {
        return this.myWizardContext.getProjectStorageFormat();
    }

    public ProjectBuilder getProjectBuilder() {
        return this.myWizardContext.getProjectBuilder();
    }

    public String getProjectName() {
        return this.myWizardContext.getProjectName();
    }

    @Nullable
    public Sdk getNewProjectJdk() {
        return AbstractProjectWizard.getNewProjectJdk(this.myWizardContext);
    }

    @NotNull
    public String getNewCompileOutput() {
        String projectFilePath = this.myWizardContext.getProjectFileDirectory();
        String path = this.myWizardContext.getCompilerOutputDirectory();
        if (path == null) {
            path = StringUtil.endsWithChar((CharSequence)projectFilePath, (char)'/') ? projectFilePath + "out" : projectFilePath + "/out";
        }
        return path;
    }

    @Nullable
    public ProjectBuilder getBuilder(Project project) {
        ProjectBuilder builder = this.getProjectBuilder();
        if (builder instanceof ModuleBuilder) {
            ModuleBuilder moduleBuilder = (ModuleBuilder)builder;
            if (moduleBuilder.getName() == null) {
                moduleBuilder.setName(this.getProjectName());
            }
            if (moduleBuilder.getModuleFilePath() == null) {
                moduleBuilder.setModuleFilePath(this.getModuleFilePath());
            }
        }
        if (builder == null || !builder.validate(project, project)) {
            return null;
        }
        return builder;
    }

    protected void updateStep() {
        if (!this.mySteps.isEmpty()) {
            ((ModuleWizardStep)this.getCurrentStepObject()).updateStep();
        }
        super.updateStep();
        this.myIcon.setIcon(null);
    }

    protected void dispose() {
        StepSequence sequence = this.getSequence();
        if (sequence != null) {
            for (ModuleWizardStep step2 : sequence.getAllSteps()) {
                step2.disposeUIResources();
            }
        }
        super.dispose();
    }

    protected final void doOKAction() {
        if (!this.doFinishAction()) {
            return;
        }
        super.doOKAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean doFinishAction() {
        if (this.myDelegate != null) {
            this.myDelegate.doFinishAction();
            return true;
        }
        int idx = this.getCurrentStep();
        try {
            while (true) {
                ModuleWizardStep step2;
                if ((step2 = (ModuleWizardStep)this.mySteps.get(idx)) != this.getCurrentStepObject()) {
                    step2.updateStep();
                }
                if (!this.commitStepData(step2)) {
                    boolean bl = false;
                    return bl;
                }
                step2.onStepLeaving();
                try {
                    step2._commit(true);
                }
                catch (CommitStepException e) {
                    this.handleCommitException(e);
                    boolean bl = false;
                    this.myCurrentStep = idx;
                    this.updateStep();
                    return bl;
                }
                if (this.isLastStep(idx)) break;
                idx = this.getNextStep(idx);
            }
            for (ModuleWizardStep wizardStep : this.mySteps) {
                try {
                    wizardStep.onWizardFinished();
                }
                catch (CommitStepException e) {
                    this.handleCommitException(e);
                    boolean bl = false;
                    this.myCurrentStep = idx;
                    this.updateStep();
                    return bl;
                }
            }
        }
        finally {
            this.myCurrentStep = idx;
            this.updateStep();
        }
        return true;
    }

    private void handleCommitException(CommitStepException e) {
        String message2 = e.getMessage();
        if (message2 != null) {
            Messages.showErrorDialog((Component)this.getCurrentStepComponent(), (String)message2);
        }
    }

    protected boolean commitStepData(ModuleWizardStep step2) {
        try {
            if (!step2.validate()) {
                return false;
            }
        }
        catch (ConfigurationException e) {
            Messages.showErrorDialog((Component)this.myContentPanel, (String)e.getMessage(), (String)e.getTitle());
            return false;
        }
        step2.updateDataModel();
        return true;
    }

    public void doNextAction() {
        if (this.myDelegate != null) {
            this.myDelegate.doNextAction();
            return;
        }
        ModuleWizardStep step2 = (ModuleWizardStep)this.getCurrentStepObject();
        if (!this.commitStepData(step2)) {
            return;
        }
        step2.onStepLeaving();
        super.doNextAction();
    }

    protected String getHelpID() {
        ModuleWizardStep step2 = (ModuleWizardStep)this.getCurrentStepObject();
        if (step2 != null) {
            return step2.getHelpId();
        }
        return null;
    }

    public boolean isLast() {
        return this.isLastStep();
    }

    @NonNls
    public String getModuleFilePath() {
        return this.myWizardContext.getProjectFileDirectory() + File.separator + this.myWizardContext.getProjectName() + ".iml";
    }

    protected void doPreviousAction() {
        if (this.myDelegate != null) {
            this.myDelegate.doPreviousAction();
            return;
        }
        ModuleWizardStep step2 = (ModuleWizardStep)this.getCurrentStepObject();
        step2.onStepLeaving();
        if (step2 instanceof StepWithSubSteps) {
            ((StepWithSubSteps)step2).doPreviousAction();
        }
        super.doPreviousAction();
    }

    protected boolean canGoNext() {
        return this.myDelegate != null ? this.myDelegate.canProceed() : super.canGoNext();
    }

    public void doCancelAction() {
        ModuleWizardStep step2 = (ModuleWizardStep)this.getCurrentStepObject();
        step2.onStepLeaving();
        super.doCancelAction();
    }

    protected boolean isLastStep() {
        return this.isLastStep(this.getCurrentStep());
    }

    private boolean isLastStep(int step2) {
        return this.getNextStep(step2) == step2 && !AbstractProjectWizard.isStepWithNotCompletedSubSteps((ModuleWizardStep)this.mySteps.get(step2));
    }

    protected final int getNextStep(int step2) {
        ModuleWizardStep nextStep = null;
        StepSequence stepSequence = this.getSequence();
        if (stepSequence != null) {
            ModuleWizardStep current = (ModuleWizardStep)this.mySteps.get(step2);
            if (AbstractProjectWizard.isStepWithNotCompletedSubSteps(current)) {
                return step2;
            }
            nextStep = stepSequence.getNextStep(current);
            while (nextStep != null && !nextStep.isStepVisible()) {
                nextStep = stepSequence.getNextStep(nextStep);
            }
        }
        return nextStep == null ? step2 : this.mySteps.indexOf(nextStep);
    }

    protected final int getPreviousStep(int step2) {
        ModuleWizardStep previousStep = null;
        StepSequence stepSequence = this.getSequence();
        if (stepSequence != null) {
            ModuleWizardStep current = (ModuleWizardStep)this.mySteps.get(step2);
            if (AbstractProjectWizard.isNotFirstSubStepInStep(current)) {
                return step2;
            }
            previousStep = stepSequence.getPreviousStep(current);
            while (previousStep != null && !previousStep.isStepVisible()) {
                previousStep = stepSequence.getPreviousStep(previousStep);
            }
        }
        return previousStep == null ? 0 : this.mySteps.indexOf(previousStep);
    }

    private static boolean isStepWithNotCompletedSubSteps(ModuleWizardStep current) {
        return current instanceof StepWithSubSteps && !((StepWithSubSteps)current).isLast();
    }

    private static boolean isNotFirstSubStepInStep(ModuleWizardStep current) {
        return current instanceof StepWithSubSteps && !((StepWithSubSteps)current).isFirst();
    }

    public void setDelegate(@Nullable WizardDelegate delegate) {
        this.myDelegate = delegate;
    }
}

