/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.MultiStateElementsChooser;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ProjectLayoutPanel<T>
extends JPanel {
    private final ElementsChooser<T> myEntriesChooser;
    private final JList myDependenciesList;
    private final ModuleInsight myInsight;
    private final Comparator<T> COMPARATOR = (o1, o2) -> {
        int w2;
        int w1 = this.getWeight(o1);
        if (w1 != (w2 = this.getWeight(o2))) {
            return w1 - w2;
        }
        return ProjectLayoutPanel.getElementText(o1).compareToIgnoreCase(ProjectLayoutPanel.getElementText(o2));
    };

    ProjectLayoutPanel(ModuleInsight insight) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.myInsight = insight;
        this.myEntriesChooser = new ElementsChooser<T>(true){

            public String getItemText(@NotNull T element) {
                return ProjectLayoutPanel.getElementText(element);
            }
        };
        this.myDependenciesList = this.createList();
        Splitter splitter = new Splitter(false);
        JPanel entriesPanel = new JPanel(new BorderLayout());
        entriesPanel.add((Component)this.myEntriesChooser, "Center");
        entriesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)StringUtil.capitalize((String)StringUtil.pluralize((String)this.getElementTypeName())), (boolean)false));
        splitter.setFirstComponent((JComponent)entriesPanel);
        JScrollPane depsPane = ScrollPaneFactory.createScrollPane((Component)this.myDependenciesList);
        JPanel depsPanel = new JPanel(new BorderLayout());
        depsPanel.add((Component)depsPane, "Center");
        depsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.getDependenciesTitle(), (boolean)false));
        splitter.setSecondComponent((JComponent)depsPanel);
        JPanel groupPanel = new JPanel(new BorderLayout());
        groupPanel.add((Component)this.createEntriesActionToolbar().getComponent(), "North");
        groupPanel.add((Component)splitter, "Center");
        groupPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        MultiLineLabel description = new MultiLineLabel(this.getStepDescriptionText());
        this.add((Component)description, "North");
        this.add((Component)groupPanel, "Center");
        this.myEntriesChooser.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                List entries = ProjectLayoutPanel.this.getSelectedEntries();
                Collection deps = ProjectLayoutPanel.this.getDependencies(entries);
                DefaultListModel depsModel = (DefaultListModel)ProjectLayoutPanel.this.myDependenciesList.getModel();
                depsModel.clear();
                for (Object dep : ProjectLayoutPanel.this.alphaSortList(new ArrayList(deps))) {
                    depsModel.addElement(dep);
                }
            }
        });
    }

    private ActionToolbar createEntriesActionToolbar() {
        DefaultActionGroup entriesActions = new DefaultActionGroup();
        RenameAction rename = new RenameAction();
        rename.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(117, 64)), this);
        entriesActions.add((AnAction)rename);
        MergeAction merge = new MergeAction();
        merge.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(114, 0)), this);
        entriesActions.add((AnAction)merge);
        SplitAction split = new SplitAction();
        split.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(115, 0)), this);
        entriesActions.add((AnAction)split);
        return ActionManager.getInstance().createActionToolbar("ProjectLayoutPanel.Entries", (ActionGroup)entriesActions, true);
    }

    public final ModuleInsight getInsight() {
        return this.myInsight;
    }

    private JList createList() {
        JBList list = new JBList(new DefaultListModel());
        list.getSelectionModel().setSelectionMode(2);
        list.setCellRenderer(new MyListCellRenderer());
        return list;
    }

    public final Collection getDependencies(List<? extends T> entries) {
        HashSet deps = new HashSet();
        for (T et : entries) {
            deps.addAll(this.getDependencies(et));
        }
        return deps;
    }

    @NotNull
    public List<T> getSelectedEntries() {
        return this.myEntriesChooser.getSelectedElements();
    }

    @NotNull
    public List<T> getChosenEntries() {
        return this.myEntriesChooser.getMarkedElements();
    }

    public void rebuild() {
        this.myEntriesChooser.clear();
        for (T entry : this.alphaSortList(this.getEntries())) {
            this.myEntriesChooser.addElement(entry, true, (MultiStateElementsChooser.ElementProperties)new EntryProperties(entry));
        }
        if (this.myEntriesChooser.getElementCount() > 0) {
            this.myEntriesChooser.selectElements(Collections.singleton(this.myEntriesChooser.getElementAt(0)));
        }
    }

    private List<T> alphaSortList(List<T> entries) {
        entries.sort(this.COMPARATOR);
        return entries;
    }

    @Nullable
    protected Icon getElementIcon(Object element) {
        if (element instanceof ModuleDescriptor) {
            return ((ModuleDescriptor)element).getModuleType().getIcon();
        }
        if (element instanceof LibraryDescriptor) {
            return PlatformIcons.LIBRARY_ICON;
        }
        if (element instanceof File) {
            File file = (File)element;
            return file.isDirectory() ? PlatformIcons.FOLDER_ICON : PlatformIcons.JAR_ICON;
        }
        return null;
    }

    protected int getWeight(Object element) {
        if (element instanceof File) {
            return 10;
        }
        if (element instanceof ModuleDescriptor) {
            return 20;
        }
        if (element instanceof LibraryDescriptor) {
            return ((LibraryDescriptor)element).getJars().size() > 1 ? 30 : 40;
        }
        return Integer.MAX_VALUE;
    }

    protected static String getElementText(Object element) {
        if (element instanceof LibraryDescriptor) {
            File parentFile;
            StringBuilder builder = new StringBuilder();
            builder.append(((LibraryDescriptor)element).getName());
            Collection<File> jars = ((LibraryDescriptor)element).getJars();
            if (jars.size() == 1 && (parentFile = jars.iterator().next().getParentFile()) != null) {
                builder.append(" (");
                builder.append(parentFile.getPath());
                builder.append(")");
            }
            return builder.toString();
        }
        if (element instanceof File) {
            StringBuilder builder = new StringBuilder();
            builder.append(((File)element).getName());
            File parentFile = ((File)element).getParentFile();
            if (parentFile != null) {
                builder.append(" (");
                builder.append(parentFile.getPath());
                builder.append(")");
            }
            return builder.toString();
        }
        if (element instanceof ModuleDescriptor) {
            Collection<? extends DetectedProjectRoot> sourceRoots;
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)element;
            StringBuilder builder = new StringBuilder();
            builder.append(moduleDescriptor.getName());
            Set<File> contents = moduleDescriptor.getContentRoots();
            int rootCount = contents.size();
            if (rootCount > 0) {
                builder.append(" (");
                builder.append(contents.iterator().next().getPath());
                if (rootCount > 1) {
                    builder.append("...");
                }
                builder.append(")");
            }
            if ((sourceRoots = moduleDescriptor.getSourceRoots()).size() > 0) {
                StringJoiner joiner = new StringJoiner(",", " [", "]");
                for (DetectedProjectRoot detectedProjectRoot : sourceRoots) {
                    joiner.add(detectedProjectRoot.getDirectory().getName());
                }
                builder.append(joiner);
            }
            return builder.toString();
        }
        return "";
    }

    protected abstract List<T> getEntries();

    protected abstract Collection getDependencies(T var1);

    @Nullable
    protected abstract T merge(List<? extends T> var1);

    @Nullable
    protected abstract T split(T var1, String var2, Collection<? extends File> var3);

    protected abstract Collection<File> getContent(T var1);

    protected abstract String getElementName(T var1);

    protected abstract void setElementName(T var1, String var2);

    protected abstract String getSplitDialogChooseFilesPrompt();

    protected abstract String getNameAlreadyUsedMessage(String var1);

    protected abstract String getStepDescriptionText();

    protected abstract String getEntriesChooserTitle();

    protected abstract String getDependenciesTitle();

    protected abstract String getElementTypeName();

    private boolean isNameAlreadyUsed(String entryName) {
        HashSet itemsToIgnore = new HashSet(this.myEntriesChooser.getSelectedElements());
        for (T entry : this.getEntries()) {
            if (itemsToIgnore.contains(entry) || !entryName.equals(this.getElementName(entry))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private InputValidator getValidator() {
        return new InputValidator(){

            public boolean checkInput(String inputString) {
                return true;
            }

            public boolean canClose(String inputString) {
                if (ProjectLayoutPanel.this.isNameAlreadyUsed(inputString.trim())) {
                    Messages.showErrorDialog((String)ProjectLayoutPanel.this.getNameAlreadyUsedMessage(inputString), (String)"");
                    return false;
                }
                return true;
            }
        };
    }

    private class EntryProperties
    implements MultiStateElementsChooser.ElementProperties {
        private final T myEntry;

        EntryProperties(T entry) {
            this.myEntry = entry;
        }

        public Icon getIcon() {
            return ProjectLayoutPanel.this.getElementIcon(this.myEntry);
        }
    }

    private class SplitDialog
    extends DialogWrapper {
        final JTextField myNameField;
        final ElementsChooser<File> myChooser;

        private SplitDialog(Collection<File> files) {
            super((Component)ProjectLayoutPanel.this.myEntriesChooser, true);
            this.setTitle(JavaUiBundle.message("dialog.title.split.module.or.library.0", StringUtil.capitalize((String)ProjectLayoutPanel.this.getElementTypeName())));
            this.myNameField = new JTextField();
            this.myChooser = new ElementsChooser<File>(true){

                protected String getItemText(@NotNull File value2) {
                    return ProjectLayoutPanel.getElementText(value2);
                }
            };
            for (final File file : files) {
                this.myChooser.addElement((Object)file, false, new MultiStateElementsChooser.ElementProperties(){

                    public Icon getIcon() {
                        return ProjectLayoutPanel.this.getElementIcon(file);
                    }
                });
            }
            this.myChooser.selectElements((Collection)ContainerUtil.createMaybeSingletonList((Object)ContainerUtil.getFirstItem(files)));
            this.myChooser.addElementsMarkListener((ElementsChooser.ElementsMarkListener)new ElementsChooser.ElementsMarkListener<File>(){

                public void elementMarkChanged(File element, boolean isMarked) {
                    SplitDialog.this.updateOkButton();
                }
            });
            this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    SplitDialog.this.updateOkButton();
                }
            });
            this.init();
            this.updateOkButton();
        }

        private void updateOkButton() {
            this.setOKActionEnabled(!this.getName().isEmpty() && !this.getChosenFiles().isEmpty());
        }

        protected void doOKAction() {
            String name2 = this.getName();
            if (ProjectLayoutPanel.this.isNameAlreadyUsed(name2)) {
                Messages.showErrorDialog((String)ProjectLayoutPanel.this.getNameAlreadyUsedMessage(name2), (String)"");
                return;
            }
            super.doOKAction();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            FormBuilder builder = FormBuilder.createFormBuilder().setVertical(true);
            builder.addLabeledComponent(JavaUiBundle.message("label.project.layout.panel.name", new Object[0]), (JComponent)this.myNameField);
            builder.addLabeledComponent(ProjectLayoutPanel.this.getSplitDialogChooseFilesPrompt(), this.myChooser);
            this.myChooser.setPreferredSize((Dimension)JBUI.size((int)450, (int)300));
            return builder.getPanel();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myNameField;
        }

        public String getName() {
            return this.myNameField.getText().trim();
        }

        public Collection<File> getChosenFiles() {
            return this.myChooser.getMarkedElements();
        }
    }

    private class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value2, index, isSelected, cellHasFocus);
            this.setText(ProjectLayoutPanel.getElementText(value2));
            this.setIcon(ProjectLayoutPanel.this.getElementIcon(value2));
            return comp;
        }
    }

    private class RenameAction
    extends AnAction {
        private RenameAction() {
            super(CommonBundle.messagePointer((String)"action.text.rename", (Object[])new Object[0]), () -> "", IconUtil.getEditIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List elements = ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements();
            if (elements.size() == 1) {
                Object element = elements.get(0);
                String newName = Messages.showInputDialog((Component)ProjectLayoutPanel.this, (String)JavaUiBundle.message("label.new.name.for.0.1", ProjectLayoutPanel.this.getElementTypeName(), ProjectLayoutPanel.this.getElementName(element)), (String)JavaUiBundle.message("dialog.title.rename.module.or.library.0", StringUtil.capitalize((String)ProjectLayoutPanel.this.getElementTypeName())), (Icon)Messages.getQuestionIcon(), (String)ProjectLayoutPanel.this.getElementName(element), (InputValidator)ProjectLayoutPanel.this.getValidator());
                if (newName != null) {
                    ProjectLayoutPanel.this.setElementName(element, newName);
                    ProjectLayoutPanel.this.myEntriesChooser.sort(ProjectLayoutPanel.this.COMPARATOR);
                    ProjectLayoutPanel.this.myEntriesChooser.selectElements(Collections.singleton(element));
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements().size() == 1);
        }
    }

    private class SplitAction
    extends AnAction {
        private SplitAction() {
            super(CommonBundle.messagePointer((String)"action.text.split", (Object[])new Object[0]), () -> "", AllIcons.Modules.Split);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Collection<File> chosenFiles;
            String newName;
            Object extracted;
            Object entry;
            Collection<File> files;
            SplitDialog dialog;
            List elements = ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements();
            if (elements.size() == 1 && (dialog = new SplitDialog(files = ProjectLayoutPanel.this.getContent(entry = elements.get(0)))).showAndGet() && (extracted = ProjectLayoutPanel.this.split(entry, newName = dialog.getName(), chosenFiles = dialog.getChosenFiles())) != null) {
                if (!ProjectLayoutPanel.this.getEntries().contains(entry)) {
                    ProjectLayoutPanel.this.myEntriesChooser.removeElement(entry);
                }
                ProjectLayoutPanel.this.myEntriesChooser.addElement(extracted, true, (MultiStateElementsChooser.ElementProperties)new EntryProperties(extracted));
                ProjectLayoutPanel.this.myEntriesChooser.sort(ProjectLayoutPanel.this.COMPARATOR);
                ProjectLayoutPanel.this.myEntriesChooser.selectElements(Collections.singleton(extracted));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            List elements = ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements();
            e.getPresentation().setEnabled(elements.size() == 1 && ProjectLayoutPanel.this.getContent(elements.get(0)).size() > 1);
        }
    }

    private class MergeAction
    extends AnAction {
        private MergeAction() {
            super(CommonBundle.messagePointer((String)"action.text.merge", (Object[])new Object[0]), () -> "", AllIcons.Vcs.Merge);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String newName;
            List elements = ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements();
            if (elements.size() > 1 && (newName = Messages.showInputDialog((Component)ProjectLayoutPanel.this, (String)JavaUiBundle.message("label.enter.new.name.for.merge.result", new Object[0]), (String)JavaUiBundle.message("dialog.title.merge.module.or.library", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)ProjectLayoutPanel.this.getElementName(elements.get(0)), (InputValidator)ProjectLayoutPanel.this.getValidator())) != null) {
                Object merged = ProjectLayoutPanel.this.merge(elements);
                ProjectLayoutPanel.this.setElementName(merged, newName);
                for (Object element : elements) {
                    ProjectLayoutPanel.this.myEntriesChooser.removeElement(element);
                }
                ProjectLayoutPanel.this.myEntriesChooser.addElement(merged, true, (MultiStateElementsChooser.ElementProperties)new EntryProperties(merged));
                ProjectLayoutPanel.this.myEntriesChooser.sort(ProjectLayoutPanel.this.COMPARATOR);
                ProjectLayoutPanel.this.myEntriesChooser.selectElements(Collections.singleton(merged));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements().size() > 1);
        }
    }
}

