/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.ide.util.TreeFileChooser;
import com.intellij.ide.util.TreeFileChooserDialog;
import com.intellij.ide.util.TreeJavaClassChooserDialog;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeClassChooserFactoryImpl
extends TreeClassChooserFactory {
    @NotNull
    private final Project myProject;

    public TreeClassChooserFactoryImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public TreeClassChooser createWithInnerClassesScopeChooser(String title, GlobalSearchScope scope, ClassFilter classFilter, PsiClass initialClass) {
        return TreeJavaClassChooserDialog.withInnerClasses(title, this.myProject, scope, classFilter, initialClass);
    }

    @NotNull
    public TreeClassChooser createNoInnerClassesScopeChooser(String title, GlobalSearchScope scope, ClassFilter classFilter, PsiClass initialClass) {
        return new TreeJavaClassChooserDialog(title, this.myProject, scope, classFilter, initialClass);
    }

    @NotNull
    public TreeClassChooser createProjectScopeChooser(String title, PsiClass initialClass) {
        return new TreeJavaClassChooserDialog(title, this.myProject, initialClass);
    }

    @NotNull
    public TreeClassChooser createProjectScopeChooser(String title) {
        return new TreeJavaClassChooserDialog(title, this.myProject);
    }

    @NotNull
    public TreeClassChooser createAllProjectScopeChooser(String title) {
        return new TreeJavaClassChooserDialog(title, this.myProject, GlobalSearchScope.allScope((Project)this.myProject), null, null);
    }

    @NotNull
    public TreeClassChooser createInheritanceClassChooser(String title, GlobalSearchScope scope, PsiClass base, boolean acceptsSelf, boolean acceptInner, @Nullable Condition<? super PsiClass> additionalCondition) {
        TreeJavaClassChooserDialog.InheritanceJavaClassFilterImpl classFilter = new TreeJavaClassChooserDialog.InheritanceJavaClassFilterImpl(base, acceptsSelf, acceptInner, additionalCondition);
        return new TreeJavaClassChooserDialog(title, this.myProject, scope, classFilter, base, null, false);
    }

    @NotNull
    public TreeClassChooser createInheritanceClassChooser(String title, GlobalSearchScope scope, PsiClass base, PsiClass initialClass) {
        return this.createInheritanceClassChooser(title, scope, base, initialClass, null);
    }

    @NotNull
    public TreeClassChooser createInheritanceClassChooser(String title, GlobalSearchScope scope, PsiClass base, PsiClass initialClass, ClassFilter classFilter) {
        return new TreeJavaClassChooserDialog(title, this.myProject, scope, classFilter, base, initialClass, false);
    }

    @NotNull
    public TreeFileChooser createFileChooser(@NotNull String title, PsiFile initialFile, FileType fileType, TreeFileChooser.PsiFileFilter filter) {
        return new TreeFileChooserDialog(this.myProject, title, initialFile, fileType, filter, false, false);
    }

    @NotNull
    public TreeFileChooser createFileChooser(@NotNull String title, @Nullable PsiFile initialFile, @Nullable FileType fileType, @Nullable TreeFileChooser.PsiFileFilter filter, boolean disableStructureProviders) {
        return new TreeFileChooserDialog(this.myProject, title, initialFile, fileType, filter, disableStructureProviders, false);
    }

    @NotNull
    public TreeFileChooser createFileChooser(@NotNull String title, @Nullable PsiFile initialFile, @Nullable FileType fileType, @Nullable TreeFileChooser.PsiFileFilter filter, boolean disableStructureProviders, boolean showLibraryContents) {
        return new TreeFileChooserDialog(this.myProject, title, initialFile, fileType, filter, disableStructureProviders, showLibraryContents);
    }
}

