/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Deprecated
class AddAllMembersProcessor
implements PsiScopeProcessor {
    private final Collection<PsiElement> myAllMembers;
    private final PsiClass myPsiClass;
    private final Map<MethodSignature, PsiMethod> myMethodsBySignature = new HashMap<MethodSignature, PsiMethod>();

    AddAllMembersProcessor(@NotNull Collection<PsiElement> allMembers, @NotNull PsiClass psiClass) {
        for (PsiElement psiElement : allMembers) {
            if (!(psiElement instanceof PsiMethod)) continue;
            this.mapMethodBySignature((PsiMethod)psiElement);
        }
        this.myAllMembers = allMembers;
        this.myPsiClass = psiClass;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        PsiMember member = (PsiMember)element;
        if (!AddAllMembersProcessor.isInteresting(element)) {
            return true;
        }
        if (this.myPsiClass.isInterface() && AddAllMembersProcessor.isObjectMember(element)) {
            return true;
        }
        if (!this.myAllMembers.contains(member) && this.isVisible(member, this.myPsiClass)) {
            if (member instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)member;
                if (this.shouldAdd(psiMethod)) {
                    this.mapMethodBySignature(psiMethod);
                    this.myAllMembers.add(PsiImplUtil.handleMirror((PsiElement)psiMethod));
                }
            } else {
                this.myAllMembers.add(PsiImplUtil.handleMirror((PsiElement)member));
            }
        }
        return true;
    }

    private static boolean isObjectMember(PsiElement element) {
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiClass containingClass = ((PsiMethod)element).getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        return qualifiedName != null && qualifiedName.equals(Object.class.getName());
    }

    private void mapMethodBySignature(PsiMethod psiMethod) {
        this.myMethodsBySignature.put(psiMethod.getSignature(PsiSubstitutor.EMPTY), psiMethod);
    }

    private boolean shouldAdd(PsiMethod psiMethod) {
        MethodSignature signature = psiMethod.getSignature(PsiSubstitutor.EMPTY);
        PsiMethod previousMethod = this.myMethodsBySignature.get(signature);
        if (previousMethod == null) {
            return true;
        }
        if (AddAllMembersProcessor.isInheritor(psiMethod, previousMethod)) {
            this.myAllMembers.remove(previousMethod);
            return true;
        }
        return false;
    }

    private static boolean isInteresting(PsiElement element) {
        return element instanceof PsiMethod || element instanceof PsiField || element instanceof PsiClass || element instanceof PsiClassInitializer;
    }

    public static boolean isInheritor(PsiMethod method, PsiMethod baseMethod) {
        return !AddAllMembersProcessor.isStatic(method) && !AddAllMembersProcessor.isStatic(baseMethod) && method.getContainingClass().isInheritor(baseMethod.getContainingClass(), true);
    }

    private static boolean isStatic(PsiMethod method) {
        return method.hasModifierProperty("static");
    }

    private boolean isVisible(@NotNull PsiMember element, PsiClass psiClass) {
        return !AddAllMembersProcessor.isInheritedConstructor(element, psiClass) && PsiUtil.isAccessible((PsiMember)element, (PsiElement)psiClass, null);
    }

    private static boolean isInheritedConstructor(PsiMember member, PsiClass psiClass) {
        if (!(member instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)member;
        return method.isConstructor() && method.getContainingClass() != psiClass;
    }
}

