/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.ModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.PackageViewModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PackageViewModuleGroupNode
extends ModuleGroupNode {
    public PackageViewModuleGroupNode(Project project, @NotNull ModuleGroup value2, ViewSettings viewSettings) {
        super(project, value2, viewSettings);
    }

    @NotNull
    protected AbstractTreeNode createModuleNode(@NotNull Module module) {
        return new PackageViewModuleNode(module.getProject(), module, this.getSettings());
    }

    @NotNull
    protected ModuleGroupNode createModuleGroupNode(@NotNull ModuleGroup moduleGroup) {
        return new PackageViewModuleGroupNode(this.getProject(), moduleGroup, this.getSettings());
    }

    @NotNull
    protected List<Module> getModulesByFile(@NotNull VirtualFile file) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        Module module = fileIndex.getModuleForFile(file, false);
        if (module != null) {
            return Collections.singletonList(module);
        }
        List entriesForFile = fileIndex.getOrderEntriesForFile(file);
        return ContainerUtil.map((Collection)entriesForFile, OrderEntry::getOwnerModule);
    }
}

