/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.LibrariesElement;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PackageViewLibrariesNode
extends ProjectViewNode<LibrariesElement> {
    public PackageViewLibrariesNode(Project project, Module module, ViewSettings viewSettings) {
        super(project, (Object)new LibrariesElement(module, project), viewSettings);
    }

    public boolean contains(@NotNull VirtualFile file) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        if (!index.isInLibrary(file)) {
            return false;
        }
        return this.someChildContainsFile(file, false);
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        return (Collection)AbstractTreeUi.calculateYieldingToWriteAction(() -> {
            ArrayList roots = new ArrayList();
            Module myModule = ((LibrariesElement)this.getValue()).getModule();
            if (myModule == null) {
                Module[] modules;
                for (Module module : modules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
                    PackageViewLibrariesNode.addModuleLibraryRoots(ModuleRootManager.getInstance((Module)module), roots);
                }
            } else {
                PackageViewLibrariesNode.addModuleLibraryRoots(ModuleRootManager.getInstance((Module)myModule), roots);
            }
            return PackageUtil.createPackageViewChildrenOnFiles(roots, this.getProject(), this.getSettings(), null, true);
        });
    }

    public boolean someChildContainsFile(VirtualFile file) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        if (!index.isInLibrary(file)) {
            return false;
        }
        return super.someChildContainsFile(file);
    }

    private static void addModuleLibraryRoots(ModuleRootManager moduleRootManager, List<? super VirtualFile> roots) {
        VirtualFile[] files;
        for (VirtualFile file : files = moduleRootManager.orderEntries().withoutModuleSourceEntries().withoutDepModules().classes().getRoots()) {
            if (file.getFileSystem() instanceof JarFileSystem && file.getParent() != null) continue;
            roots.add((VirtualFile)file);
        }
    }

    public void update(@NotNull PresentationData presentation) {
        presentation.setPresentableText(IdeBundle.message((String)"node.projectview.libraries", (Object[])new Object[0]));
        presentation.setIcon(PlatformIcons.LIBRARY_ICON);
    }

    public String getTestPresentation() {
        return "Libraries";
    }

    public boolean shouldUpdateData() {
        return true;
    }

    public int getWeight() {
        return 60;
    }
}

