/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.type.SubtypesHierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.TypeHierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class TypeHierarchyTreeStructure
extends SubtypesHierarchyTreeStructure {
    public TypeHierarchyTreeStructure(@NotNull Project project, @NotNull PsiClass aClass, String currentScopeType) {
        super(project, TypeHierarchyTreeStructure.buildHierarchyElement(project, aClass), currentScopeType);
        this.setBaseElement(this.myBaseDescriptor);
    }

    @NotNull
    private static HierarchyNodeDescriptor buildHierarchyElement(@NotNull Project project, @NotNull PsiClass aClass) {
        TypeHierarchyNodeDescriptor descriptor = null;
        PsiClass[] superClasses = TypeHierarchyTreeStructure.createSuperClasses(aClass);
        for (int i = superClasses.length - 1; i >= 0; --i) {
            PsiClass superClass = superClasses[i];
            TypeHierarchyNodeDescriptor newDescriptor = new TypeHierarchyNodeDescriptor(project, descriptor, (PsiElement)superClass, false);
            if (descriptor != null) {
                descriptor.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
            }
            descriptor = newDescriptor;
        }
        TypeHierarchyNodeDescriptor newDescriptor = new TypeHierarchyNodeDescriptor(project, descriptor, (PsiElement)aClass, true);
        if (descriptor != null) {
            descriptor.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
        }
        return newDescriptor;
    }

    @NotNull
    private static PsiClass[] createSuperClasses(@NotNull PsiClass aClass) {
        if (!aClass.isValid()) {
            return PsiClass.EMPTY_ARRAY;
        }
        if (aClass.isInterface()) {
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> superClasses = new ArrayList<PsiClass>();
        while (!"java.lang.Object".equals(aClass.getQualifiedName())) {
            PsiClass aClass1 = aClass;
            PsiClass[] superTypes = aClass1.getSupers();
            PsiClass superType = null;
            for (PsiClass type2 : superTypes) {
                if (type2.isInterface()) continue;
                superType = type2;
                break;
            }
            if (superType == null || superClasses.contains(superType)) break;
            superClasses.add(superType);
            aClass = superType;
        }
        return superClasses.toArray(PsiClass.EMPTY_ARRAY);
    }

    public String toString() {
        return "Type Hierarchy for " + this.formatBaseElementText();
    }
}

