/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import org.jetbrains.annotations.NotNull;

public final class TypeHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    public TypeHierarchyNodeDescriptor(@NotNull Project project, HierarchyNodeDescriptor parentDescriptor, @NotNull PsiElement classOrFunctionalExpression, boolean isBase) {
        super(project, (NodeDescriptor)parentDescriptor, classOrFunctionalExpression, isBase);
    }

    public final PsiElement getPsiClass() {
        return this.getPsiElement();
    }

    public final boolean update() {
        boolean changes2 = super.update();
        if (this.getPsiElement() == null) {
            return this.invalidElement();
        }
        if (changes2 && this.myIsBase) {
            this.setIcon(this.getBaseMarkerIcon(this.getIcon()));
        }
        PsiElement psiElement = this.getPsiClass();
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        if (psiElement instanceof PsiClass) {
            this.myHighlightedText.getEnding().addText(ClassPresentationUtil.getNameForClass((PsiClass)psiElement, false), classNameAttributes);
            this.myHighlightedText.getEnding().addText(" (" + JavaHierarchyUtil.getPackageName((PsiClass)psiElement) + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        } else if (psiElement instanceof PsiFunctionalExpression) {
            this.myHighlightedText.getEnding().addText(ClassPresentationUtil.getFunctionalExpressionPresentation((PsiFunctionalExpression)psiElement, false));
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes2 = true;
        }
        return changes2;
    }
}

