/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.call;

import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CalleeMethodsTreeStructure;
import com.intellij.ide.hierarchy.call.CallerMethodsTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.PopupHandler;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class CallHierarchyBrowser
extends CallHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance(CallHierarchyBrowser.class);

    public CallHierarchyBrowser(@NotNull Project project, @NotNull PsiMember method) {
        super(project, (PsiElement)method);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public CallHierarchyBrowser(@NotNull Project project, @NotNull PsiMethod method) {
        super(project, (PsiElement)method);
    }

    protected void createTrees(@NotNull Map<String, JTree> type2TreeMap) {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("CallHierarchyPopupMenu");
        JTree tree1 = this.createTree(false);
        PopupHandler.installPopupHandler((JComponent)tree1, (ActionGroup)group, (String)"CallHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        BaseOnThisMethodAction baseOnThisMethodAction = new BaseOnThisMethodAction();
        baseOnThisMethodAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("CallHierarchy").getShortcutSet(), tree1);
        type2TreeMap.put(CallHierarchyBrowser.getCalleeType(), tree1);
        JTree tree2 = this.createTree(false);
        PopupHandler.installPopupHandler((JComponent)tree2, (ActionGroup)group, (String)"CallHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        baseOnThisMethodAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("CallHierarchy").getShortcutSet(), tree2);
        type2TreeMap.put(CallHierarchyBrowser.getCallerType(), tree2);
    }

    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor instanceof CallHierarchyNodeDescriptor) {
            CallHierarchyNodeDescriptor nodeDescriptor = (CallHierarchyNodeDescriptor)descriptor;
            return nodeDescriptor.getEnclosingElement();
        }
        return null;
    }

    protected PsiElement getOpenFileElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor instanceof CallHierarchyNodeDescriptor) {
            CallHierarchyNodeDescriptor nodeDescriptor = (CallHierarchyNodeDescriptor)descriptor;
            return nodeDescriptor.getTargetElement();
        }
        return null;
    }

    protected boolean isApplicableElement(@NotNull PsiElement e) {
        return e instanceof PsiMethod || e instanceof PsiField;
    }

    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement) {
        if (CallHierarchyBrowser.getCallerType().equals(typeName)) {
            return new CallerMethodsTreeStructure(this.myProject, (PsiMember)psiElement, this.getCurrentScopeType());
        }
        if (CallHierarchyBrowser.getCalleeType().equals(typeName)) {
            return new CalleeMethodsTreeStructure(this.myProject, (PsiMember)psiElement, this.getCurrentScopeType());
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    protected Comparator<NodeDescriptor<?>> getComparator() {
        return JavaHierarchyUtil.getComparator(this.myProject);
    }

    public static final class BaseOnThisMethodAction
    extends CallHierarchyBrowserBase.BaseOnThisMethodAction {
    }
}

