/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.smartPointerPsiNodes.FieldSmartPointerNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiFieldFavoriteNodeProvider
extends FavoriteNodeProvider {
    public Collection<AbstractTreeNode<?>> getFavoriteNodes(DataContext context, @NotNull ViewSettings viewSettings) {
        PsiElement element;
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return null;
        }
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context);
        if (elements == null && (element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context)) != null) {
            elements = new PsiElement[]{element};
        }
        if (elements != null) {
            ArrayList result = new ArrayList();
            for (PsiElement element2 : elements) {
                if (!(element2 instanceof PsiField)) continue;
                result.add((AbstractTreeNode<?>)new FieldSmartPointerNode(project, (PsiField)element2, viewSettings));
            }
            return result.isEmpty() ? null : result;
        }
        return null;
    }

    public AbstractTreeNode createNode(Project project, Object element, @NotNull ViewSettings viewSettings) {
        if (element instanceof PsiField) {
            return new FieldSmartPointerNode(project, (PsiField)element, viewSettings);
        }
        return super.createNode(project, element, viewSettings);
    }

    public boolean elementContainsFile(Object element, VirtualFile vFile) {
        return false;
    }

    public int getElementWeight(Object value2, boolean isSortByType) {
        if (value2 instanceof PsiField) {
            return 4;
        }
        return -1;
    }

    public String getElementLocation(Object element) {
        PsiClass psiClass;
        if (element instanceof PsiField && (psiClass = ((PsiField)element).getContainingClass()) != null) {
            return ClassPresentationUtil.getNameForClass(psiClass, true);
        }
        return null;
    }

    public boolean isInvalidElement(Object element) {
        return element instanceof PsiField && !((PsiField)element).isValid();
    }

    @NotNull
    public String getFavoriteTypeId() {
        return "field";
    }

    public String getElementUrl(Object element) {
        if (element instanceof PsiField) {
            PsiField aField = (PsiField)element;
            return aField.getContainingClass().getQualifiedName() + ";" + aField.getName();
        }
        return null;
    }

    public String getElementModuleName(Object element) {
        if (element instanceof PsiField) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiField)element));
            return module != null ? module.getName() : null;
        }
        return null;
    }

    public Object[] createPathFromUrl(Project project, String url, String moduleName) {
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        Module module = moduleName != null ? ModuleManager.getInstance((Project)project).findModuleByName(moduleName) : null;
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleScope((Module)module) : GlobalSearchScope.allScope((Project)project);
        String[] paths = url.split(";");
        if (paths.length != 2) {
            return null;
        }
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(paths[0], scope);
        if (aClass == null) {
            return null;
        }
        PsiField aField = aClass.findFieldByName(paths[1], false);
        return new Object[]{aField};
    }
}

