/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaVirtualFileQualifiedNameProvider
implements CopyReferenceAction.VirtualFileQualifiedNameProvider {
    @Nullable
    public String getQualifiedName(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        String relative;
        Module module = ProjectFileIndex.getInstance((Project)project).getModuleForFile(virtualFile, false);
        if (module == null || !ModuleType.is((Module)module, (ModuleType)JavaModuleType.getModuleType())) {
            return null;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile sourceRoot = index.getSourceRootForFile(virtualFile);
        if (sourceRoot != null && !sourceRoot.equals(virtualFile)) {
            return Objects.requireNonNull(VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)sourceRoot, (char)'/'));
        }
        Object outerMostRoot = null;
        for (VirtualFile each = virtualFile; each != null && (each = index.getContentRootForFile(each, false)) != null; each = each.getParent()) {
            outerMostRoot = each;
        }
        if (outerMostRoot != null && !outerMostRoot.equals(virtualFile) && (relative = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)outerMostRoot, (char)'/')) != null) {
            return relative;
        }
        return virtualFile.getPath();
    }
}

