/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.actions.NewProjectAction;
import com.intellij.ide.actions.NewProjectOrModuleAction;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ui.configuration.actions.NewModuleAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.DeprecatedProjectBuilderForImport;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportModuleAction
extends AnAction
implements NewProjectOrModuleAction {
    private static final String LAST_IMPORTED_LOCATION = "last.imported.location";
    private static final Logger LOG = Logger.getInstance(ImportModuleAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        ImportModuleAction.doImport(ImportModuleAction.getEventProject((AnActionEvent)e));
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(ImportModuleAction.getEventProject((AnActionEvent)e) != null);
        NewProjectAction.updateActionText(this, e);
    }

    @Override
    @NotNull
    public String getActionText(boolean isInNewSubmenu, boolean isInJavaIde) {
        return JavaUiBundle.message("import.module.action.text", isInNewSubmenu ? 1 : 0, isInJavaIde ? 1 : 0);
    }

    public boolean isDumbAware() {
        return true;
    }

    public static List<Module> doImport(@Nullable Project project) {
        AddModuleWizard wizard = ImportModuleAction.selectFileAndCreateWizard(project, null);
        if (wizard == null || wizard.getStepCount() > 0 && !wizard.showAndGet()) {
            return Collections.emptyList();
        }
        return ImportModuleAction.createFromWizard(project, wizard);
    }

    public static List<Module> createFromWizard(@Nullable Project project, AbstractProjectWizard wizard) {
        try {
            List<Module> list = ImportModuleAction.doCreateFromWizard(project, wizard);
            return list;
        }
        finally {
            wizard.disposeIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Module> doCreateFromWizard(@Nullable Project project, AbstractProjectWizard wizard) {
        ProjectBuilder projectBuilder = wizard.getProjectBuilder();
        if (project == null) {
            Project newProject = projectBuilder instanceof DeprecatedProjectBuilderForImport ? ImportModuleAction.openProject((DeprecatedProjectBuilderForImport)projectBuilder, wizard.getNewProjectFilePath()) : NewProjectUtil.createFromWizard(wizard);
            return newProject == null ? Collections.emptyList() : Arrays.asList(ModuleManager.getInstance((Project)newProject).getModules());
        }
        try {
            if (wizard.getStepCount() > 0) {
                Module module = new NewModuleAction().createModuleFromWizard(project, null, wizard);
                List<Module> list = Collections.singletonList(module);
                return list;
            }
            if (!projectBuilder.validate(project, project)) {
                List<Module> list = Collections.emptyList();
                return list;
            }
            List list = projectBuilder.commit(project);
            return list;
        }
        finally {
            if (projectBuilder != null) {
                projectBuilder.cleanup();
            }
        }
    }

    @Nullable
    private static Project openProject(@NotNull DeprecatedProjectBuilderForImport projectBuilder, @NotNull String projectPath) {
        VirtualFile file = ProjectUtil.getFileAndRefresh((Path)Paths.get(projectPath, new String[0]));
        if (file == null) {
            LOG.warn(String.format("Cannot find project file in vfs `%s`", projectPath));
            return null;
        }
        return projectBuilder.getProjectOpenProcessor().doOpenProject(file, null, false);
    }

    @Nullable
    public static AddModuleWizard selectFileAndCreateWizard(@Nullable Project project, @Nullable Component dialogParent) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        descriptor.setHideIgnored(false);
        descriptor.setTitle(JavaUiBundle.message("chooser.title.select.file.or.directory.to.import", new Object[0]));
        List<ProjectImportProvider> providers2 = ImportModuleAction.getProviders(project);
        String description = ImportModuleAction.getFileChooserDescription(providers2);
        descriptor.setDescription(description);
        return ImportModuleAction.selectFileAndCreateWizard(project, dialogParent, descriptor, providers2.toArray(new ProjectImportProvider[0]));
    }

    @Nullable
    public static AddModuleWizard selectFileAndCreateWizard(@Nullable Project project, @Nullable Component dialogParent, @NotNull FileChooserDescriptor descriptor, ProjectImportProvider[] providers2) {
        VirtualFile[] files;
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, project, dialogParent);
        VirtualFile toSelect = null;
        String lastLocation = PropertiesComponent.getInstance().getValue(LAST_IMPORTED_LOCATION);
        if (lastLocation != null) {
            toSelect = LocalFileSystem.getInstance().refreshAndFindFileByPath(lastLocation);
        }
        if ((files = chooser.choose(project, new VirtualFile[]{toSelect})).length == 0) {
            return null;
        }
        VirtualFile file = files[0];
        if (project == null) {
            for (Project p : ProjectManager.getInstance().getOpenProjects()) {
                if (!ProjectUtil.isSameProject((Path)file.toNioPath(), (Project)p)) continue;
                ProjectUtil.focusProjectWindow((Project)p, (boolean)false);
                return null;
            }
        }
        PropertiesComponent.getInstance().setValue(LAST_IMPORTED_LOCATION, file.getPath());
        return ImportModuleAction.createImportWizard(project, dialogParent, file, providers2);
    }

    private static String getFileChooserDescription(List<ProjectImportProvider> providers2) {
        StringBuilder builder = new StringBuilder("<html>Select ");
        boolean first = true;
        if (providers2.size() > 0) {
            for (ProjectImportProvider provider : providers2) {
                String sample = provider.getFileSample();
                if (sample == null) continue;
                if (!first) {
                    builder.append(", <br>");
                } else {
                    first = false;
                }
                builder.append(sample);
            }
        }
        builder.append(".</html>");
        return builder.toString();
    }

    @NotNull
    public static List<ProjectImportProvider> getProviders(@Nullable Project project) {
        Object[] providers2 = (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions();
        return ContainerUtil.filter((Object[])providers2, provider -> project == null ? provider.canCreateNewProject() : provider.canImportModule());
    }

    @Nullable
    public static AddModuleWizard createImportWizard(@Nullable Project project, @Nullable Component dialogParent, @NotNull VirtualFile file, ProjectImportProvider ... providers2) {
        List available = ContainerUtil.filter((Object[])providers2, provider -> provider.canImport(file, project));
        if (available.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)JavaUiBundle.message("message.cannot.import.anything.from.0", file.getPath()), (String)JavaUiBundle.message("dialog.title.cannot.import", new Object[0]));
            return null;
        }
        String path = available.size() == 1 ? ((ProjectImportProvider)available.get(0)).getPathToBeImported(file) : ProjectImportProvider.getDefaultPath(file);
        ProjectImportProvider[] availableProviders = available.toArray(new ProjectImportProvider[0]);
        return dialogParent == null ? new AddModuleWizard(project, path, availableProviders) : new AddModuleWizard(project, dialogParent, path, availableProviders);
    }
}

